/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import android.os.Build;
import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpDelete;
import ch.boye.httpclientandroidlib.client.methods.HttpGet;
import ch.boye.httpclientandroidlib.client.methods.HttpPatch;
import ch.boye.httpclientandroidlib.client.methods.HttpPost;
import ch.boye.httpclientandroidlib.client.methods.HttpPut;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.conn.ClientConnectionManager;
import ch.boye.httpclientandroidlib.conn.scheme.PlainSocketFactory;
import ch.boye.httpclientandroidlib.conn.scheme.Scheme;
import ch.boye.httpclientandroidlib.conn.scheme.SchemeRegistry;
import ch.boye.httpclientandroidlib.conn.scheme.SchemeSocketFactory;
import ch.boye.httpclientandroidlib.conn.ssl.SSLSocketFactory;
import ch.boye.httpclientandroidlib.entity.StringEntity;
import ch.boye.httpclientandroidlib.impl.client.BasicAuthCache;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.ThreadSafeClientConnManager;
import ch.boye.httpclientandroidlib.params.HttpConnectionParams;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.params.HttpProtocolParams;
import ch.boye.httpclientandroidlib.protocol.BasicHttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.GlobalConstants;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.HttpResponseObserver;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.ResourceDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class BaseResource
implements Resource {
    private static final String ANDROID_LOOPBACK_IP = "10.0.2.2";
    private static final int MAX_TOTAL_CONNECTIONS = 20;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 10;
    private boolean retryOnFailedRequest = true;
    public static boolean rewriteLocalhost = true;
    private static final String LOG_TAG = "BaseResource";
    protected final URI uri;
    protected BasicHttpContext context;
    protected DefaultHttpClient client;
    public ResourceDelegate delegate;
    protected HttpRequestBase request;
    public final String charset = "utf-8";
    protected static final CopyOnWriteArrayList<WeakReference<HttpResponseObserver>> httpResponseObservers = new CopyOnWriteArrayList();
    private static final Object connManagerMonitor = new Object();
    private static ClientConnectionManager connManager;

    public BaseResource(String string2) throws URISyntaxException {
        this(string2, rewriteLocalhost);
    }

    public BaseResource(URI uRI) {
        this(uRI, rewriteLocalhost);
    }

    public BaseResource(String string2, boolean bl) throws URISyntaxException {
        this(new URI(string2), bl);
    }

    public BaseResource(URI uRI, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (bl && "localhost".equals(uRI.getHost())) {
            Logger.debug(LOG_TAG, "Rewriting " + uRI + " to point to " + ANDROID_LOOPBACK_IP + ".");
            try {
                this.uri = new URI(uRI.getScheme(), uRI.getUserInfo(), ANDROID_LOOPBACK_IP, uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.error(LOG_TAG, "Got error rewriting URI for Android emulator.", uRISyntaxException);
                throw new IllegalArgumentException("Invalid URI", uRISyntaxException);
            }
        } else {
            this.uri = uRI;
        }
    }

    public static void addHttpResponseObserver(HttpResponseObserver httpResponseObserver) {
        if (httpResponseObserver == null) {
            return;
        }
        httpResponseObservers.add(new WeakReference<HttpResponseObserver>(httpResponseObserver));
    }

    public static boolean isHttpResponseObserver(HttpResponseObserver httpResponseObserver) {
        for (WeakReference<HttpResponseObserver> weakReference : httpResponseObservers) {
            HttpResponseObserver httpResponseObserver2 = (HttpResponseObserver)weakReference.get();
            if (httpResponseObserver2 != httpResponseObserver) continue;
            return true;
        }
        return false;
    }

    public static boolean removeHttpResponseObserver(HttpResponseObserver httpResponseObserver) {
        for (WeakReference<HttpResponseObserver> weakReference : httpResponseObservers) {
            HttpResponseObserver httpResponseObserver2 = (HttpResponseObserver)weakReference.get();
            if (httpResponseObserver2 != httpResponseObserver) continue;
            httpResponseObservers.remove(weakReference);
            return true;
        }
        return false;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getURIString() {
        return this.uri.toString();
    }

    @Override
    public String getHostname() {
        return this.getURI().getHost();
    }

    private static void addAuthCacheToContext(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        BasicAuthCache basicAuthCache = new BasicAuthCache();
        httpContext.setAttribute("http.auth.auth-cache", (Object)basicAuthCache);
    }

    protected void prepareClient() throws KeyManagementException, NoSuchAlgorithmException, GeneralSecurityException {
        Header header;
        this.context = new BasicHttpContext();
        this.client = new DefaultHttpClient(BaseResource.getConnectionManager());
        AuthHeaderProvider authHeaderProvider = this.delegate.getAuthHeaderProvider();
        if (authHeaderProvider != null && (header = authHeaderProvider.getAuthHeader(this.request, this.context, this.client)) != null) {
            this.request.addHeader(header);
            Logger.debug(LOG_TAG, "Added auth header.");
        }
        BaseResource.addAuthCacheToContext((HttpUriRequest)this.request, (HttpContext)this.context);
        header = this.client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)header, (int)this.delegate.connectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)header, (int)this.delegate.socketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)header, (boolean)false);
        HttpProtocolParams.setContentCharset((HttpParams)header, (String)"utf-8");
        HttpProtocolParams.setVersion((HttpParams)header, (ProtocolVersion)HttpVersion.HTTP_1_1);
        String string2 = this.delegate.getUserAgent();
        if (string2 != null) {
            HttpProtocolParams.setUserAgent((HttpParams)header, (String)string2);
        }
        this.delegate.addHeaders(this.request, this.client);
    }

    private static ClientConnectionManager enableTLSConnectionManager() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, null, new SecureRandom());
        Logger.debug(LOG_TAG, "Using protocols and cipher suites for Android API " + Build.VERSION.SDK_INT);
        SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(sSLContext, GlobalConstants.DEFAULT_PROTOCOLS, GlobalConstants.DEFAULT_CIPHER_SUITES, null);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactory));
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)new PlainSocketFactory()));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(schemeRegistry);
        threadSafeClientConnManager.setMaxTotal(20);
        threadSafeClientConnManager.setDefaultMaxPerRoute(10);
        connManager = threadSafeClientConnManager;
        return threadSafeClientConnManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientConnectionManager getConnectionManager() throws KeyManagementException, NoSuchAlgorithmException {
        Object object = connManagerMonitor;
        synchronized (object) {
            if (connManager != null) {
                return connManager;
            }
            return BaseResource.enableTLSConnectionManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeExpiredConnections() {
        ClientConnectionManager clientConnectionManager;
        Object object = connManagerMonitor;
        synchronized (object) {
            clientConnectionManager = connManager;
        }
        if (clientConnectionManager == null) {
            return;
        }
        Logger.trace(LOG_TAG, "Closing expired connections.");
        clientConnectionManager.closeExpiredConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownConnectionManager() {
        ClientConnectionManager clientConnectionManager;
        Object object = connManagerMonitor;
        synchronized (object) {
            clientConnectionManager = connManager;
            connManager = null;
        }
        if (clientConnectionManager == null) {
            return;
        }
        Logger.debug(LOG_TAG, "Shutting down connection manager.");
        clientConnectionManager.shutdown();
    }

    private void execute() {
        CloseableHttpResponse closeableHttpResponse;
        try {
            closeableHttpResponse = this.client.execute((HttpUriRequest)this.request, (HttpContext)this.context);
            Logger.debug(LOG_TAG, "Response: " + closeableHttpResponse.getStatusLine().toString());
        }
        catch (ClientProtocolException clientProtocolException) {
            this.delegate.handleHttpProtocolException(clientProtocolException);
            return;
        }
        catch (IOException iOException) {
            Logger.debug(LOG_TAG, "I/O exception returned from execute.");
            if (!this.retryOnFailedRequest) {
                this.delegate.handleHttpIOException(iOException);
            } else {
                this.retryRequest();
            }
            return;
        }
        catch (Exception exception) {
            if (!this.retryOnFailedRequest) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                this.delegate.handleHttpIOException(iOException);
            } else {
                this.retryRequest();
            }
            return;
        }
        for (WeakReference<HttpResponseObserver> weakReference : httpResponseObservers) {
            HttpResponseObserver httpResponseObserver = (HttpResponseObserver)weakReference.get();
            if (httpResponseObserver == null) continue;
            httpResponseObserver.observeHttpResponse((HttpUriRequest)this.request, (HttpResponse)closeableHttpResponse);
        }
        this.delegate.handleHttpResponse((HttpResponse)closeableHttpResponse);
    }

    private void retryRequest() {
        this.retryOnFailedRequest = false;
        Logger.debug(LOG_TAG, "Retrying request...");
        this.execute();
    }

    private void go(HttpRequestBase httpRequestBase) {
        if (this.delegate == null) {
            throw new IllegalArgumentException("No delegate provided.");
        }
        this.request = httpRequestBase;
        try {
            this.prepareClient();
        }
        catch (KeyManagementException keyManagementException) {
            Logger.error(LOG_TAG, "Couldn't prepare client.", keyManagementException);
            this.delegate.handleTransportException(keyManagementException);
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            Logger.error(LOG_TAG, "Couldn't prepare client.", generalSecurityException);
            this.delegate.handleTransportException(generalSecurityException);
            return;
        }
        catch (Exception exception) {
            this.delegate.handleTransportException(new GeneralSecurityException(exception));
            return;
        }
        this.execute();
    }

    @Override
    public void get() {
        Logger.debug(LOG_TAG, "HTTP GET " + this.uri.toASCIIString());
        this.go((HttpRequestBase)new HttpGet(this.uri));
    }

    public void getBlocking() {
        this.get();
    }

    @Override
    public void delete() {
        Logger.debug(LOG_TAG, "HTTP DELETE " + this.uri.toASCIIString());
        this.go((HttpRequestBase)new HttpDelete(this.uri));
    }

    @Override
    public void post(HttpEntity httpEntity) {
        Logger.debug(LOG_TAG, "HTTP POST " + this.uri.toASCIIString());
        HttpPost httpPost = new HttpPost(this.uri);
        httpPost.setEntity(httpEntity);
        this.go((HttpRequestBase)httpPost);
    }

    @Override
    public void patch(HttpEntity httpEntity) {
        Logger.debug(LOG_TAG, "HTTP PATCH " + this.uri.toASCIIString());
        HttpPatch httpPatch = new HttpPatch(this.uri);
        httpPatch.setEntity(httpEntity);
        this.go((HttpRequestBase)httpPatch);
    }

    @Override
    public void put(HttpEntity httpEntity) {
        Logger.debug(LOG_TAG, "HTTP PUT " + this.uri.toASCIIString());
        HttpPut httpPut = new HttpPut(this.uri);
        httpPut.setEntity(httpEntity);
        this.go((HttpRequestBase)httpPut);
    }

    protected static StringEntity stringEntityWithContentTypeApplicationJSON(String string2) {
        StringEntity stringEntity = new StringEntity(string2, "UTF-8");
        stringEntity.setContentType("application/json");
        return stringEntity;
    }

    protected static StringEntity jsonEntity(JSONObject jSONObject) {
        return BaseResource.stringEntityWithContentTypeApplicationJSON(jSONObject.toJSONString());
    }

    protected static StringEntity jsonEntity(ExtendedJSONObject extendedJSONObject) {
        return BaseResource.stringEntityWithContentTypeApplicationJSON(extendedJSONObject.toJSONString());
    }

    protected static HttpEntity jsonEntity(JSONArray jSONArray) throws UnsupportedEncodingException {
        return BaseResource.stringEntityWithContentTypeApplicationJSON(jSONArray.toJSONString());
    }

    public static void consumeEntity(HttpEntity httpEntity) {
        try {
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consumeEntity(HttpResponse httpResponse) {
        if (httpResponse == null) {
            return;
        }
        try {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consumeEntity(SyncStorageResponse syncStorageResponse) {
        if (syncStorageResponse.httpResponse() == null) {
            return;
        }
        BaseResource.consumeEntity(syncStorageResponse.httpResponse());
    }

    public static void consumeReader(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void post(JSONArray jSONArray) throws UnsupportedEncodingException {
        this.post(BaseResource.jsonEntity(jSONArray));
    }

    public void put(JSONObject jSONObject) throws UnsupportedEncodingException {
        this.put((HttpEntity)BaseResource.jsonEntity(jSONObject));
    }

    public void post(ExtendedJSONObject extendedJSONObject) {
        this.post((HttpEntity)BaseResource.jsonEntity(extendedJSONObject));
    }

    public void post(JSONObject jSONObject) throws UnsupportedEncodingException {
        this.post((HttpEntity)BaseResource.jsonEntity(jSONObject));
    }

    public void patch(JSONArray jSONArray) throws UnsupportedEncodingException {
        this.patch(BaseResource.jsonEntity(jSONArray));
    }

    public void patch(ExtendedJSONObject extendedJSONObject) {
        this.patch((HttpEntity)BaseResource.jsonEntity(extendedJSONObject));
    }

    public void patch(JSONObject jSONObject) throws UnsupportedEncodingException {
        this.patch((HttpEntity)BaseResource.jsonEntity(jSONObject));
    }
}

