/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.RemoteException;
import android.os.SystemClock;
import java.io.IOException;
import org.json.simple.JSONArray;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecord;

public class RepoUtils {
    private static final String LOG_TAG = "RepoUtils";

    public static String optStringFromCursor(Cursor cursor, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (cursor.isNull(n)) {
            return null;
        }
        return cursor.getString(n);
    }

    public static String getStringFromCursor(Cursor cursor, String string2) {
        return cursor.getString(cursor.getColumnIndex(string2));
    }

    public static long getLongFromCursor(Cursor cursor, String string2) {
        return cursor.getLong(cursor.getColumnIndex(string2));
    }

    public static int getIntFromCursor(Cursor cursor, String string2) {
        return cursor.getInt(cursor.getColumnIndex(string2));
    }

    public static JSONArray getJSONArrayFromCursor(Cursor cursor, String string2) {
        String string3 = RepoUtils.getStringFromCursor(cursor, string2);
        if (string3 == null) {
            return new JSONArray();
        }
        try {
            return ExtendedJSONObject.parseJSONArray(RepoUtils.getStringFromCursor(cursor, string2));
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            Logger.error(LOG_TAG, "JSON parsing error for " + string2, nonArrayJSONException);
            return null;
        }
        catch (IOException iOException) {
            Logger.error(LOG_TAG, "JSON parsing error for " + string2, iOException);
            return null;
        }
        catch (ParseException parseException) {
            Logger.error(LOG_TAG, "JSON parsing error for " + string2, parseException);
            return null;
        }
    }

    public static boolean isValidHistoryURI(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            return true;
        }
        String string3 = Uri.parse((String)string2).getScheme();
        if (string3 == null) {
            return false;
        }
        return !string3.equals("about") && !string3.equals("imap") && !string3.equals("news") && !string3.equals("mailbox") && !string3.equals("moz-anno") && !string3.equals("view-source") && !string3.equals("chrome") && !string3.equals("resource") && !string3.equals("data") && !string3.equals("wyciwyg") && !string3.equals("javascript");
    }

    public static HistoryRecord historyFromMirrorCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        if (string2 == null) {
            Logger.debug(LOG_TAG, "Skipping history record with null GUID.");
            return null;
        }
        String string3 = RepoUtils.getStringFromCursor(cursor, "url");
        if (!RepoUtils.isValidHistoryURI(string3)) {
            Logger.debug(LOG_TAG, "Skipping history record " + string2 + " with unwanted/invalid URI " + string3);
            return null;
        }
        long l = RepoUtils.getLongFromCursor(cursor, "visits");
        if (l <= 0L) {
            Logger.debug(LOG_TAG, "Skipping history record " + string2 + " with <= 0 visit count.");
            return null;
        }
        long l2 = RepoUtils.getLongFromCursor(cursor, "modified");
        boolean bl = RepoUtils.getLongFromCursor(cursor, "deleted") == 1L;
        HistoryRecord historyRecord = new HistoryRecord(string2, "history", l2, bl);
        historyRecord.androidID = RepoUtils.getLongFromCursor(cursor, "_id");
        historyRecord.fennecDateVisited = RepoUtils.getLongFromCursor(cursor, "date");
        historyRecord.fennecVisitCount = l;
        historyRecord.histURI = string3;
        historyRecord.title = RepoUtils.getStringFromCursor(cursor, "title");
        return RepoUtils.logHistory(historyRecord);
    }

    private static HistoryRecord logHistory(HistoryRecord historyRecord) {
        try {
            Logger.debug(LOG_TAG, "Returning history record " + historyRecord.guid + " (" + historyRecord.androidID + ")");
            Logger.debug(LOG_TAG, "> Visited:          " + historyRecord.fennecDateVisited);
            Logger.debug(LOG_TAG, "> Visits:           " + historyRecord.fennecVisitCount);
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii(LOG_TAG, "> Title:            " + historyRecord.title);
                Logger.pii(LOG_TAG, "> URI:              " + historyRecord.histURI);
            }
        }
        catch (Exception exception) {
            Logger.debug(LOG_TAG, "Exception logging history record " + historyRecord, exception);
        }
        return historyRecord;
    }

    public static void logClient(ClientRecord clientRecord) {
        if (Logger.shouldLogVerbose(LOG_TAG)) {
            Logger.trace(LOG_TAG, "Returning client record " + clientRecord.guid + " (" + clientRecord.androidID + ")");
            Logger.trace(LOG_TAG, "Client Name:   " + clientRecord.name);
            Logger.trace(LOG_TAG, "Client Type:   " + clientRecord.type);
            Logger.trace(LOG_TAG, "Last Modified: " + clientRecord.lastModified);
            Logger.trace(LOG_TAG, "Deleted:       " + clientRecord.deleted);
        }
    }

    public static void queryTimeLogger(String string2, long l, long l2) {
        long l3 = l2 - l;
        Logger.debug(LOG_TAG, "Query timer: " + string2 + " took " + l3 + "ms.");
    }

    public static boolean stringsEqual(String string2, String string3) {
        if (string2 == string3) {
            return true;
        }
        if (string2 == null && string3 != null) {
            return false;
        }
        if (string2 != null && string3 == null) {
            return false;
        }
        return string2.equals(string3);
    }

    public static String computeSQLLongInClause(long[] lArray, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        for (n = 0; n < lArray.length - 1; ++n) {
            stringBuilder.append(lArray[n]);
            stringBuilder.append(", ");
        }
        if (n < lArray.length) {
            stringBuilder.append(lArray[n]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String computeSQLInClause(int n, String string2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        for (n2 = 0; n2 < n - 1; ++n2) {
            stringBuilder.append("?, ");
        }
        if (n2 < n) {
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static class QueryHelper {
        private final Context context;
        private final Uri uri;
        private final String tag;

        public QueryHelper(Context context, Uri uri, String string2) {
            this.context = context;
            this.uri = uri;
            this.tag = string2;
        }

        public Cursor safeQuery(String string2, String[] stringArray, String string3, String[] stringArray2, String string4) throws NullCursorException {
            long l = SystemClock.uptimeMillis();
            Cursor cursor = this.context.getContentResolver().query(this.uri, stringArray, string3, stringArray2, string4);
            return this.checkAndLogCursor(string2, l, cursor);
        }

        public Cursor safeQuery(String[] stringArray, String string2, String[] stringArray2, String string3) throws NullCursorException {
            return this.safeQuery(null, stringArray, string2, stringArray2, string3);
        }

        public Cursor safeQuery(ContentProviderClient contentProviderClient, String string2, String[] stringArray, String string3, String[] stringArray2, String string4) throws NullCursorException, RemoteException {
            long l = SystemClock.uptimeMillis();
            Cursor cursor = contentProviderClient.query(this.uri, stringArray, string3, stringArray2, string4);
            return this.checkAndLogCursor(string2, l, cursor);
        }

        public Cursor safeQuery(SQLiteDatabase sQLiteDatabase, String string2, String string3, String[] stringArray, String string4, String[] stringArray2, String string5, String string6, String string7, String string8) throws NullCursorException {
            long l = SystemClock.uptimeMillis();
            Cursor cursor = sQLiteDatabase.query(string3, stringArray, string4, stringArray2, string5, string6, string7, string8);
            return this.checkAndLogCursor(string2, l, cursor);
        }

        public Cursor safeQuery(SQLiteDatabase sQLiteDatabase, String string2, String string3, String[] stringArray, String string4, String[] stringArray2) throws NullCursorException {
            return this.safeQuery(sQLiteDatabase, string2, string3, stringArray, string4, stringArray2, null, null, null, null);
        }

        private Cursor checkAndLogCursor(String string2, long l, Cursor cursor) throws NullCursorException {
            long l2 = SystemClock.uptimeMillis();
            String string3 = string2 == null ? this.tag : this.tag + string2;
            RepoUtils.queryTimeLogger(string3, l, l2);
            return this.checkNullCursor(string3, cursor);
        }

        public Cursor checkNullCursor(String string2, Cursor cursor) throws NullCursorException {
            if (cursor == null) {
                Logger.error(this.tag, "Got null cursor exception in " + string2);
                throw new NullCursorException(null);
            }
            return cursor;
        }
    }
}

