/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;
import org.mozilla.gecko.toolbar.PageActionLayout;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.widget.ThemedLinearLayout;
import org.mozilla.gecko.widget.ThemedTextView;

public class ToolbarDisplayLayout
extends ThemedLinearLayout
implements Animation.AnimationListener {
    private static final String LOGTAG = "GeckoToolbarDisplayLayout";
    private final BrowserApp mActivity;
    private UIMode mUiMode;
    private boolean mIsAttached;
    private final ThemedTextView mTitle;
    private final int mTitlePadding;
    private ToolbarPrefs mPrefs;
    private OnTitleChangeListener mTitleChangeListener;
    private final ImageButton mSiteSecurity;
    private boolean mSiteSecurityVisible;
    private Bitmap mLastFavicon;
    private final ImageButton mFavicon;
    private int mFaviconSize;
    private final ImageButton mStop;
    private OnStopListener mStopListener;
    private final PageActionLayout mPageActionLayout;
    private AlphaAnimation mLockFadeIn;
    private TranslateAnimation mTitleSlideLeft;
    private TranslateAnimation mTitleSlideRight;
    private final SiteIdentityPopup mSiteIdentityPopup;
    private int mSecurityImageLevel;
    private final int LEVEL_SHIELD_ENABLED = 3;
    private final int LEVEL_SHIELD_DISABLED = 4;
    private final int LEVEL_LOCK_DISABLED = 5;
    private PropertyAnimator mForwardAnim;
    private final ForegroundColorSpan mUrlColor;
    private final ForegroundColorSpan mBlockedColor;
    private final ForegroundColorSpan mDomainColor;
    private final ForegroundColorSpan mPrivateDomainColor;

    public ToolbarDisplayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        this.mActivity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.toolbar_display_layout, (ViewGroup)this);
        this.mTitle = (ThemedTextView)this.findViewById(R.id.url_bar_title);
        this.mTitlePadding = this.mTitle.getPaddingRight();
        Resources resources = this.getResources();
        this.mUrlColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_urltext));
        this.mBlockedColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_blockedtext));
        this.mDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext));
        this.mPrivateDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext_private));
        this.mFavicon = (ImageButton)this.findViewById(R.id.favicon);
        this.mSiteSecurity = (ImageButton)this.findViewById(R.id.site_security);
        if (HardwareUtils.isTablet()) {
            this.mSiteSecurity.setVisibility(0);
            this.removeView((View)this.mFavicon);
        } else {
            if (AppConstants.Versions.feature16Plus) {
                this.mFavicon.setImportantForAccessibility(2);
            }
            this.mFaviconSize = Math.round(Favicons.browserToolbarFaviconSize);
        }
        this.mSiteSecurityVisible = this.mSiteSecurity.getVisibility() == 0;
        this.mSiteIdentityPopup = new SiteIdentityPopup((Context)this.mActivity);
        this.mSiteIdentityPopup.setAnchor((View)this);
        this.mSiteIdentityPopup.setOnVisibilityChangeListener(this.mActivity);
        this.mStop = (ImageButton)this.findViewById(R.id.stop);
        this.mPageActionLayout = (PageActionLayout)this.findViewById(R.id.page_action_layout);
    }

    @Override
    public void onAttachedToWindow() {
        this.mIsAttached = true;
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                ToolbarDisplayLayout.this.mSiteIdentityPopup.show();
            }
        };
        this.mFavicon.setOnClickListener(onClickListener);
        this.mSiteSecurity.setOnClickListener(onClickListener);
        this.mStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tab tab;
                if (ToolbarDisplayLayout.this.mStopListener != null && (tab = ToolbarDisplayLayout.this.mStopListener.onStop()) != null) {
                    ToolbarDisplayLayout.this.updateUiMode(tab, UIMode.DISPLAY, EnumSet.noneOf(UpdateFlags.class));
                }
            }
        });
        float f = this.getResources().getDimension(R.dimen.browser_toolbar_site_security_width);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mSiteSecurity.getLayoutParams();
        float f2 = this.getResources().getDisplayMetrics().density;
        this.mLockFadeIn = new AlphaAnimation(0.0f, 1.0f);
        this.mLockFadeIn.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideLeft = new TranslateAnimation(f += (float)(layoutParams.leftMargin + layoutParams.rightMargin) * f2 + 0.5f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideLeft.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideRight = new TranslateAnimation(-f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideRight.setAnimationListener((Animation.AnimationListener)this);
        this.mLockFadeIn.setDuration(300L);
        this.mTitleSlideLeft.setDuration(300L);
        this.mTitleSlideRight.setDuration(300L);
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
    }

    public void onAnimationStart(Animation animation) {
        if (animation.equals(this.mLockFadeIn)) {
            if (this.mSiteSecurityVisible) {
                this.mSiteSecurity.setVisibility(0);
            }
        } else if (animation.equals(this.mTitleSlideLeft)) {
            this.mSiteSecurity.setVisibility(8);
        } else if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.setVisibility(4);
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.startAnimation((Animation)this.mLockFadeIn);
        }
    }

    public void setNextFocusDownId(int n) {
        this.mFavicon.setNextFocusDownId(n);
        this.mStop.setNextFocusDownId(n);
        this.mSiteSecurity.setNextFocusDownId(n);
        this.mPageActionLayout.setNextFocusDownId(n);
    }

    void setToolbarPrefs(ToolbarPrefs toolbarPrefs) {
        this.mPrefs = toolbarPrefs;
    }

    void updateFromTab(Tab tab, EnumSet<UpdateFlags> enumSet) {
        if (!this.mIsAttached) {
            return;
        }
        if (enumSet.contains((Object)UpdateFlags.TITLE)) {
            this.updateTitle(tab);
        }
        if (enumSet.contains((Object)UpdateFlags.FAVICON)) {
            this.updateFavicon(tab);
        }
        if (enumSet.contains((Object)UpdateFlags.SITE_IDENTITY)) {
            this.updateSiteIdentity(tab, enumSet);
        }
        if (enumSet.contains((Object)UpdateFlags.PROGRESS)) {
            this.updateProgress(tab, enumSet);
        }
        if (enumSet.contains((Object)UpdateFlags.PRIVATE_MODE)) {
            this.mTitle.setPrivateMode(tab != null && tab.isPrivate());
        }
    }

    void setTitle(CharSequence charSequence) {
        this.mTitle.setText(charSequence);
        if (this.mTitleChangeListener != null) {
            this.mTitleChangeListener.onTitleChange(charSequence);
        }
    }

    private void updateTitle(Tab tab) {
        if (tab == null || tab.isEnteringReaderMode()) {
            return;
        }
        String string2 = tab.getURL();
        if (AboutPages.isTitlelessAboutPage(string2)) {
            this.setTitle(null);
            return;
        }
        if (tab.getErrorType() == Tab.ErrorType.BLOCKED) {
            String string3 = tab.getDisplayTitle();
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string3);
            spannableStringBuilder.setSpan((Object)this.mBlockedColor, 0, string3.length(), 18);
            this.setTitle((CharSequence)spannableStringBuilder);
            return;
        }
        if (!this.mPrefs.shouldShowUrl() || string2 == null) {
            this.setTitle(tab.getDisplayTitle());
            return;
        }
        String string4 = this.stripAboutReaderURL(string2);
        if (this.mPrefs.shouldTrimUrls()) {
            string4 = StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string4));
        }
        String string5 = string4;
        String string6 = tab.getBaseDomain();
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string5);
            int n = string5.toString().indexOf(string6);
            if (n > -1) {
                spannableStringBuilder.setSpan((Object)this.mUrlColor, 0, string5.length(), 18);
                spannableStringBuilder.setSpan((Object)(tab.isPrivate() ? this.mPrivateDomainColor : this.mDomainColor), n, n + string6.length(), 18);
                string5 = spannableStringBuilder;
            }
        }
        this.setTitle(string5);
    }

    private String stripAboutReaderURL(String string2) {
        if (!AboutPages.isAboutReader(string2)) {
            return string2;
        }
        return ReaderModeUtils.getUrlFromAboutReader(string2);
    }

    private void updateFavicon(Tab tab) {
        if (HardwareUtils.isTablet()) {
            return;
        }
        if (tab == null) {
            this.mFavicon.setImageDrawable(null);
            return;
        }
        Bitmap bitmap = tab.getFavicon();
        if (bitmap != null && bitmap == this.mLastFavicon) {
            Log.d((String)LOGTAG, (String)"Ignoring favicon: new image is identical to previous one.");
            return;
        }
        this.mLastFavicon = bitmap;
        Log.d((String)LOGTAG, (String)("updateFavicon(" + bitmap + ")"));
        if (bitmap != null) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mFaviconSize, (int)this.mFaviconSize, (boolean)false);
            this.mFavicon.setImageBitmap(bitmap);
        } else {
            this.mFavicon.setImageResource(R.drawable.favicon_globe);
        }
    }

    private void updateSiteIdentity(Tab tab, EnumSet<UpdateFlags> enumSet) {
        SiteIdentity.TrackingMode trackingMode;
        SiteIdentity.MixedMode mixedMode;
        SiteIdentity.SecurityMode securityMode;
        SiteIdentity siteIdentity = tab == null ? null : tab.getSiteIdentity();
        this.mSiteIdentityPopup.setSiteIdentity(siteIdentity);
        if (siteIdentity == null) {
            securityMode = SiteIdentity.SecurityMode.UNKNOWN;
            mixedMode = SiteIdentity.MixedMode.UNKNOWN;
            trackingMode = SiteIdentity.TrackingMode.UNKNOWN;
        } else {
            securityMode = siteIdentity.getSecurityMode();
            mixedMode = siteIdentity.getMixedMode();
            trackingMode = siteIdentity.getTrackingMode();
        }
        int n = securityMode.ordinal();
        if (trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_LOADED) {
            n = 4;
        } else if (trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED) {
            n = 3;
        } else if (mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_LOADED) {
            n = 5;
        }
        if (this.mSecurityImageLevel != n) {
            this.mSecurityImageLevel = n;
            this.mSiteSecurity.setImageLevel(this.mSecurityImageLevel);
            this.updatePageActions(enumSet);
        }
    }

    private void updateProgress(Tab tab, EnumSet<UpdateFlags> enumSet) {
        boolean bl = tab != null && tab.getState() == 1;
        this.updateUiMode(tab, bl ? UIMode.PROGRESS : UIMode.DISPLAY, enumSet);
    }

    private void updateUiMode(Tab tab, UIMode uIMode, EnumSet<UpdateFlags> enumSet) {
        if (this.mUiMode == uIMode) {
            return;
        }
        this.mUiMode = uIMode;
        if (this.mUiMode == UIMode.PROGRESS) {
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber start"));
        } else {
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber stop"));
        }
        this.updatePageActions(enumSet);
    }

    private void updatePageActions(EnumSet<UpdateFlags> enumSet) {
        boolean bl = this.mUiMode == UIMode.PROGRESS;
        this.mStop.setVisibility(bl ? 0 : 8);
        this.mPageActionLayout.setVisibility(!bl ? 0 : 8);
        boolean bl2 = !bl && this.mSecurityImageLevel > 0;
        this.setSiteSecurityVisibility(bl2, enumSet);
        this.mTitle.setPadding(0, 0, !bl ? this.mTitlePadding : 0, 0);
    }

    private void setSiteSecurityVisibility(boolean bl, EnumSet<UpdateFlags> enumSet) {
        if (bl == this.mSiteSecurityVisible || HardwareUtils.isTablet()) {
            return;
        }
        this.mSiteSecurityVisible = bl;
        this.mTitle.clearAnimation();
        this.mSiteSecurity.clearAnimation();
        if (enumSet.contains((Object)UpdateFlags.DISABLE_ANIMATIONS)) {
            this.mSiteSecurity.setVisibility(bl ? 0 : 8);
            return;
        }
        this.mLockFadeIn.reset();
        this.mTitleSlideLeft.reset();
        this.mTitleSlideRight.reset();
        if (this.mForwardAnim != null) {
            long l = this.mForwardAnim.getRemainingTime();
            this.mTitleSlideRight.setStartOffset(l);
            this.mTitleSlideLeft.setStartOffset(l);
        } else {
            this.mTitleSlideRight.setStartOffset(0L);
            this.mTitleSlideLeft.setStartOffset(0L);
        }
        this.mTitle.startAnimation((Animation)(bl ? this.mTitleSlideRight : this.mTitleSlideLeft));
    }

    List<View> getFocusOrder() {
        return Arrays.asList(new View[]{this.mSiteSecurity, this.mPageActionLayout, this.mStop});
    }

    void setOnStopListener(OnStopListener onStopListener) {
        this.mStopListener = onStopListener;
    }

    void setOnTitleChangeListener(OnTitleChangeListener onTitleChangeListener) {
        this.mTitleChangeListener = onTitleChangeListener;
    }

    void updateSiteIdentityAnchor(View view) {
        this.mSiteIdentityPopup.setAnchor(view);
    }

    void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        this.mForwardAnim = propertyAnimator;
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            ViewHelper.setTranslationX((View)this.mTitle, n);
            ViewHelper.setTranslationX((View)this.mFavicon, n);
            ViewHelper.setTranslationX((View)this.mSiteSecurity, n);
        } else {
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, n);
        }
    }

    void finishForwardAnimation() {
        ViewHelper.setTranslationX((View)this.mTitle, 0.0f);
        ViewHelper.setTranslationX((View)this.mFavicon, 0.0f);
        ViewHelper.setTranslationX((View)this.mSiteSecurity, 0.0f);
        this.mForwardAnim = null;
    }

    void prepareStartEditingAnimation() {
        ViewHelper.setAlpha((View)this.mPageActionLayout, 0.0f);
        ViewHelper.setAlpha((View)this.mStop, 0.0f);
    }

    void prepareStopEditingAnimation(PropertyAnimator propertyAnimator) {
        propertyAnimator.attach((View)this.mPageActionLayout, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach((View)this.mStop, PropertyAnimator.Property.ALPHA, 1.0f);
    }

    boolean dismissSiteIdentityPopup() {
        if (this.mSiteIdentityPopup != null && this.mSiteIdentityPopup.isShowing()) {
            this.mSiteIdentityPopup.dismiss();
            return true;
        }
        return false;
    }

    void destroy() {
        this.mSiteIdentityPopup.destroy();
    }

    static interface OnTitleChangeListener {
        public void onTitleChange(CharSequence var1);
    }

    static interface OnStopListener {
        public Tab onStop();
    }

    private static enum UIMode {
        PROGRESS,
        DISPLAY;

    }

    static enum UpdateFlags {
        TITLE,
        FAVICON,
        PROGRESS,
        SITE_IDENTITY,
        PRIVATE_MODE,
        DISABLE_ANIMATIONS;

    }
}

