/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class ContentSecurityDoorHanger
extends DoorHanger {
    private static final String LOGTAG = "GeckoSecurityDoorHanger";
    private final TextView mTitle = (TextView)this.findViewById(R.id.security_title);
    private final TextView mSecurityState = (TextView)this.findViewById(R.id.security_state);
    private final TextView mMessage = (TextView)this.findViewById(R.id.security_message);

    public ContentSecurityDoorHanger(Context context, DoorhangerConfig doorhangerConfig, DoorHanger.Type type) {
        super(context, doorhangerConfig, type);
        this.loadConfig(doorhangerConfig);
    }

    @Override
    protected void loadConfig(DoorhangerConfig doorhangerConfig) {
        DoorhangerConfig.Link link;
        JSONObject jSONObject;
        String string2 = doorhangerConfig.getMessage();
        if (string2 != null) {
            this.mMessage.setText((CharSequence)string2);
        }
        if ((jSONObject = doorhangerConfig.getOptions()) != null) {
            this.setOptions(jSONObject);
        }
        if ((link = doorhangerConfig.getLink()) != null) {
            this.addLink(link.label, link.url);
        }
        this.addButtonsToLayout(doorhangerConfig);
    }

    @Override
    protected int getContentResource() {
        return R.layout.doorhanger_security;
    }

    @Override
    public void setOptions(JSONObject jSONObject) {
        Object object;
        super.setOptions(jSONObject);
        JSONObject jSONObject2 = jSONObject.optJSONObject("link");
        if (jSONObject2 != null) {
            try {
                object = jSONObject2.getString("label");
                String string2 = jSONObject2.getString("url");
                this.addLink((String)object, string2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((object = jSONObject.optJSONObject("tracking_protection")) != null) {
            this.mTitle.setVisibility(0);
            this.mTitle.setText(R.string.doorhanger_tracking_title);
            try {
                boolean bl = object.getBoolean("enabled");
                if (bl) {
                    this.mMessage.setText(R.string.doorhanger_tracking_message_enabled);
                    this.mSecurityState.setText(R.string.doorhanger_tracking_state_enabled);
                    this.mSecurityState.setTextColor(this.getResources().getColor(R.color.affirmative_green));
                } else {
                    this.mMessage.setText(R.string.doorhanger_tracking_message_disabled);
                    this.mSecurityState.setText(R.string.doorhanger_tracking_state_disabled);
                    this.mSecurityState.setTextColor(this.getResources().getColor(R.color.rejection_red));
                }
                this.mMessage.setVisibility(0);
                this.mSecurityState.setVisibility(0);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    protected View.OnClickListener makeOnButtonClickListener(final int n) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                JSONObject jSONObject = new JSONObject();
                try {
                    switch (ContentSecurityDoorHanger.this.mType) {
                        case MIXED_CONTENT: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"mixed");
                            break;
                        }
                        case TRACKING: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"tracking");
                            break;
                        }
                        default: {
                            Log.w((String)ContentSecurityDoorHanger.LOGTAG, (String)("Unknown doorhanger type " + ContentSecurityDoorHanger.this.mType.toString()));
                            break;
                        }
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)ContentSecurityDoorHanger.LOGTAG, (String)"Error creating onClick response", (Throwable)jSONException);
                }
                ContentSecurityDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, ContentSecurityDoorHanger.this);
            }
        };
    }
}

