/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.entity.DeflateDecompressingEntity;
import ch.boye.httpclientandroidlib.client.entity.GzipDecompressingEntity;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Header header;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null && httpEntity.getContentLength() != 0L && (header = httpEntity.getContentEncoding()) != null) {
            HeaderElement[] headerElementArray = header.getElements();
            boolean bl = false;
            int n = 0;
            HeaderElement[] headerElementArray2 = headerElementArray;
            int n2 = headerElementArray2.length;
            if (n < n2) {
                HeaderElement headerElement = headerElementArray2[n];
                String string = headerElement.getName().toLowerCase(Locale.ENGLISH);
                if ("gzip".equals(string) || "x-gzip".equals(string)) {
                    httpResponse.setEntity(new GzipDecompressingEntity(httpResponse.getEntity()));
                    bl = true;
                } else if ("deflate".equals(string)) {
                    httpResponse.setEntity(new DeflateDecompressingEntity(httpResponse.getEntity()));
                    bl = true;
                } else {
                    if ("identity".equals(string)) {
                        return;
                    }
                    throw new HttpException("Unsupported Content-Coding: " + headerElement.getName());
                }
            }
            if (bl) {
                httpResponse.removeHeaders("Content-Length");
                httpResponse.removeHeaders("Content-Encoding");
                httpResponse.removeHeaders("Content-MD5");
            }
        }
    }
}

