/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.HttpClientConnection;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.ManagedHttpClientConnection;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.pool.PoolEntry;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedHttpClientConnection> {
    public HttpClientAndroidLog log;
    private volatile boolean routeComplete;

    public CPoolEntry(HttpClientAndroidLog httpClientAndroidLog, String string, HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection, long l, TimeUnit timeUnit) {
        super(string, httpRoute, managedHttpClientConnection, l, timeUnit);
        this.log = httpClientAndroidLog;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void closeConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.close();
    }

    public void shutdownConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.shutdown();
    }

    @Override
    public boolean isExpired(long l) {
        boolean bl = super.isExpired(l);
        if (bl && this.log.isDebugEnabled()) {
            this.log.debug("Connection " + this + " expired @ " + new Date(this.getExpiry()));
        }
        return bl;
    }

    @Override
    public boolean isClosed() {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        return !httpClientConnection.isOpen();
    }

    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            this.log.debug("I/O error closing connection", iOException);
        }
    }
}

