/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.apache.commons.codec.binary.StringUtils;
import org.mozilla.gecko.browserid.SigningPrivateKey;
import org.mozilla.gecko.browserid.VerifyingPublicKey;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

public class JSONWebTokenUtils {
    public static final long DEFAULT_CERTIFICATE_DURATION_IN_MILLISECONDS = 3600000L;
    public static final long DEFAULT_ASSERTION_DURATION_IN_MILLISECONDS = 3600000L;
    public static final long DEFAULT_FUTURE_EXPIRES_AT_IN_MILLISECONDS = 9999999999999L;
    public static final String DEFAULT_CERTIFICATE_ISSUER = "127.0.0.1";
    public static final String DEFAULT_ASSERTION_ISSUER = "127.0.0.1";

    public static String encode(String string, SigningPrivateKey signingPrivateKey) throws UnsupportedEncodingException, GeneralSecurityException {
        return JSONWebTokenUtils.encode(string, signingPrivateKey, null);
    }

    protected static String encode(String string, SigningPrivateKey signingPrivateKey, Map<String, Object> map) throws UnsupportedEncodingException, GeneralSecurityException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        if (map != null) {
            extendedJSONObject.putAll(map);
        }
        extendedJSONObject.put("alg", signingPrivateKey.getAlgorithm());
        String string2 = Base64.encodeBase64URLSafeString((byte[])extendedJSONObject.toJSONString().getBytes("UTF-8"));
        String string3 = Base64.encodeBase64URLSafeString((byte[])string.getBytes("UTF-8"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add(string3);
        byte[] byArray = Utils.toDelimitedString(".", arrayList).getBytes("UTF-8");
        byte[] byArray2 = signingPrivateKey.signMessage(byArray);
        arrayList.add(Base64.encodeBase64URLSafeString((byte[])byArray2));
        return Utils.toDelimitedString(".", arrayList);
    }

    public static String decode(String string, VerifyingPublicKey verifyingPublicKey) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] byArray;
        if (string == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        String[] stringArray = string.split("\\.");
        if (stringArray == null || stringArray.length != 3) {
            throw new GeneralSecurityException("malformed token");
        }
        byte[] byArray2 = (stringArray[0] + "." + stringArray[1]).getBytes("UTF-8");
        boolean bl = verifyingPublicKey.verifyMessage(byArray2, byArray = Base64.decodeBase64((String)stringArray[2]));
        if (!bl) {
            throw new GeneralSecurityException("bad signature");
        }
        String string2 = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)stringArray[1]));
        return string2;
    }

    public static String getPayloadString(String string, String string2, String string3, Long l, long l2) throws NonObjectJSONException, IOException, ParseException {
        ExtendedJSONObject extendedJSONObject = string != null ? new ExtendedJSONObject(string) : new ExtendedJSONObject();
        if (string2 != null) {
            extendedJSONObject.put("aud", string2);
        }
        extendedJSONObject.put("iss", string3);
        if (l != null) {
            extendedJSONObject.put("iat", l);
        }
        extendedJSONObject.put("exp", l2);
        return JSONObject.toJSONString(new TreeMap(extendedJSONObject.object));
    }

    protected static String getCertificatePayloadString(VerifyingPublicKey verifyingPublicKey, String string) throws NonObjectJSONException, IOException, ParseException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        extendedJSONObject2.put("email", string);
        extendedJSONObject.put("principal", extendedJSONObject2);
        extendedJSONObject.put("public-key", verifyingPublicKey.toJSONObject());
        return extendedJSONObject.toJSONString();
    }

    public static String createCertificate(VerifyingPublicKey verifyingPublicKey, String string, String string2, long l, long l2, SigningPrivateKey signingPrivateKey) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string3 = JSONWebTokenUtils.getCertificatePayloadString(verifyingPublicKey, string);
        String string4 = JSONWebTokenUtils.getPayloadString(string3, null, string2, l, l2);
        return JSONWebTokenUtils.encode(string4, signingPrivateKey);
    }

    public static String createAssertion(SigningPrivateKey signingPrivateKey, String string, String string2, String string3, Long l, long l2) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string4 = "{}";
        String string5 = JSONWebTokenUtils.getPayloadString(string4, string2, string3, l, l2);
        String string6 = JSONWebTokenUtils.encode(string5, signingPrivateKey);
        return string + "~" + string6;
    }

    public static ExtendedJSONObject parseCertificate(String string) {
        try {
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 3) {
                return null;
            }
            String string2 = new String(Base64.decodeBase64((String)stringArray[0]));
            String string3 = new String(Base64.decodeBase64((String)stringArray[1]));
            String string4 = Utils.byte2Hex(Base64.decodeBase64((String)stringArray[2]));
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("header", new ExtendedJSONObject(string2));
            extendedJSONObject.put("payload", new ExtendedJSONObject(string3));
            extendedJSONObject.put("signature", string4);
            return extendedJSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean dumpCertificate(String string) {
        ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseCertificate(string);
        try {
            if (extendedJSONObject == null) {
                System.out.println("Malformed certificate -- got exception trying to dump contents.");
                return false;
            }
            System.out.println("certificate header:    " + extendedJSONObject.getObject("header").toJSONString());
            System.out.println("certificate payload:   " + extendedJSONObject.getObject("payload").toJSONString());
            System.out.println("certificate signature: " + extendedJSONObject.getString("signature"));
            return true;
        }
        catch (Exception exception) {
            System.out.println("Malformed certificate -- got exception trying to dump contents.");
            return false;
        }
    }

    public static ExtendedJSONObject parseAssertion(String string) {
        try {
            String[] stringArray = string.split("~");
            if (stringArray.length != 2) {
                return null;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if ((stringArray = string3.split("\\.")).length != 3) {
                return null;
            }
            String string4 = new String(Base64.decodeBase64((String)stringArray[0]));
            String string5 = new String(Base64.decodeBase64((String)stringArray[1]));
            String string6 = Utils.byte2Hex(Base64.decodeBase64((String)stringArray[2]));
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("header", new ExtendedJSONObject(string4));
            extendedJSONObject.put("payload", new ExtendedJSONObject(string5));
            extendedJSONObject.put("signature", string6);
            extendedJSONObject.put("certificate", string2);
            return extendedJSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean dumpAssertion(String string) {
        ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseAssertion(string);
        try {
            if (extendedJSONObject == null) {
                System.out.println("Malformed assertion -- got exception trying to dump contents.");
                return false;
            }
            JSONWebTokenUtils.dumpCertificate(extendedJSONObject.getString("certificate"));
            System.out.println("assertion   header:    " + extendedJSONObject.getObject("header").toJSONString());
            System.out.println("assertion   payload:   " + extendedJSONObject.getObject("payload").toJSONString());
            System.out.println("assertion   signature: " + extendedJSONObject.getString("signature"));
            return true;
        }
        catch (Exception exception) {
            System.out.println("Malformed assertion -- got exception trying to dump contents.");
            return false;
        }
    }
}

