/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.content.Context;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

public class AccountPickler {
    public static final String LOG_TAG = AccountPickler.class.getSimpleName();
    public static final long PICKLE_VERSION = 3L;
    public static final String KEY_PICKLE_VERSION = "pickle_version";
    public static final String KEY_PICKLE_TIMESTAMP = "pickle_timestamp";
    public static final String KEY_ACCOUNT_VERSION = "account_version";
    public static final String KEY_ACCOUNT_TYPE = "account_type";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_PROFILE = "profile";
    public static final String KEY_IDP_SERVER_URI = "idpServerURI";
    public static final String KEY_TOKEN_SERVER_URI = "tokenServerURI";
    public static final String KEY_PROFILE_SERVER_URI = "profileServerURI";
    public static final String KEY_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP = "authoritiesToSyncAutomaticallyMap";
    public static final String KEY_IS_SYNCING_ENABLED = "isSyncingEnabled";
    public static final String KEY_BUNDLE = "bundle";

    public static synchronized boolean deletePickle(Context context, String string2) {
        return context.deleteFile(string2);
    }

    public static ExtendedJSONObject toJSON(AndroidFxAccount androidFxAccount, long l) {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(KEY_PICKLE_VERSION, 3L);
        extendedJSONObject.put(KEY_PICKLE_TIMESTAMP, l);
        extendedJSONObject.put(KEY_ACCOUNT_VERSION, 3);
        extendedJSONObject.put(KEY_ACCOUNT_TYPE, "org.mozilla.fennec_fxaccount");
        extendedJSONObject.put(KEY_EMAIL, androidFxAccount.getEmail());
        extendedJSONObject.put(KEY_PROFILE, androidFxAccount.getProfile());
        extendedJSONObject.put(KEY_IDP_SERVER_URI, androidFxAccount.getAccountServerURI());
        extendedJSONObject.put(KEY_TOKEN_SERVER_URI, androidFxAccount.getTokenServerURI());
        extendedJSONObject.put(KEY_PROFILE_SERVER_URI, androidFxAccount.getProfileServerURI());
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        for (Map.Entry<String, Boolean> entry : androidFxAccount.getAuthoritiesToSyncAutomaticallyMap().entrySet()) {
            extendedJSONObject2.put(entry.getKey(), entry.getValue());
        }
        extendedJSONObject.put(KEY_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP, extendedJSONObject2);
        ExtendedJSONObject extendedJSONObject3 = androidFxAccount.unbundle();
        if (extendedJSONObject3 == null) {
            Logger.warn(LOG_TAG, "Unable to obtain account bundle; aborting.");
            return null;
        }
        extendedJSONObject.put(KEY_BUNDLE, extendedJSONObject3);
        return extendedJSONObject;
    }

    public static synchronized void pickle(AndroidFxAccount androidFxAccount, String string2) {
        ExtendedJSONObject extendedJSONObject = AccountPickler.toJSON(androidFxAccount, System.currentTimeMillis());
        AccountPickler.writeToDisk(androidFxAccount.context, string2, extendedJSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToDisk(Context context, String string2, ExtendedJSONObject extendedJSONObject) {
        try (FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
             PrintStream printStream = new PrintStream(fileOutputStream);){
            printStream.print(extendedJSONObject.toJSONString());
            Logger.debug(LOG_TAG, "Persisted " + extendedJSONObject.keySet().size() + " account settings to " + string2 + ".");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception persisting account settings to " + string2 + "; ignoring.", exception);
        }
    }

    public static synchronized AndroidFxAccount unpickle(Context context, String string2) {
        AndroidFxAccount androidFxAccount;
        UnpickleParams unpickleParams;
        String string3 = Utils.readFile(context, string2);
        if (string3 == null) {
            Logger.info(LOG_TAG, "Pickle file '" + string2 + "' not found; aborting.");
            return null;
        }
        ExtendedJSONObject extendedJSONObject = null;
        try {
            extendedJSONObject = ExtendedJSONObject.parseJSONObject(string3);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception reading pickle file '" + string2 + "'; aborting.", exception);
            return null;
        }
        try {
            unpickleParams = UnpickleParams.fromJSON(extendedJSONObject);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception extracting unpickle json; aborting.", exception);
            return null;
        }
        try {
            androidFxAccount = AndroidFxAccount.addAndroidAccount(context, unpickleParams.email, unpickleParams.profile, unpickleParams.authServerURI, unpickleParams.tokenServerURI, unpickleParams.profileServerURI, unpickleParams.state, unpickleParams.authoritiesToSyncAutomaticallyMap, unpickleParams.accountVersion, true, unpickleParams.bundle);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Exception when adding Android Account; aborting.", exception);
            return null;
        }
        if (androidFxAccount == null) {
            Logger.warn(LOG_TAG, "Failed to add Android Account; aborting.");
            return null;
        }
        Long l = extendedJSONObject.getLong(KEY_PICKLE_TIMESTAMP);
        if (l == null) {
            Logger.warn(LOG_TAG, "Did not find timestamp in pickle file; ignoring.");
            l = -1L;
        }
        Logger.info(LOG_TAG, "Un-pickled Android account named " + unpickleParams.email + " (version " + unpickleParams.pickleVersion + ", pickled at " + l + ").");
        return androidFxAccount;
    }

    private static class UnpickleParams {
        private Long pickleVersion;
        private int accountVersion;
        private String email;
        private String profile;
        private String authServerURI;
        private String tokenServerURI;
        private String profileServerURI;
        private final Map<String, Boolean> authoritiesToSyncAutomaticallyMap = new HashMap<String, Boolean>();
        private ExtendedJSONObject bundle;
        private State state;

        private UnpickleParams() {
        }

        private static UnpickleParams fromJSON(ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
            UnpickleParams unpickleParams = new UnpickleParams();
            unpickleParams.pickleVersion = extendedJSONObject.getLong(AccountPickler.KEY_PICKLE_VERSION);
            if (unpickleParams.pickleVersion == null) {
                throw new IllegalStateException("Pickle version not found.");
            }
            switch (unpickleParams.pickleVersion.intValue()) {
                case 3: {
                    String string2 = extendedJSONObject.getString(AccountPickler.KEY_ACCOUNT_TYPE);
                    if (!"org.mozilla.fennec_fxaccount".equals(string2)) {
                        throw new IllegalStateException("Account type has changed from " + string2 + " to " + "org.mozilla.fennec_fxaccount" + ".");
                    }
                    unpickleParams.unpickleV3(extendedJSONObject);
                    break;
                }
                case 2: {
                    String string3 = extendedJSONObject.getString(AccountPickler.KEY_ACCOUNT_TYPE);
                    if (!"org.mozilla.fennec_fxaccount".equals(string3)) {
                        throw new IllegalStateException("Account type has changed from " + string3 + " to " + "org.mozilla.fennec_fxaccount" + ".");
                    }
                    unpickleParams.unpickleV1(extendedJSONObject);
                    break;
                }
                case 1: {
                    String string4 = extendedJSONObject.getString(AccountPickler.KEY_ACCOUNT_TYPE);
                    if (!"org.mozilla.fennec_fxaccount".equals(string4)) {
                        Logger.warn(LOG_TAG, "Account type has changed from " + string4 + " to " + "org.mozilla.fennec_fxaccount" + "; ignoring.");
                    }
                    unpickleParams.unpickleV1(extendedJSONObject);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown pickle version, " + unpickleParams.pickleVersion + ".");
                }
            }
            return unpickleParams;
        }

        private void unpickleV1(ExtendedJSONObject extendedJSONObject) throws NonObjectJSONException, NoSuchAlgorithmException, InvalidKeySpecException {
            this.accountVersion = extendedJSONObject.getIntegerSafely(AccountPickler.KEY_ACCOUNT_VERSION);
            this.email = extendedJSONObject.getString(AccountPickler.KEY_EMAIL);
            this.profile = extendedJSONObject.getString(AccountPickler.KEY_PROFILE);
            this.authServerURI = extendedJSONObject.getString(AccountPickler.KEY_IDP_SERVER_URI);
            this.tokenServerURI = extendedJSONObject.getString(AccountPickler.KEY_TOKEN_SERVER_URI);
            this.profileServerURI = extendedJSONObject.getString(AccountPickler.KEY_PROFILE_SERVER_URI);
            if (this.profileServerURI == null) {
                this.profileServerURI = "https://api.accounts.firefox.com/v1".equals(this.authServerURI) ? "https://profile.accounts.firefox.com/v1" : "https://latest.dev.lcip.org/profile/v1";
            }
            this.authoritiesToSyncAutomaticallyMap.put("org.mozilla.fennec.db.browser", extendedJSONObject.getBoolean(AccountPickler.KEY_IS_SYNCING_ENABLED));
            this.bundle = extendedJSONObject.getObject(AccountPickler.KEY_BUNDLE);
            if (this.bundle == null) {
                throw new IllegalStateException("Pickle bundle is null.");
            }
            this.state = this.getState(this.bundle);
        }

        private void unpickleV3(ExtendedJSONObject extendedJSONObject) throws NonObjectJSONException, NoSuchAlgorithmException, InvalidKeySpecException {
            this.unpickleV1(extendedJSONObject);
            this.authoritiesToSyncAutomaticallyMap.clear();
            ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject(AccountPickler.KEY_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);
            if (extendedJSONObject2 == null) {
                return;
            }
            for (String string2 : extendedJSONObject2.keySet()) {
                Boolean bl = extendedJSONObject2.getBoolean(string2);
                if (bl == null) continue;
                this.authoritiesToSyncAutomaticallyMap.put(string2, bl);
            }
        }

        private State getState(ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NonObjectJSONException, NoSuchAlgorithmException {
            State.StateLabel stateLabel = State.StateLabel.valueOf(extendedJSONObject.getString("stateLabel"));
            String string2 = extendedJSONObject.getString("state");
            if (stateLabel == null || string2 == null) {
                throw new IllegalStateException("stateLabel and stateString must not be null, but: (stateLabel == null) = " + (stateLabel == null) + " and (stateString == null) = " + (string2 == null));
            }
            try {
                return StateFactory.fromJSONObject(stateLabel, new ExtendedJSONObject(string2));
            }
            catch (Exception exception) {
                throw new IllegalStateException("could not get state", exception);
            }
        }
    }
}

