/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.receivers;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import java.util.concurrent.Executor;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClient;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClientException;
import org.mozilla.gecko.background.fxa.oauth.FxAccountOAuthClient10;
import org.mozilla.gecko.fxa.sync.FxAccountNotificationManager;
import org.mozilla.gecko.fxa.sync.FxAccountSyncAdapter;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserHistoryDataExtender;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabase;
import org.mozilla.gecko.sync.repositories.android.FennecTabsRepository;

public class FxAccountDeletedService
extends IntentService {
    public static final String LOG_TAG = FxAccountDeletedService.class.getSimpleName();

    public FxAccountDeletedService() {
        super(LOG_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        Object object;
        long l;
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        FxAccountDeletedService fxAccountDeletedService = this;
        long l2 = intent.getLongExtra("account_deleted_intent_version", 0L);
        if (l2 != (l = 1L)) {
            Logger.warn(LOG_TAG, "Intent malformed: version " + l2 + " given but " + "version " + l + "expected. Not cleaning up after deleted Account.");
            return;
        }
        String string2 = intent.getStringExtra("account_deleted_intent_account");
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Intent malformed: no account name given. Not cleaning up after deleted Account.");
            return;
        }
        Logger.info(LOG_TAG, "Deleting the entire Fennec clients database and non-local tabs");
        FennecTabsRepository.deleteNonLocalClientsAndTabs((Context)fxAccountDeletedService);
        try {
            Logger.info(LOG_TAG, "Deleting the Firefox Sync clients database.");
            object = null;
            try {
                object = new ClientsDatabase((Context)fxAccountDeletedService);
                object.wipeClientsTable();
                object.wipeCommandsTable();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting the Firefox Sync clients database; ignoring.", exception);
        }
        try {
            Logger.info(LOG_TAG, "Deleting the Firefox Sync extended history database.");
            object = null;
            try {
                object = new AndroidBrowserHistoryDataExtender((Context)fxAccountDeletedService);
                ((AndroidBrowserHistoryDataExtender)((Object)object)).wipe();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting the Firefox Sync extended history database; ignoring.", exception);
        }
        new FxAccountNotificationManager(FxAccountSyncAdapter.NOTIFICATION_ID).clear((Context)fxAccountDeletedService);
        object = intent.getStringExtra("account_oauth_service_endpoint");
        String[] stringArray = intent.getStringArrayExtra("account_deleted_intent_auth_tokens");
        if (object != null && stringArray != null) {
            Executor executor = new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    runnable.run();
                }
            };
            FxAccountOAuthClient10 fxAccountOAuthClient10 = new FxAccountOAuthClient10((String)object, executor);
            for (String string3 : stringArray) {
                if (string3 == null) {
                    Logger.error(LOG_TAG, "Cached OAuth token is null; should never happen.  Ignoring.");
                    continue;
                }
                try {
                    fxAccountOAuthClient10.deleteToken(string3, new FxAccountAbstractClient.RequestDelegate<Void>(){

                        @Override
                        public void handleSuccess(Void void_) {
                            Logger.info(LOG_TAG, "Successfully deleted cached OAuth token.");
                        }

                        @Override
                        public void handleError(Exception exception) {
                            Logger.error(LOG_TAG, "Failed to delete cached OAuth token; ignoring.", exception);
                        }

                        @Override
                        public void handleFailure(FxAccountAbstractClientException.FxAccountAbstractClientRemoteException fxAccountAbstractClientRemoteException) {
                            Logger.error(LOG_TAG, "Exception during cached OAuth token deletion; ignoring.", fxAccountAbstractClientRemoteException);
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.error(LOG_TAG, "Exception during cached OAuth token deletion; ignoring.", exception);
                }
            }
        } else {
            Logger.error(LOG_TAG, "Cached OAuth server URI is null or cached OAuth tokens are null; ignoring.");
        }
    }
}

