/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class InfoCounts {
    static final String LOG_TAG = "InfoCounts";
    private Map<String, Integer> counts = null;

    public InfoCounts(ExtendedJSONObject extendedJSONObject) {
        Logger.debug(LOG_TAG, "info/collection_counts is " + extendedJSONObject.toJSONString());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Set set = extendedJSONObject.object.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Integer) {
                hashMap.put(string, (Integer)v);
                continue;
            }
            if (v instanceof Long) {
                hashMap.put(string, ((Long)v).intValue());
                continue;
            }
            Logger.warn(LOG_TAG, "Skipping info/collection_counts entry for " + string);
        }
        this.counts = Collections.unmodifiableMap(hashMap);
    }

    public Integer getCount(String string) {
        if (this.counts == null) {
            return null;
        }
        return this.counts.get(string);
    }
}

