/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.annotation.ReflectionTarget;
import org.mozilla.gecko.util.GeckoJarReader;

public class BrowserLocaleManager
implements LocaleManager {
    private static final String LOG_TAG = "GeckoLocales";
    private static final String EVENT_LOCALE_CHANGED = "Locale:Changed";
    private static final String PREF_LOCALE = "locale";
    private static final String FALLBACK_LOCALE_TAG = "en-US";
    private volatile Locale currentLocale;
    private volatile Locale systemLocale = Locale.getDefault();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private boolean systemLocaleDidChange;
    private BroadcastReceiver receiver;
    private static final AtomicReference<LocaleManager> instance = new AtomicReference();

    @ReflectionTarget
    public static LocaleManager getInstance() {
        LocaleManager localeManager = instance.get();
        if (localeManager != null) {
            return localeManager;
        }
        localeManager = new BrowserLocaleManager();
        if (instance.compareAndSet(null, localeManager)) {
            return localeManager;
        }
        return instance.get();
    }

    public boolean isEnabled() {
        return true;
    }

    public void initialize(Context context) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Locale locale = BrowserLocaleManager.this.systemLocale;
                BrowserLocaleManager.this.systemLocale = context.getResources().getConfiguration().locale;
                BrowserLocaleManager.this.systemLocaleDidChange = true;
                Log.d((String)BrowserLocaleManager.LOG_TAG, (String)("System locale changed from " + locale + " to " + BrowserLocaleManager.this.systemLocale));
            }
        };
        context.registerReceiver(this.receiver, new IntentFilter("android.intent.action.LOCALE_CHANGED"));
    }

    public boolean systemLocaleDidChange() {
        return this.systemLocaleDidChange;
    }

    public void correctLocale(Context context, Resources resources, Configuration configuration) {
        Locale locale = this.getCurrentLocale(context);
        if (locale == null) {
            Log.d((String)LOG_TAG, (String)"No selected locale. No correction needed.");
            return;
        }
        configuration.locale = locale;
        Locale.setDefault(locale);
        resources.updateConfiguration(configuration, null);
    }

    public Locale onSystemConfigurationChanged(Context context, Resources resources, Configuration configuration, Locale locale) {
        Locale locale2;
        if (!this.isMirroringSystemLocale(context)) {
            this.correctLocale(context, resources, configuration);
        }
        if ((locale2 = configuration.locale).equals(locale)) {
            return null;
        }
        return locale2;
    }

    public static void storeAndNotifyOSLocale(SharedPreferences sharedPreferences, Locale locale) {
        if (locale == null) {
            return;
        }
        String string2 = sharedPreferences.getString("osLocale", null);
        String string3 = locale.toString();
        if (string3.equals(string2)) {
            return;
        }
        sharedPreferences.edit().putString("osLocale", string3).apply();
        String string4 = Locales.getLanguageTag((Locale)locale);
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Locale:OS", string4);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public String getAndApplyPersistedLocale(Context context) {
        this.initialize(context);
        long l = SystemClock.uptimeMillis();
        String string2 = this.getPersistedLocale(context);
        if (string2 == null) {
            return null;
        }
        String string3 = this.updateLocale(context, string2);
        if (string3 == null) {
            this.updateConfiguration(context, this.currentLocale);
        }
        long l2 = SystemClock.uptimeMillis();
        Log.i((String)LOG_TAG, (String)("Locale read and update took: " + (l2 - l) + "ms."));
        return string3;
    }

    public String setSelectedLocale(Context context, String string2) {
        String string3 = this.updateLocale(context, string2);
        this.persistLocale(context, string2);
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent(EVENT_LOCALE_CHANGED, Locales.getLanguageTag((Locale)this.getCurrentLocale(context)));
        GeckoAppShell.sendEventToGecko(geckoEvent);
        return string3;
    }

    public void resetToSystemLocale(Context context) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        sharedPreferences.edit().remove(PREF_LOCALE).apply();
        this.updateLocale(context, this.systemLocale);
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent(EVENT_LOCALE_CHANGED, "");
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public void updateConfiguration(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, null);
    }

    private SharedPreferences getSharedPreferences(Context context) {
        return GeckoSharedPrefs.forApp(context);
    }

    private String getPersistedLocale(Context context) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        String string2 = sharedPreferences.getString(PREF_LOCALE, "");
        if ("".equals(string2)) {
            return null;
        }
        return string2;
    }

    private void persistLocale(Context context, String string2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        sharedPreferences.edit().putString(PREF_LOCALE, string2).apply();
    }

    public Locale getCurrentLocale(Context context) {
        if (this.currentLocale != null) {
            return this.currentLocale;
        }
        String string2 = this.getPersistedLocale(context);
        if (string2 == null) {
            return null;
        }
        this.currentLocale = Locales.parseLocaleCode((String)string2);
        return this.currentLocale;
    }

    private String updateLocale(Context context, String string2) {
        Locale locale = Locale.getDefault();
        if (locale.toString().equals(string2)) {
            return null;
        }
        Locale locale2 = Locales.parseLocaleCode((String)string2);
        return this.updateLocale(context, locale2);
    }

    private String updateLocale(Context context, Locale locale) {
        if (Locale.getDefault().equals(locale)) {
            return null;
        }
        Locale.setDefault(locale);
        this.currentLocale = locale;
        this.updateConfiguration(context, locale);
        return locale.toString();
    }

    private boolean isMirroringSystemLocale(Context context) {
        return this.getPersistedLocale(context) == null;
    }

    public static Collection<String> getPackagedLocaleTags(Context context) {
        String string2 = GeckoJarReader.getJarURL((Context)context, (String)"res/multilocale.json");
        String string3 = GeckoJarReader.getText((Context)context, (String)string2);
        if (string3 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string3);
            JSONArray jSONArray = jSONObject.getJSONArray("locales");
            if (jSONArray == null) {
                Log.e((String)LOG_TAG, (String)"No 'locales' array in multilocales.json!");
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>(jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                hashSet.add(jSONArray.getString(i));
            }
            return hashSet;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"Unable to parse multilocale.json.", (Throwable)jSONException);
            return null;
        }
    }

    public String getFallbackLocaleTag() {
        return FALLBACK_LOCALE_TAG;
    }
}

