/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.util.GeckoEventListener;

public final class PrefsHelper {
    private static final String LOGTAG = "GeckoPrefsHelper";
    private static boolean sRegistered;
    private static int sUniqueRequestId;
    static final SparseArray<PrefHandler> sCallbacks;

    @WrapForJNI
    @RobocopTarget
    static native void getPrefsById(int var0, String[] var1, boolean var2);

    @WrapForJNI
    @RobocopTarget
    static native void removePrefsObserver(int var0);

    public static int getPref(String string2, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(new String[]{string2}, prefHandler);
    }

    public static int getPrefs(String[] stringArray, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(stringArray, prefHandler);
    }

    public static int getPrefs(ArrayList<String> arrayList, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(arrayList.toArray(new String[arrayList.size()]), prefHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPrefsInternal(String[] stringArray, PrefHandler prefHandler) {
        Class<PrefsHelper> clazz = PrefsHelper.class;
        synchronized (PrefsHelper.class) {
            PrefsHelper.ensureRegistered();
            int n = sUniqueRequestId++;
            sCallbacks.put(n, (Object)prefHandler);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (GeckoThread.isStateAtLeast(GeckoThread.State.RUNNING)) {
                PrefsHelper.getPrefsById(n, stringArray, prefHandler.isObserver());
            } else {
                GeckoThread.queueNativeCallUntil(GeckoThread.State.RUNNING, PrefsHelper.class, "getPrefsById", n, stringArray, prefHandler.isObserver());
            }
            return n;
        }
    }

    private static void ensureRegistered() {
        if (sRegistered) {
            return;
        }
        GeckoEventListener geckoEventListener = new GeckoEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(String string2, JSONObject jSONObject) {
                try {
                    JSONArray jSONArray = PrefsHelper.class;
                    synchronized (PrefsHelper.class) {
                        PrefHandler prefHandler;
                        int n;
                        try {
                            n = jSONObject.getInt("requestId");
                            prefHandler = (PrefHandler)sCallbacks.get(n);
                            if (prefHandler != null && !prefHandler.isObserver()) {
                                sCallbacks.delete(n);
                            }
                        }
                        catch (Exception exception) {
                            prefHandler = null;
                        }
                        if (prefHandler == null) {
                            Log.d((String)PrefsHelper.LOGTAG, (String)"Preferences:Data message had an unknown requestId; ignoring");
                            return;
                        }
                        jSONArray = jSONObject.getJSONArray("preferences");
                        for (n = 0; n < jSONArray.length(); ++n) {
                            JSONObject jSONObject2 = jSONArray.getJSONObject(n);
                            String string3 = jSONObject2.getString("name");
                            String string4 = jSONObject2.getString("type");
                            try {
                                if ("bool".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getBoolean("value"));
                                    continue;
                                }
                                if ("int".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getInt("value"));
                                    continue;
                                }
                                if ("string".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getString("value"));
                                    continue;
                                }
                                Log.e((String)PrefsHelper.LOGTAG, (String)("Unknown pref value type [" + string4 + "] for pref [" + string3 + "]"));
                                continue;
                            }
                            catch (Exception exception) {
                                Log.e((String)PrefsHelper.LOGTAG, (String)("Handler for preference [" + string3 + "] threw exception"), (Throwable)exception);
                            }
                        }
                        prefHandler.finish();
                    }
                }
                catch (Exception exception) {
                    Log.e((String)PrefsHelper.LOGTAG, (String)"Error handling Preferences:Data message", (Throwable)exception);
                }
            }
        };
        EventDispatcher.getInstance().registerGeckoThreadListener(geckoEventListener, "Preferences:Data");
        sRegistered = true;
    }

    public static void setPref(String string2, Object object) {
        PrefsHelper.setPref(string2, object, false);
    }

    public static void setPref(String string2, Object object, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Pref name must be non-empty");
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", (Object)string2);
            jSONObject.put("flush", bl);
            if (object instanceof Boolean) {
                jSONObject.put("type", (Object)"bool");
                jSONObject.put("value", ((Boolean)object).booleanValue());
            } else if (object instanceof Integer) {
                jSONObject.put("type", (Object)"int");
                jSONObject.put("value", ((Integer)object).intValue());
            } else {
                jSONObject.put("type", (Object)"string");
                jSONObject.put("value", (Object)String.valueOf(object));
            }
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Preferences:Set", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Error setting pref [" + string2 + "]"), (Throwable)jSONException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObserver(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid request ID");
        }
        Object object = PrefsHelper.class;
        synchronized (PrefsHelper.class) {
            PrefHandler prefHandler = (PrefHandler)sCallbacks.get(n);
            sCallbacks.delete(n);
            if (prefHandler == null) {
                Log.e((String)LOGTAG, (String)("Unknown request ID " + n));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = GeckoEvent.createBroadcastEvent("Preferences:RemoveObserver", Integer.toString(n));
            GeckoAppShell.sendEventToGecko((GeckoEvent)object);
            return;
        }
    }

    static {
        sUniqueRequestId = 1;
        sCallbacks = new SparseArray();
    }

    public static abstract class PrefHandlerBase
    implements PrefHandler {
        @Override
        public void prefValue(String string2, boolean bl) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled boolean value for pref [" + string2 + "]"));
        }

        @Override
        public void prefValue(String string2, int n) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled int value for pref [" + string2 + "]"));
        }

        @Override
        public void prefValue(String string2, String string3) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled String value for pref [" + string2 + "]"));
        }

        @Override
        public void finish() {
        }

        @Override
        public boolean isObserver() {
            return false;
        }
    }

    public static interface PrefHandler {
        public void prefValue(String var1, boolean var2);

        public void prefValue(String var1, int var2);

        public void prefValue(String var1, String var2);

        public boolean isObserver();

        public void finish();
    }
}

