/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.UserManager;
import android.util.Log;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.restrictions.DefaultConfiguration;
import org.mozilla.gecko.restrictions.GuestProfileConfiguration;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictedProfileConfiguration;
import org.mozilla.gecko.restrictions.RestrictionConfiguration;

@RobocopTarget
public class Restrictions {
    private static final String LOGTAG = "GeckoRestrictedProfiles";
    private static RestrictionConfiguration configuration;

    private static RestrictionConfiguration getConfiguration(Context context) {
        if (configuration == null) {
            configuration = Restrictions.createConfiguration(context);
        }
        return configuration;
    }

    public static synchronized RestrictionConfiguration createConfiguration(Context context) {
        if (configuration != null) {
            return configuration;
        }
        if (Restrictions.isGuestProfile(context)) {
            return new GuestProfileConfiguration();
        }
        if (Restrictions.isRestrictedProfile(context)) {
            return new RestrictedProfileConfiguration(context);
        }
        return new DefaultConfiguration();
    }

    private static boolean isGuestProfile(Context context) {
        if (configuration != null) {
            return configuration instanceof GuestProfileConfiguration;
        }
        GeckoAppShell.GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface != null) {
            return geckoInterface.getProfile().inGuestMode();
        }
        return GeckoProfile.get(context).inGuestMode();
    }

    @TargetApi(value=18)
    public static boolean isRestrictedProfile(Context context) {
        if (configuration != null) {
            return configuration instanceof RestrictedProfileConfiguration;
        }
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        UserManager userManager = (UserManager)context.getSystemService("user");
        return !userManager.getApplicationRestrictions(context.getPackageName()).isEmpty();
    }

    public static void update(Context context) {
        Restrictions.getConfiguration(context).update();
    }

    private static Restrictable geckoActionToRestriction(int n) {
        for (Restrictable restrictable : Restrictable.values()) {
            if (restrictable.id != n) continue;
            return restrictable;
        }
        throw new IllegalArgumentException("Unknown action " + n);
    }

    private static boolean canLoadUrl(Context context, String string2) {
        return Restrictions.getConfiguration(context).canLoadUrl(string2);
    }

    @WrapForJNI
    public static boolean isUserRestricted() {
        return Restrictions.isUserRestricted(GeckoAppShell.getApplicationContext());
    }

    public static boolean isUserRestricted(Context context) {
        return Restrictions.getConfiguration(context).isRestricted();
    }

    public static boolean isAllowed(Context context, Restrictable restrictable) {
        return Restrictions.getConfiguration(context).isAllowed(restrictable);
    }

    @WrapForJNI
    public static boolean isAllowed(int n, String string2) {
        Restrictable restrictable;
        try {
            restrictable = Restrictions.geckoActionToRestriction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)LOGTAG, (String)("Unknown action " + n + "; check calling code."));
            return false;
        }
        Context context = GeckoAppShell.getApplicationContext();
        if (Restrictable.BROWSE == restrictable) {
            return Restrictions.canLoadUrl(context, string2);
        }
        return Restrictions.isAllowed(context, restrictable);
    }
}

