/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SQLiteBridgeContentProvider;
import org.mozilla.gecko.sqlite.SQLiteBridge;
import org.mozilla.gecko.util.RawResource;

public class HomeProvider
extends SQLiteBridgeContentProvider {
    private static final String LOGTAG = "GeckoHomeProvider";
    private static final int DB_VERSION = 3;
    private static final String DB_FILENAME = "home.sqlite";
    private static final String TELEMETRY_TAG = "SQLITEBRIDGE_PROVIDER_HOME";
    private static final String TABLE_ITEMS = "items";
    static final int ITEMS_FAKE = 100;
    static final int ITEMS = 101;
    static final int ITEMS_ID = 102;
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public HomeProvider() {
        super(LOGTAG);
    }

    @Override
    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                return "vnd.android.cursor.dir/homeitem";
            }
            case 101: {
                return "vnd.android.cursor.dir/homeitem";
            }
        }
        throw new UnsupportedOperationException("Unknown type " + uri);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        int n = URI_MATCHER.match(uri);
        if (n == 100) {
            return this.queryFakeItems(uri, stringArray, string2, stringArray2, string3);
        }
        String string4 = uri.getQueryParameter("dataset_id");
        if (string4 == null) {
            throw new IllegalArgumentException("All queries should contain a dataset ID parameter");
        }
        Cursor cursor = super.query(uri, stringArray, string2 = DBUtils.concatenateWhere(string2, "dataset_id = ?"), stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{string4}), string3);
        if (cursor == null) {
            cursor = new MatrixCursor(stringArray != null ? stringArray : BrowserContract.HomeItems.DEFAULT_PROJECTION);
        }
        ContentResolver contentResolver = this.getContext().getContentResolver();
        cursor.setNotificationUri(contentResolver, HomeProvider.getDatasetNotificationUri(string4));
        return cursor;
    }

    private Cursor queryFakeItems(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String string4;
        JSONArray jSONArray = null;
        try {
            string4 = RawResource.getAsString((Context)this.getContext(), (int)R.raw.fake_home_items);
            jSONArray = new JSONArray(string4);
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting fake home items", (Throwable)iOException);
            return null;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing fake_home_items.json", (Throwable)jSONException);
            return null;
        }
        string4 = new MatrixCursor(BrowserContract.HomeItems.DEFAULT_PROJECTION);
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                string4.addRow(new Object[]{jSONObject.getInt("id"), jSONObject.getString("dataset_id"), jSONObject.getString("url"), jSONObject.getString("title"), jSONObject.getString("description"), jSONObject.getString("image_url"), jSONObject.getString("filter")});
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error creating cursor row for fake home item", (Throwable)jSONException);
            }
        }
        return string4;
    }

    @Override
    protected String getDBName() {
        return DB_FILENAME;
    }

    @Override
    protected String getTelemetryPrefix() {
        return TELEMETRY_TAG;
    }

    @Override
    protected int getDBVersion() {
        return 3;
    }

    @Override
    public String getTable(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                return TABLE_ITEMS;
            }
        }
        throw new UnsupportedOperationException("Unknown table " + uri);
    }

    @Override
    public String getSortOrder(Uri uri, String string2) {
        return null;
    }

    @Override
    public void setupDefaults(Uri uri, ContentValues contentValues) {
    }

    @Override
    public void initGecko() {
    }

    @Override
    public void onPreInsert(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    @Override
    public void onPreUpdate(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    @Override
    public void onPostQuery(Cursor cursor, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    public static Uri getDatasetNotificationUri(String string2) {
        return Uri.withAppendedPath((Uri)BrowserContract.HomeItems.CONTENT_URI, (String)string2);
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", "items/fake", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", TABLE_ITEMS, 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", "items/#", 102);
    }
}

