/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import org.mozilla.gecko.db.BaseTable;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.Table;

public class URLMetadataTable
extends BaseTable {
    private static final String LOGTAG = "GeckoURLMetadataTable";
    private static final String TABLE = "metadata";
    private static final int TABLE_ID_NUMBER = 1200;
    static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)BrowserContract.AUTHORITY_URI, (String)"metadata");
    public static final String ID_COLUMN = "id";
    public static final String URL_COLUMN = "url";
    public static final String TILE_IMAGE_URL_COLUMN = "tileImage";
    public static final String TILE_COLOR_COLUMN = "tileColor";
    public static final String TOUCH_ICON_COLUMN = "touchIcon";

    URLMetadataTable() {
    }

    @Override
    protected String getTable() {
        return TABLE;
    }

    @Override
    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        String string2 = "CREATE TABLE metadata (id INTEGER PRIMARY KEY, url TEXT NON NULL UNIQUE, tileImage STRING, tileColor STRING, touchIcon STRING);";
        sQLiteDatabase.execSQL(string2);
    }

    private void upgradeDatabaseFrom26To27(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("ALTER TABLE metadata ADD COLUMN touchIcon STRING");
    }

    @Override
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        if (n2 >= 21 && n < 21) {
            this.onCreate(sQLiteDatabase);
        }
        if (n2 >= 26 && n < 26) {
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS metadata_url_idx");
        }
        if (n2 >= 27 && n < 27) {
            this.upgradeDatabaseFrom26To27(sQLiteDatabase);
        }
    }

    @Override
    public Table.ContentProviderInfo[] getContentProviderInfo() {
        return new Table.ContentProviderInfo[]{new Table.ContentProviderInfo(1200, TABLE)};
    }

    public int deleteUnused(SQLiteDatabase sQLiteDatabase) {
        return sQLiteDatabase.delete(this.getTable(), "url NOT IN (SELECT url FROM history WHERE deleted = 0 UNION  SELECT url FROM bookmarks WHERE deleted = 0  AND url IS NOT NULL)", null);
    }
}

