/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpGet;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.IOUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class LoadFaviconTask {
    private static final String LOGTAG = "LoadFaviconTask";
    private static final HashMap<String, LoadFaviconTask> loadsInFlight = new HashMap();
    public static final int FLAG_PERSIST = 1;
    private static final int MAX_REDIRECTS_TO_FOLLOW = 5;
    public static final int DEFAULT_FAVICON_BUFFER_SIZE = 25000;
    private static final AtomicInteger nextFaviconLoadId = new AtomicInteger(0);
    private final Context context;
    private final int id = nextFaviconLoadId.incrementAndGet();
    private final String pageUrl;
    private String faviconURL;
    private final OnFaviconLoadedListener listener;
    private final int flags;
    private final BrowserDB db;
    private final boolean onlyFromLocal;
    volatile boolean mCancelled;
    protected int targetWidth;
    private LinkedList<LoadFaviconTask> chainees;
    private boolean isChaining;
    static DefaultHttpClient httpClient = new DefaultHttpClient();

    public LoadFaviconTask(Context context, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        this(context, string2, string3, n, onFaviconLoadedListener, -1, false);
    }

    public LoadFaviconTask(Context context, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener, int n2, boolean bl) {
        this.context = context;
        this.db = GeckoProfile.get(context).getDB();
        this.pageUrl = string2;
        this.faviconURL = string3;
        this.listener = onFaviconLoadedListener;
        this.flags = n;
        this.targetWidth = n2;
        this.onlyFromLocal = bl;
    }

    private LoadFaviconResult loadFaviconFromDb(BrowserDB browserDB) {
        ContentResolver contentResolver = this.context.getContentResolver();
        return browserDB.getFaviconForUrl(contentResolver, this.faviconURL);
    }

    private void saveFaviconToDb(BrowserDB browserDB, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        ContentResolver contentResolver = this.context.getContentResolver();
        browserDB.updateFaviconForUrl(contentResolver, this.pageUrl, byArray, this.faviconURL);
    }

    private HttpResponse tryDownload(URI uRI) throws URISyntaxException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(uRI.toString());
        return this.tryDownloadRecurse(uRI, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse tryDownloadRecurse(URI uRI, HashSet<String> hashSet) throws URISyntaxException, IOException {
        if (hashSet.size() == 5) {
            return null;
        }
        HttpGet httpGet = new HttpGet(uRI);
        httpGet.setHeader("User-Agent", GeckoAppShell.getGeckoInterface().getDefaultUAString());
        CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpGet);
        if (closeableHttpResponse == null) {
            return null;
        }
        if (closeableHttpResponse.getStatusLine() == null) return closeableHttpResponse;
        int n = closeableHttpResponse.getStatusLine().getStatusCode();
        if (n >= 300 && n < 400) {
            Header header = closeableHttpResponse.getFirstHeader("Location");
            try {
                if (header == null) {
                    HttpResponse httpResponse = null;
                    return httpResponse;
                }
                String string2 = header.getValue();
                if (string2 == null || string2.equals(uRI.toString())) {
                    HttpResponse httpResponse = null;
                    return httpResponse;
                }
                if (hashSet.contains(string2)) {
                    HttpResponse httpResponse = null;
                    return httpResponse;
                }
                hashSet.add(string2);
                return this.tryDownloadRecurse(new URI(string2), hashSet);
            }
            finally {
                try {
                    closeableHttpResponse.getEntity().consumeContent();
                }
                catch (Exception exception) {}
            }
        }
        if (n < 400) return closeableHttpResponse;
        try {
            closeableHttpResponse.getEntity().consumeContent();
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Bitmap fetchJARFavicon(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("jar:jar:")) {
            Log.d((String)LOGTAG, (String)"Fetching favicon from JAR.");
            try {
                return GeckoJarReader.getBitmap((Context)this.context, (Resources)this.context.getResources(), (String)string2);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)"Error fetching favicon from JAR.", (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    private LoadFaviconResult downloadFavicon(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string2 = uRI.getScheme();
        if (!"http".equals(string2) && !"https".equals(string2)) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = null;
        try {
            loadFaviconResult = this.downloadAndDecodeImage(uRI);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error reading favicon", (Throwable)exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)"Insufficient memory to process favicon");
        }
        return loadFaviconResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadFaviconResult downloadAndDecodeImage(URI uRI) throws IOException, URISyntaxException {
        HttpResponse httpResponse = this.tryDownload(uRI);
        if (httpResponse == null) {
            return null;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return null;
        }
        try {
            LoadFaviconResult loadFaviconResult = this.decodeImageFromResponse(httpEntity);
            return loadFaviconResult;
        }
        finally {
            httpEntity.consumeContent();
        }
    }

    private LoadFaviconResult decodeImageFromResponse(HttpEntity httpEntity) throws IOException {
        long l = httpEntity.getContentLength();
        int n = l > 0L ? (int)l + 1 : 25000;
        IOUtils.ConsumedInputStream consumedInputStream = IOUtils.readFully((InputStream)httpEntity.getContent(), (int)n);
        if (consumedInputStream == null) {
            return null;
        }
        return FaviconDecoder.decodeFavicon(consumedInputStream.getData(), 0, consumedInputStream.consumedLength);
    }

    public final void execute() {
        try {
            Favicons.longRunningExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    final Bitmap bitmap = LoadFaviconTask.this.doInBackground(LoadFaviconTask.this.db);
                    ThreadUtils.getUiHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (LoadFaviconTask.this.mCancelled) {
                                LoadFaviconTask.this.onCancelled();
                            } else {
                                LoadFaviconTask.this.onPostExecute(bitmap);
                            }
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.onCancelled();
        }
    }

    public final boolean cancel() {
        this.mCancelled = true;
        return true;
    }

    public final boolean isCancelled() {
        return this.mCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap doInBackground(BrowserDB browserDB) {
        Object object;
        ContentResolver contentResolver;
        Object object2;
        if (this.isCancelled()) {
            return null;
        }
        boolean bl = TextUtils.isEmpty((CharSequence)this.faviconURL);
        if (!bl && (object2 = FaviconDecoder.decodeDataURI(this.faviconURL)) != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        boolean bl2 = false;
        if (bl) {
            contentResolver = this.context.getContentResolver();
            object2 = Favicons.getFaviconURLForPageURLFromCache(this.pageUrl);
            if (object2 == null && (object2 = Favicons.getFaviconURLForPageURL(browserDB, contentResolver, this.pageUrl)) != null) {
                Favicons.putFaviconURLForPageURLInCache(this.pageUrl, (String)object2);
            }
            if (object2 != null) {
                this.faviconURL = object2;
            } else {
                this.faviconURL = Favicons.guessDefaultFaviconURL(this.pageUrl);
                if (TextUtils.isEmpty((CharSequence)this.faviconURL)) {
                    return null;
                }
                bl2 = true;
            }
        }
        if (Favicons.isFailedFavicon(this.faviconURL)) {
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        Object object3 = loadsInFlight;
        synchronized (object3) {
            object = loadsInFlight.get(this.faviconURL);
            if (object != null && !((LoadFaviconTask)object).isCancelled()) {
                ((LoadFaviconTask)object).chainTasks(this);
                this.isChaining = true;
                return null;
            }
            loadsInFlight.put(this.faviconURL, this);
        }
        if (this.isCancelled()) {
            return null;
        }
        object3 = this.loadFaviconFromDb(browserDB);
        if (object3 != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
        }
        if (this.onlyFromLocal || this.isCancelled()) {
            return null;
        }
        contentResolver = this.fetchJARFavicon(this.faviconURL);
        if (LoadFaviconTask.imageIsValid((Bitmap)contentResolver)) {
            Favicons.putFaviconInMemCache(this.faviconURL, (Bitmap)contentResolver);
            return contentResolver;
        }
        try {
            object3 = this.downloadFavicon(new URI(this.faviconURL));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"The provided favicon URL is not valid");
            return null;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Couldn't download favicon.", (Throwable)exception);
        }
        if (object3 != null) {
            this.saveFaviconToDb(browserDB, ((LoadFaviconResult)object3).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
        }
        if (bl2) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        object = Favicons.guessDefaultFaviconURL(this.pageUrl);
        if (object == null) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        contentResolver = this.fetchJARFavicon((String)object);
        if (LoadFaviconTask.imageIsValid((Bitmap)contentResolver)) {
            Favicons.putFaviconInMemCache(this.faviconURL, (Bitmap)contentResolver);
            return contentResolver;
        }
        try {
            object3 = this.downloadFavicon(new URI((String)object));
        }
        catch (Exception exception) {
            return null;
        }
        if (object3 != null) {
            this.saveFaviconToDb(browserDB, ((LoadFaviconResult)object3).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
        }
        return null;
    }

    private Bitmap pushToCacheAndGetResult(LoadFaviconResult loadFaviconResult) {
        Favicons.putFaviconsInMemCache(this.faviconURL, loadFaviconResult.getBitmaps());
        Bitmap bitmap = Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidth);
        return bitmap;
    }

    private static boolean imageIsValid(Bitmap bitmap) {
        return bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPostExecute(Bitmap bitmap) {
        if (this.isChaining) {
            return;
        }
        this.processResult(bitmap);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            loadsInFlight.remove(this.faviconURL);
        }
        if (this.chainees != null) {
            for (LoadFaviconTask loadFaviconTask : this.chainees) {
                loadFaviconTask.processResult(bitmap);
            }
        }
    }

    private void processResult(Bitmap bitmap) {
        Favicons.removeLoadTask(this.id);
        Bitmap bitmap2 = bitmap;
        if (this.targetWidth != -1 && bitmap != null && bitmap.getWidth() != this.targetWidth) {
            bitmap2 = Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidth);
        }
        Favicons.dispatchResult(this.pageUrl, this.faviconURL, bitmap2, this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled() {
        Favicons.removeLoadTask(this.id);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.faviconURL);
            if (loadFaviconTask == this) {
                loadsInFlight.remove(this.faviconURL);
                return;
            }
            if (loadFaviconTask == null) {
                return;
            }
            if (loadFaviconTask.chainees != null) {
                loadFaviconTask.chainees.remove(this);
            }
        }
    }

    private void chainTasks(LoadFaviconTask loadFaviconTask) {
        if (this.chainees == null) {
            this.chainees = new LinkedList();
        }
        this.chainees.add(loadFaviconTask);
    }

    int getId() {
        return this.id;
    }

    static void closeHTTPClient() {
        if (ThreadUtils.isOnBackgroundThread()) {
            if (httpClient != null) {
                httpClient.close();
            }
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LoadFaviconTask.closeHTTPClient();
            }
        });
    }
}

