/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.ViewTransform;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class DynamicToolbarAnimator {
    private static final String LOGTAG = "GeckoDynamicToolbarAnimator";
    private static final String PREF_SCROLL_TOOLBAR_THRESHOLD = "browser.ui.scroll-toolbar-threshold";
    private static final long ANIMATION_DURATION = 250000000L;
    private final GeckoLayerClient mTarget;
    private final List<LayerView.DynamicToolbarListener> mListeners;
    private float mToolbarTranslation;
    private float mLayerViewTranslation;
    private float mMaxTranslation;
    private boolean mPinned;
    private DecelerateInterpolator mInterpolator;
    private float SCROLL_TOOLBAR_THRESHOLD = 0.2f;
    private Integer mPrefObserverId;
    private Integer mHeightDuringResize;
    private boolean mSnapRequired = false;
    private DynamicToolbarAnimationTask mAnimationTask;
    private PointF mTouchStart;
    private float mLastTouch;
    private final Runnable mSnapRunnable = new Runnable(){
        private int mFrame = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            if (this.mFrame == 1) {
                3 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
                this.mFrame = 0;
                return;
            }
            if (this.mFrame == 0) {
                DynamicToolbarAnimator.this.fireListeners();
            }
            ViewCompat.postOnAnimation((View)DynamicToolbarAnimator.this.mTarget.getView(), (Runnable)this);
            ++this.mFrame;
        }
    };

    public DynamicToolbarAnimator(GeckoLayerClient geckoLayerClient) {
        this.mTarget = geckoLayerClient;
        this.mListeners = new ArrayList<LayerView.DynamicToolbarListener>();
        this.mInterpolator = new DecelerateInterpolator();
        this.mPrefObserverId = PrefsHelper.getPref(PREF_SCROLL_TOOLBAR_THRESHOLD, new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, int n) {
                DynamicToolbarAnimator.this.SCROLL_TOOLBAR_THRESHOLD = (float)n / 100.0f;
            }

            @Override
            public boolean isObserver() {
                return true;
            }
        });
    }

    public void destroy() {
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
    }

    public void addTranslationListener(LayerView.DynamicToolbarListener dynamicToolbarListener) {
        this.mListeners.add(dynamicToolbarListener);
    }

    public void removeTranslationListener(LayerView.DynamicToolbarListener dynamicToolbarListener) {
        this.mListeners.remove(dynamicToolbarListener);
    }

    private void fireListeners() {
        for (LayerView.DynamicToolbarListener dynamicToolbarListener : this.mListeners) {
            dynamicToolbarListener.onTranslationChanged(this.mToolbarTranslation, this.mLayerViewTranslation);
        }
    }

    void onPanZoomStopped() {
        for (LayerView.DynamicToolbarListener dynamicToolbarListener : this.mListeners) {
            dynamicToolbarListener.onPanZoomStopped();
        }
    }

    void onMetricsChanged(ImmutableViewportMetrics immutableViewportMetrics) {
        for (LayerView.DynamicToolbarListener dynamicToolbarListener : this.mListeners) {
            dynamicToolbarListener.onMetricsChanged(immutableViewportMetrics);
        }
    }

    public void setMaxTranslation(float f) {
        ThreadUtils.assertOnUiThread();
        if (f < 0.0f) {
            Log.e((String)LOGTAG, (String)("Got a negative max-translation value: " + f + "; clamping to zero"));
            this.mMaxTranslation = 0.0f;
        } else {
            this.mMaxTranslation = f;
        }
    }

    public float getMaxTranslation() {
        return this.mMaxTranslation;
    }

    public float getToolbarTranslation() {
        return this.mToolbarTranslation;
    }

    public void setPinned(boolean bl) {
        this.mPinned = bl;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    public void showToolbar(boolean bl) {
        this.animateToolbar(true, bl);
    }

    public void hideToolbar(boolean bl) {
        this.animateToolbar(false, bl);
    }

    private void animateToolbar(boolean bl, boolean bl2) {
        ThreadUtils.assertOnUiThread();
        if (this.mAnimationTask != null) {
            this.mTarget.getView().removeRenderTask(this.mAnimationTask);
            this.mAnimationTask = null;
        }
        float f = bl ? 0.0f : this.mMaxTranslation;
        Log.v((String)LOGTAG, (String)("Requested " + (bl2 ? "immediate " : "") + "toolbar animation to translation " + f));
        if (FloatUtils.fuzzyEquals((float)this.mToolbarTranslation, (float)f)) {
            bl2 = true;
            Log.v((String)LOGTAG, (String)"Changing animation to immediate jump");
        }
        if (bl && bl2) {
            this.mToolbarTranslation = f;
            this.fireListeners();
        }
        if (!bl) {
            this.shiftLayerView(f);
        }
        this.mAnimationTask = new DynamicToolbarAnimationTask(f, bl2, bl);
        this.mTarget.getView().postRenderTask(this.mAnimationTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shiftLayerView(float f) {
        float f2 = f - this.mLayerViewTranslation;
        this.mLayerViewTranslation = f;
        Object object = this.mTarget.getLock();
        synchronized (object) {
            this.mHeightDuringResize = new Integer(this.mTarget.getViewportMetrics().viewportRectHeight);
            this.mSnapRequired = this.mTarget.setViewportSize(this.mTarget.getView().getWidth(), this.mTarget.getView().getHeight() - Math.round(this.mMaxTranslation - this.mLayerViewTranslation), new PointF(0.0f, -f2));
            if (!this.mSnapRequired) {
                this.mHeightDuringResize = null;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DynamicToolbarAnimator.this.fireListeners();
                    }
                });
            }
            this.mTarget.getView().requestRender();
        }
    }

    IntSize getViewportSize() {
        ThreadUtils.assertOnUiThread();
        int n = this.mTarget.getView().getWidth();
        int n2 = this.mTarget.getView().getHeight();
        float f = this.mToolbarTranslation;
        if (this.mAnimationTask != null) {
            f = this.mAnimationTask.getFinalToolbarTranslation();
        }
        int n3 = n2 - Math.round(this.mMaxTranslation - f);
        return new IntSize(n, n3);
    }

    boolean isResizing() {
        return this.mHeightDuringResize != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scrollChangeResizeCompleted() {
        Object object = this.mTarget.getLock();
        synchronized (object) {
            Log.v((String)LOGTAG, (String)"Scrollchange resize completed");
            this.mHeightDuringResize = null;
        }
    }

    private static float shrinkAbs(float f, float f2) {
        if (f2 <= 0.0f) {
            return f;
        }
        float f3 = Math.min(Math.abs(f), f2);
        return f < 0.0f ? f + f3 : f - f3;
    }

    private float decideTranslation(float f, ImmutableViewportMetrics immutableViewportMetrics, float f2) {
        float f3 = immutableViewportMetrics.getHeight() * this.SCROLL_TOOLBAR_THRESHOLD;
        float f4 = f;
        if (f4 < 0.0f) {
            boolean bl;
            f4 = DynamicToolbarAnimator.shrinkAbs(f4, immutableViewportMetrics.getOverscroll().top);
            boolean bl2 = this.mToolbarTranslation != 0.0f && this.mToolbarTranslation != this.mMaxTranslation;
            boolean bl3 = -f2 >= f3;
            boolean bl4 = bl = immutableViewportMetrics.viewportRectBottom() >= immutableViewportMetrics.pageRectBottom;
            if (bl2 || bl3 && !bl) {
                return f4;
            }
        } else {
            boolean bl;
            f4 = DynamicToolbarAnimator.shrinkAbs(f4, immutableViewportMetrics.getOverscroll().bottom);
            boolean bl5 = this.mToolbarTranslation != 0.0f && this.mToolbarTranslation != this.mMaxTranslation;
            boolean bl6 = f2 >= f3;
            boolean bl7 = immutableViewportMetrics.viewportRectTop <= immutableViewportMetrics.pageRectTop;
            boolean bl8 = bl = this.mToolbarTranslation != 0.0f;
            if (bl5 || bl6 || bl7 && bl) {
                return f4;
            }
        }
        return 0.0f;
    }

    boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        float f;
        float f2;
        if (this.mPinned) {
            return false;
        }
        if (this.mAnimationTask != null) {
            this.mTarget.getView().removeRenderTask(this.mAnimationTask);
            this.mAnimationTask = null;
        }
        if (motionEvent.getActionMasked() != 2 || motionEvent.getPointerCount() != 1) {
            if (this.mTouchStart != null) {
                Log.v((String)LOGTAG, (String)"Resetting touch sequence due to non-move");
                this.mTouchStart = null;
            }
            if (motionEvent.getActionMasked() == 1) {
                boolean bl = this.mToolbarTranslation < this.mMaxTranslation / 2.0f;
                Log.v((String)LOGTAG, (String)("All fingers lifted, completing " + (bl ? "show" : "hide")));
                this.animateToolbar(bl, false);
            }
            return false;
        }
        if (this.mTouchStart != null) {
            f2 = this.mLastTouch - this.mTouchStart.y;
            f = motionEvent.getRawY() - this.mLastTouch;
            if (f2 != 0.0f && f != 0.0f && f2 < 0.0f != f < 0.0f) {
                Log.v((String)LOGTAG, (String)("Direction changed: " + this.mTouchStart.y + " -> " + this.mLastTouch + " -> " + motionEvent.getRawY()));
                this.mTouchStart = null;
            }
        }
        if (this.mTouchStart == null) {
            this.mTouchStart = new PointF(motionEvent.getRawX(), motionEvent.getRawY());
            this.mLastTouch = motionEvent.getRawY();
            return false;
        }
        f2 = motionEvent.getRawY() - this.mLastTouch;
        this.mLastTouch = motionEvent.getRawY();
        f = motionEvent.getRawY() - this.mTouchStart.y;
        ImmutableViewportMetrics immutableViewportMetrics = this.mTarget.getViewportMetrics();
        if (immutableViewportMetrics.getPageHeight() <= (float)this.mTarget.getView().getHeight() && this.mToolbarTranslation == 0.0f) {
            return false;
        }
        float f3 = this.decideTranslation(f2, immutableViewportMetrics, f);
        Log.v((String)LOGTAG, (String)("Got vertical translation " + f3));
        float f4 = this.mToolbarTranslation;
        float f5 = this.mLayerViewTranslation;
        this.mToolbarTranslation = FloatUtils.clamp((float)(this.mToolbarTranslation - f3), (float)0.0f, (float)this.mMaxTranslation);
        this.mLayerViewTranslation = FloatUtils.clamp((float)(this.mLayerViewTranslation - f3), (float)0.0f, (float)this.mMaxTranslation);
        if (f4 == this.mToolbarTranslation && f5 == this.mLayerViewTranslation) {
            return false;
        }
        this.fireListeners();
        this.mTarget.getView().requestRender();
        return true;
    }

    public PointF getVisibleEndOfLayerView() {
        return new PointF((float)this.mTarget.getView().getWidth(), (float)this.mTarget.getView().getHeight() - this.mMaxTranslation + this.mLayerViewTranslation);
    }

    private float bottomOfCssViewport(ImmutableViewportMetrics immutableViewportMetrics) {
        return (this.isResizing() ? (float)this.mHeightDuringResize.intValue() : immutableViewportMetrics.getHeight()) + this.mMaxTranslation - this.mLayerViewTranslation;
    }

    private synchronized boolean getAndClearSnapRequired() {
        boolean bl = this.mSnapRequired;
        this.mSnapRequired = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateViewTransform(ViewTransform viewTransform, ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.getAndClearSnapRequired()) {
            Runnable runnable = this.mSnapRunnable;
            synchronized (runnable) {
                ViewCompat.postOnAnimation((View)this.mTarget.getView(), (Runnable)this.mSnapRunnable);
                try {
                    this.mSnapRunnable.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        viewTransform.x = immutableViewportMetrics.viewportRectLeft;
        viewTransform.y = immutableViewportMetrics.viewportRectTop;
        viewTransform.width = immutableViewportMetrics.viewportRectWidth;
        viewTransform.height = immutableViewportMetrics.viewportRectHeight;
        viewTransform.scale = immutableViewportMetrics.zoomFactor;
        viewTransform.fixedLayerMarginTop = this.mLayerViewTranslation - this.mToolbarTranslation;
        float f = this.mTarget.getView().getHeight();
        viewTransform.fixedLayerMarginBottom = this.bottomOfCssViewport(immutableViewportMetrics) - f;
    }

    class SnapMetrics {
        public final int viewportWidth;
        public final int viewportHeight;
        public final float scrollChangeY;

        SnapMetrics(ImmutableViewportMetrics immutableViewportMetrics, float f) {
            this.viewportWidth = immutableViewportMetrics.viewportRectWidth;
            this.viewportHeight = immutableViewportMetrics.viewportRectHeight;
            this.scrollChangeY = f;
        }
    }

    class DynamicToolbarAnimationTask
    extends RenderTask {
        private final float mStartTranslation;
        private final float mEndTranslation;
        private final boolean mImmediate;
        private final boolean mShiftLayerView;
        private boolean mContinueAnimation;

        public DynamicToolbarAnimationTask(float f, boolean bl, boolean bl2) {
            super(false);
            this.mContinueAnimation = true;
            this.mStartTranslation = DynamicToolbarAnimator.this.mToolbarTranslation;
            this.mEndTranslation = f;
            this.mImmediate = bl;
            this.mShiftLayerView = bl2;
        }

        float getFinalToolbarTranslation() {
            return this.mEndTranslation;
        }

        @Override
        public boolean internalRun(long l, long l2) {
            if (!this.mContinueAnimation) {
                return false;
            }
            final float f = this.mImmediate ? 1.0f : DynamicToolbarAnimator.this.mInterpolator.getInterpolation(Math.min(1.0f, (float)(System.nanoTime() - this.getStartTime()) / 2.5E8f));
            ThreadUtils.assertNotOnUiThread();
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    DynamicToolbarAnimator.this.mToolbarTranslation = FloatUtils.interpolate((float)DynamicToolbarAnimationTask.this.mStartTranslation, (float)DynamicToolbarAnimationTask.this.mEndTranslation, (float)f);
                    DynamicToolbarAnimator.this.fireListeners();
                    if (DynamicToolbarAnimationTask.this.mShiftLayerView && f >= 1.0f) {
                        DynamicToolbarAnimator.this.shiftLayerView(DynamicToolbarAnimationTask.this.mEndTranslation);
                    }
                }
            });
            DynamicToolbarAnimator.this.mTarget.getView().requestRender();
            if (f >= 1.0f) {
                this.mContinueAnimation = false;
            }
            return this.mContinueAnimation;
        }
    }
}

