/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.BookmarksListAdapter;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;

public class BookmarksListView
extends HomeListView
implements AdapterView.OnItemClickListener {
    public static final String LOGTAG = "GeckoBookmarksListView";

    public BookmarksListView(Context context) {
        this(context, null);
    }

    public BookmarksListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.bookmarksListViewStyle);
    }

    public BookmarksListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnItemClickListener(this);
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                int n2 = keyEvent.getAction();
                if (n2 == 1 && n == 4) {
                    return BookmarksListView.this.getBookmarksListAdapter().moveToParentFolder();
                }
                return false;
            }
        });
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        Cursor cursor;
        BookmarksListAdapter bookmarksListAdapter = this.getBookmarksListAdapter();
        if (bookmarksListAdapter.isShowingChildFolder()) {
            if (n == 0) {
                bookmarksListAdapter.moveToParentFolder();
                return;
            }
            --n;
        }
        if ((cursor = bookmarksListAdapter.getCursor()) == null) {
            return;
        }
        cursor.moveToPosition(n);
        int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
        if (n2 == 0) {
            int n3 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            String string2 = bookmarksListAdapter.getFolderTitle(adapterView.getContext(), cursor);
            bookmarksListAdapter.moveToChildFolder(n3, string2);
        } else {
            String string3 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "bookmarks");
            this.getOnUrlOpenListener().onUrlOpen(string3, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
        }
    }

    @Override
    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
        BookmarksListAdapter bookmarksListAdapter = this.getBookmarksListAdapter();
        if (bookmarksListAdapter.isShowingChildFolder()) {
            --n;
        }
        return super.onItemLongClick(adapterView, view, n, l);
    }

    private BookmarksListAdapter getBookmarksListAdapter() {
        ListAdapter listAdapter = this.getAdapter();
        BookmarksListAdapter bookmarksListAdapter = listAdapter instanceof HeaderViewListAdapter ? (BookmarksListAdapter)((HeaderViewListAdapter)listAdapter).getWrappedAdapter() : (BookmarksListAdapter)listAdapter;
        return bookmarksListAdapter;
    }
}

