/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

abstract class MultiTypeCursorAdapter
extends CursorAdapter {
    private final int[] mViewTypes;
    private final int[] mLayouts;

    public abstract void bindView(View var1, Context var2, int var3);

    public MultiTypeCursorAdapter(Context context, Cursor cursor, int[] nArray, int[] nArray2) {
        super(context, cursor, 0);
        if (nArray.length != nArray2.length) {
            throw new IllegalStateException("The view types and the layouts should be of same size");
        }
        this.mViewTypes = nArray;
        this.mLayouts = nArray2;
    }

    public final int getViewTypeCount() {
        return this.mViewTypes.length;
    }

    public final Cursor getCursor(int n) {
        Cursor cursor = this.getCursor();
        if (cursor == null || !cursor.moveToPosition(n)) {
            throw new IllegalStateException("Couldn't move cursor to position " + n);
        }
        return cursor;
    }

    public final View getView(int n, View view, ViewGroup viewGroup) {
        Context context = viewGroup.getContext();
        if (view == null) {
            view = this.newView(context, n, viewGroup);
        }
        this.bindView(view, context, n);
        return view;
    }

    public final void bindView(View view, Context context, Cursor cursor) {
    }

    public boolean hasStableIds() {
        return false;
    }

    public final View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return null;
    }

    private View newView(Context context, int n, ViewGroup viewGroup) {
        int n2 = this.getItemViewType(n);
        int n3 = this.mViewTypes.length;
        for (int i = 0; i < n3; ++i) {
            if (this.mViewTypes[i] != n2) continue;
            return LayoutInflater.from((Context)context).inflate(this.mLayouts[i], viewGroup, false);
        }
        return null;
    }
}

