/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.util.Pair;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.GeckoScreenOrientation;
import org.mozilla.gecko.R;
import org.mozilla.gecko.fxa.AccountLoader;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.RemoteTabsExpandableListFragment;
import org.mozilla.gecko.home.RemoteTabsSplitPlaneFragment;
import org.mozilla.gecko.home.RemoteTabsStaticFragment;
import org.mozilla.gecko.util.HardwareUtils;

public class RemoteTabsPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoRemoteTabsPanel";
    private static final int LOADER_ID_ACCOUNT = 0;
    private static final String FRAGMENT_ACTION = "FRAGMENT_ACTION";
    private static final String FRAGMENT_ORIENTATION = "FRAGMENT_ORIENTATION";
    private static final String FRAGMENT_TAG = "FRAGMENT_TAG";
    private static final String NO_ACCOUNT = "NO_ACCOUNT";
    private AccountLoaderCallbacks mAccountLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_panel, viewGroup, false);
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAccountLoaderCallbacks = new AccountLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    protected void loadIfVisible() {
        Pair<String, Integer> pair;
        if (this.canLoad() && HardwareUtils.isTablet() && (pair = this.getActionAndOrientationForFragmentInBackStack()) != null && ((String)pair.first).equals(State.Action.None.name()) && ((Integer)pair.second).intValue() != GeckoScreenOrientation.getInstance().getAndroidOrientation()) {
            this.getChildFragmentManager().beginTransaction().addToBackStack(null).remove(this.getChildFragmentManager().findFragmentByTag(FRAGMENT_TAG)).commitAllowingStateLoss();
            this.getChildFragmentManager().executePendingTransactions();
            this.load();
            return;
        }
        super.loadIfVisible();
    }

    @Override
    public void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mAccountLoaderCallbacks);
    }

    private void showSubPanel(Account account) {
        State.Action action = this.getActionNeeded(account);
        String string2 = action != null ? action.name() : NO_ACCOUNT;
        int n = HardwareUtils.isTablet() ? GeckoScreenOrientation.getInstance().getAndroidOrientation() : 0;
        Pair<String, Integer> pair = this.getActionAndOrientationForFragmentInBackStack();
        if (pair != null && ((String)pair.first).equals(string2) && (Integer)pair.second == n) {
            return;
        }
        Fragment fragment = this.makeFragmentForAction(action);
        Bundle bundle = new Bundle();
        bundle.putBoolean("canLoad", this.getCanLoadHint());
        bundle.putString(FRAGMENT_ACTION, string2);
        bundle.putInt(FRAGMENT_ORIENTATION, n);
        fragment.setArguments(bundle);
        this.getChildFragmentManager().beginTransaction().addToBackStack(null).replace(R.id.remote_tabs_container, fragment, FRAGMENT_TAG).commitAllowingStateLoss();
    }

    private Pair<String, Integer> getActionAndOrientationForFragmentInBackStack() {
        Fragment fragment = this.getChildFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment != null && fragment.getArguments() != null) {
            String string2 = fragment.getArguments().getString(FRAGMENT_ACTION);
            int n = fragment.getArguments().getInt(FRAGMENT_ORIENTATION);
            return Pair.create((Object)string2, (Object)n);
        }
        return null;
    }

    private State.Action getActionNeeded(Account account) {
        if (account == null) {
            return null;
        }
        if (!"org.mozilla.fennec_fxaccount".equals(account.type)) {
            Log.wtf((String)LOGTAG, (String)"Non Sync, non Firefox Android Account returned by AccountLoader; returning null.");
            return null;
        }
        State state = FirefoxAccounts.getFirefoxAccountState((Context)this.getActivity());
        if (state == null) {
            Log.wtf((String)LOGTAG, (String)"Firefox Account with null state found; offering needs password.");
            return State.Action.NeedsPassword;
        }
        State.Action action = state.getNeededAction();
        if (action == null) {
            Log.wtf((String)LOGTAG, (String)"Firefox Account with non-null state but null action needed; offering needs password.");
            return State.Action.NeedsPassword;
        }
        return action;
    }

    private Fragment makeFragmentForAction(State.Action action) {
        if (action == null) {
            return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_setup);
        }
        switch (action) {
            case None: {
                if (HardwareUtils.isTablet() && GeckoScreenOrientation.getInstance().getAndroidOrientation() == 2) {
                    return new RemoteTabsSplitPlaneFragment();
                }
                return new RemoteTabsExpandableListFragment();
            }
            case NeedsVerification: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_verification);
            }
            case NeedsPassword: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_password);
            }
            case NeedsUpgrade: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_upgrade);
            }
            case NeedsFinishMigrating: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_finish_migrating);
            }
        }
        Log.wtf((String)LOGTAG, (String)"Got unexpected action needed; offering needs password.");
        return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_password);
    }

    protected void updateUiFromAccount(Account account) {
        if (this.getView() == null) {
            return;
        }
        this.showSubPanel(account);
    }

    private class AccountLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Account> {
        private AccountLoaderCallbacks() {
        }

        public Loader<Account> onCreateLoader(int n, Bundle bundle) {
            return new AccountLoader((Context)RemoteTabsPanel.this.getActivity());
        }

        public void onLoadFinished(Loader<Account> loader, Account account) {
            RemoteTabsPanel.this.updateUiFromAccount(account);
        }

        public void onLoaderReset(Loader<Account> loader) {
            RemoteTabsPanel.this.updateUiFromAccount(null);
        }
    }
}

