/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.Collections;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.util.ColorUtils;

public class SearchEngineAdapter
extends RecyclerView.Adapter<SearchEngineViewHolder> {
    private static final String LOGTAG = SearchEngineAdapter.class.getSimpleName();
    private static final int VIEW_TYPE_SEARCH_ENGINE = 0;
    private static final int VIEW_TYPE_LABEL = 1;
    private final Context mContext;
    private int mContainerWidth;
    private List<SearchEngine> mSearchEngines = Collections.emptyList();

    public void setSearchEngines(List<SearchEngine> list) {
        this.mSearchEngines = list;
        this.notifyDataSetChanged();
    }

    void setIconContainerWidth(int n) {
        this.mContainerWidth = n;
    }

    public SearchEngineAdapter(Context context) {
        this.mContext = context;
    }

    public int getItemViewType(int n) {
        return n == 0 ? 1 : 0;
    }

    public SearchEngine getItem(int n) {
        return n == 0 ? null : this.mSearchEngines.get(n - 1);
    }

    public SearchEngineViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        switch (n) {
            case 1: {
                return new SearchEngineViewHolder(this.createLabelView(viewGroup));
            }
            case 0: {
                return new SearchEngineViewHolder(this.createSearchEngineView(viewGroup));
            }
        }
        throw new IllegalArgumentException("Unknown view type: " + n);
    }

    public void onBindViewHolder(SearchEngineViewHolder searchEngineViewHolder, int n) {
        if (n != 0) {
            searchEngineViewHolder.bindItem(this.getItem(n));
        }
    }

    public int getItemCount() {
        return this.mSearchEngines.size() + 1;
    }

    private View createLabelView(ViewGroup viewGroup) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.search_engine_bar_label, viewGroup, false);
        Drawable drawable2 = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.search_icon_active).mutate());
        DrawableCompat.setTint((Drawable)drawable2, (int)ColorUtils.getColor((Context)this.mContext, (int)R.color.disabled_grey));
        ImageView imageView = (ImageView)view.findViewById(R.id.search_engine_label);
        imageView.setImageDrawable(drawable2);
        return view;
    }

    private View createSearchEngineView(ViewGroup viewGroup) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.search_engine_bar_item, viewGroup, false);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = this.mContainerWidth;
        view.setLayoutParams(layoutParams);
        return view;
    }

    public static class SearchEngineViewHolder
    extends RecyclerView.ViewHolder {
        private final ImageView faviconView;

        public void bindItem(SearchEngine searchEngine) {
            this.faviconView.setImageBitmap(searchEngine.getIcon());
            String string2 = this.itemView.getResources().getString(R.string.search_bar_item_desc, new Object[]{searchEngine.getEngineIdentifier()});
            this.itemView.setContentDescription((CharSequence)string2);
        }

        public SearchEngineViewHolder(View view) {
            super(view);
            this.faviconView = (ImageView)view.findViewById(R.id.search_engine_icon);
        }
    }
}

