/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.restrictions;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.os.StrictMode;
import android.os.UserManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictionConfiguration;
import org.mozilla.gecko.util.ThreadUtils;

@TargetApi(value=18)
public class RestrictedProfileConfiguration
implements RestrictionConfiguration {
    private static Map<Restrictable, Boolean> configuration = new LinkedHashMap<Restrictable, Boolean>();
    private static List<Restrictable> hiddenRestrictions;
    private Context context;
    private Bundle cachedAppRestrictions;
    private Bundle cachedUserRestrictions;
    private boolean isCacheInvalid = true;

    static boolean shouldHide(Restrictable restrictable) {
        return hiddenRestrictions.contains((Object)restrictable);
    }

    static Map<Restrictable, Boolean> getConfiguration() {
        return configuration;
    }

    public RestrictedProfileConfiguration(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public synchronized boolean isAllowed(Restrictable restrictable) {
        if (this.isCacheInvalid || !ThreadUtils.isOnUiThread()) {
            this.readRestrictions();
            this.isCacheInvalid = false;
        }
        if (restrictable == Restrictable.INSTALL_APPS || restrictable == Restrictable.MODIFY_ACCOUNTS) {
            return !this.cachedUserRestrictions.getBoolean(restrictable.name);
        }
        if (!this.cachedAppRestrictions.containsKey(restrictable.name) && !configuration.containsKey((Object)restrictable)) {
            return true;
        }
        return this.cachedAppRestrictions.getBoolean(restrictable.name, configuration.get((Object)restrictable).booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRestrictions() {
        UserManager userManager = (UserManager)this.context.getSystemService("user");
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Bundle bundle = userManager.getApplicationRestrictions(this.context.getPackageName());
            RestrictedProfileConfiguration.migrateRestrictionsIfNeeded(bundle);
            this.cachedAppRestrictions = bundle;
            this.cachedUserRestrictions = userManager.getUserRestrictions();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    @Override
    public boolean canLoadUrl(String string2) {
        if (!this.isAllowed(Restrictable.INSTALL_EXTENSION) && AboutPages.isAboutAddons(string2)) {
            return false;
        }
        if (!this.isAllowed(Restrictable.PRIVATE_BROWSING) && AboutPages.isAboutPrivateBrowsing(string2)) {
            return false;
        }
        return !AboutPages.isAboutConfig(string2);
    }

    @Override
    public boolean isRestricted() {
        return true;
    }

    @Override
    public synchronized void update() {
        this.isCacheInvalid = true;
    }

    public static List<Restrictable> getVisibleRestrictions() {
        ArrayList<Restrictable> arrayList = new ArrayList<Restrictable>();
        for (Restrictable restrictable : configuration.keySet()) {
            if (hiddenRestrictions.contains((Object)restrictable)) continue;
            arrayList.add(restrictable);
        }
        return arrayList;
    }

    public static void migrateRestrictionsIfNeeded(Bundle bundle) {
        if (!bundle.containsKey(Restrictable.INSTALL_EXTENSION.name) && bundle.containsKey("no_install_extensions")) {
            bundle.putBoolean(Restrictable.INSTALL_EXTENSION.name, !bundle.getBoolean("no_install_extensions"));
        }
        if (!bundle.containsKey(Restrictable.PRIVATE_BROWSING.name) && bundle.containsKey("no_private_browsing")) {
            bundle.putBoolean(Restrictable.PRIVATE_BROWSING.name, !bundle.getBoolean("no_private_browsing"));
        }
        if (!bundle.containsKey(Restrictable.CLEAR_HISTORY.name) && bundle.containsKey("no_clear_history")) {
            bundle.putBoolean(Restrictable.CLEAR_HISTORY.name, !bundle.getBoolean("no_clear_history"));
        }
        if (!bundle.containsKey(Restrictable.ADVANCED_SETTINGS.name) && bundle.containsKey("no_advanced_settings")) {
            bundle.putBoolean(Restrictable.ADVANCED_SETTINGS.name, !bundle.getBoolean("no_advanced_settings"));
        }
    }

    static {
        configuration.put(Restrictable.INSTALL_EXTENSION, false);
        configuration.put(Restrictable.PRIVATE_BROWSING, false);
        configuration.put(Restrictable.CLEAR_HISTORY, false);
        configuration.put(Restrictable.MASTER_PASSWORD, false);
        configuration.put(Restrictable.GUEST_BROWSING, false);
        configuration.put(Restrictable.ADVANCED_SETTINGS, false);
        configuration.put(Restrictable.CAMERA_MICROPHONE, false);
        configuration.put(Restrictable.DATA_CHOICES, false);
        configuration.put(Restrictable.BLOCK_LIST, false);
        configuration.put(Restrictable.TELEMETRY, false);
        configuration.put(Restrictable.HEALTH_REPORT, true);
        configuration.put(Restrictable.DEFAULT_THEME, true);
        hiddenRestrictions = new ArrayList<Restrictable>();
        hiddenRestrictions.add(Restrictable.MASTER_PASSWORD);
        hiddenRestrictions.add(Restrictable.GUEST_BROWSING);
        hiddenRestrictions.add(Restrictable.DATA_CHOICES);
        hiddenRestrictions.add(Restrictable.DEFAULT_THEME);
    }
}

