/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ThreadUtils;

public class TabQueueHelper {
    private static final String LOGTAG = "Gecko" + TabQueueHelper.class.getSimpleName();
    public static final boolean TAB_QUEUE_ENABLED = AppConstants.Versions.feature11Plus;
    public static final String FILE_NAME = "tab_queue_url_list.json";
    public static final String LOAD_URLS_ACTION = "TAB_QUEUE_LOAD_URLS_ACTION";
    public static final int TAB_QUEUE_NOTIFICATION_ID = R.id.tabQueueNotification;
    public static final String PREF_TAB_QUEUE_COUNT = "tab_queue_count";
    public static final String PREF_TAB_QUEUE_LAUNCHES = "tab_queue_launches";
    public static final String PREF_TAB_QUEUE_TIMES_PROMPT_SHOWN = "tab_queue_times_prompt_shown";
    public static final int MAX_TIMES_TO_SHOW_PROMPT = 3;
    public static final int EXTERNAL_LAUNCHES_BEFORE_SHOWING_PROMPT = 3;
    public static final int TAB_QUEUE_YES = 201;
    public static final int TAB_QUEUE_NO = 202;

    public static boolean canDrawOverlays(Context context) {
        if (AppConstants.Versions.preM) {
            return true;
        }
        return Settings.canDrawOverlays((Context)context);
    }

    public static boolean shouldShowTabQueuePrompt(Context context) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        int n = sharedPreferences.getInt(PREF_TAB_QUEUE_TIMES_PROMPT_SHOWN, 0);
        if (TabQueueHelper.isTabQueueEnabled(sharedPreferences) || n >= 3) {
            return false;
        }
        int n2 = sharedPreferences.getInt(PREF_TAB_QUEUE_LAUNCHES, 0) + 1;
        if (n2 < 3) {
            sharedPreferences.edit().putInt(PREF_TAB_QUEUE_LAUNCHES, n2).apply();
        } else if (n2 == 3) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(PREF_TAB_QUEUE_LAUNCHES);
            int n3 = sharedPreferences.getInt(PREF_TAB_QUEUE_TIMES_PROMPT_SHOWN, 0) + 1;
            editor.putInt(PREF_TAB_QUEUE_TIMES_PROMPT_SHOWN, n3);
            editor.apply();
            return true;
        }
        return false;
    }

    public static int queueURL(GeckoProfile geckoProfile, String string2, String string3) {
        ThreadUtils.assertNotOnUiThread();
        JSONArray jSONArray = geckoProfile.readJSONArrayFromFile(string3);
        jSONArray.put((Object)string2);
        geckoProfile.writeFile(string3, jSONArray.toString());
        return jSONArray.length();
    }

    public static int removeURLFromFile(Context context, String string2, String string3) {
        ThreadUtils.assertNotOnUiThread();
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        JSONArray jSONArray = geckoProfile.readJSONArrayFromFile(string3);
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string4;
            try {
                string4 = jSONArray.getString(i);
            }
            catch (JSONException jSONException) {
                string4 = "";
            }
            if (TextUtils.isEmpty((CharSequence)string4) || string2.equals(string4)) continue;
            jSONArray2.put((Object)string4);
        }
        geckoProfile.writeFile(string3, jSONArray2.toString());
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        sharedPreferences.edit().putInt(PREF_TAB_QUEUE_COUNT, jSONArray2.length()).apply();
        return jSONArray2.length();
    }

    public static List<String> getLastURLs(Context context, String string2) {
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        JSONArray jSONArray = geckoProfile.readJSONArrayFromFile(string2);
        ArrayList<String> arrayList = new ArrayList<String>(8);
        for (int i = 0; i < 8; ++i) {
            try {
                arrayList.add(jSONArray.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"Unable to parse URL from tab queue array", (Throwable)jSONException);
            }
        }
        return arrayList;
    }

    public static void showNotification(Context context, int n, List<String> list) {
        String string22;
        ThreadUtils.assertNotOnUiThread();
        Intent intent = new Intent();
        intent.setClassName(context, "org.mozilla.gecko.BrowserApp");
        intent.setAction(LOAD_URLS_ACTION);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        Resources resources = context.getResources();
        String string3 = n == 1 ? resources.getString(R.string.tab_queue_notification_text_singular) : resources.getString(R.string.tab_queue_notification_text_plural, new Object[]{n});
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)string3);
        for (String string22 : list) {
            inboxStyle.addLine((CharSequence)string22);
        }
        inboxStyle.setSummaryText((CharSequence)resources.getString(R.string.tab_queue_notification_title));
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setSmallIcon(R.drawable.ic_status_logo).setContentTitle((CharSequence)string3).setContentText((CharSequence)resources.getString(R.string.tab_queue_notification_title)).setStyle((NotificationCompat.Style)inboxStyle).setColor(ContextCompat.getColor((Context)context, (int)R.color.fennec_ui_orange)).setNumber(n).setContentIntent(pendingIntent);
        string22 = (NotificationManager)context.getSystemService("notification");
        string22.notify(TAB_QUEUE_NOTIFICATION_ID, builder.build());
    }

    public static boolean shouldOpenTabQueueUrls(Context context) {
        ThreadUtils.assertNotOnUiThread();
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        int n = sharedPreferences.getInt(PREF_TAB_QUEUE_COUNT, 0);
        return TabQueueHelper.isTabQueueEnabled(sharedPreferences) && n > 0;
    }

    public static int getTabQueueLength(Context context) {
        ThreadUtils.assertNotOnUiThread();
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        return sharedPreferences.getInt(PREF_TAB_QUEUE_COUNT, 0);
    }

    public static void openQueuedUrls(Context context, GeckoProfile geckoProfile, String string2, boolean bl) {
        JSONObject jSONObject;
        ThreadUtils.assertNotOnUiThread();
        TabQueueHelper.removeNotification(context);
        if (TabQueueHelper.getTabQueueLength(context) < 1) {
            return;
        }
        JSONArray jSONArray = geckoProfile.readJSONArrayFromFile(string2);
        if (jSONArray.length() > 0) {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("urls", (Object)jSONArray);
                jSONObject.put("shouldNotifyTabsOpenedToJava", bl);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tabs:OpenMultiple", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error sending tab queue data", (Throwable)jSONException);
            }
        }
        try {
            geckoProfile.deleteFileFromProfileDir(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)LOGTAG, (String)"Error deleting Tab Queue data file.", (Throwable)illegalArgumentException);
        }
        jSONObject = GeckoSharedPrefs.forApp(context);
        jSONObject.edit().remove(PREF_TAB_QUEUE_COUNT).apply();
    }

    protected static void removeNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(TAB_QUEUE_NOTIFICATION_ID);
    }

    public static boolean processTabQueuePromptResponse(int n, Context context) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        switch (n) {
            case 201: {
                editor.putBoolean("android.not_a_preference.tab_queue", true);
                editor.putInt(PREF_TAB_QUEUE_LAUNCHES, 4);
                break;
            }
            case 202: {
                editor.putInt(PREF_TAB_QUEUE_LAUNCHES, 4);
                editor.putInt(PREF_TAB_QUEUE_TIMES_PROMPT_SHOWN, 4);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Unrecognized result code received from the tab queue prompt: " + n));
            }
        }
        editor.apply();
        return n == 201;
    }

    public static boolean isTabQueueEnabled(Context context) {
        return TabQueueHelper.isTabQueueEnabled(GeckoSharedPrefs.forApp(context));
    }

    public static boolean isTabQueueEnabled(SharedPreferences sharedPreferences) {
        return sharedPreferences.getBoolean("android.not_a_preference.tab_queue", false);
    }
}

