/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Log;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.telemetry.TelemetryPing;
import org.mozilla.gecko.telemetry.TelemetryPingGenerator;
import org.mozilla.gecko.util.StringUtils;

public class TelemetryUploadService
extends BackgroundService {
    private static final String LOGTAG = StringUtils.safeSubstring((String)("Gecko" + TelemetryUploadService.class.getSimpleName()), (int)0, (int)23);
    private static final String WORKER_THREAD_NAME = LOGTAG + "Worker";

    public TelemetryUploadService() {
        super(WORKER_THREAD_NAME);
        this.setIntentRedelivery(false);
    }

    public void onHandleIntent(Intent intent) {
        Log.d((String)LOGTAG, (String)"Service started");
        if (!this.isReadyToUpload(intent)) {
            return;
        }
        if (!"uploadCore".equals(intent.getAction())) {
            Log.w((String)LOGTAG, (String)("Unknown action: " + intent.getAction() + ". Returning"));
            return;
        }
        String string2 = intent.getStringExtra("docId");
        int n = intent.getIntExtra("seq", -1);
        String string3 = intent.getStringExtra("geckoProfileName");
        String string4 = intent.getStringExtra("geckoProfilePath");
        this.uploadCorePing(string2, n, string3, string4);
    }

    private boolean isReadyToUpload(Intent intent) {
        if (intent == null) {
            Log.d((String)LOGTAG, (String)"Received null intent. Returning.");
            return false;
        }
        if (!this.backgroundDataIsEnabled()) {
            Log.d((String)LOGTAG, (String)"Background data is not enabled; skipping.");
            return false;
        }
        if (intent.getStringExtra("docId") == null) {
            Log.w((String)LOGTAG, (String)"Received invalid doc ID in Intent. Returning");
            return false;
        }
        if (!intent.hasExtra("seq")) {
            Log.w((String)LOGTAG, (String)"Received Intent without sequence number. Returning");
            return false;
        }
        if (intent.getStringExtra("geckoProfileName") == null) {
            Log.w((String)LOGTAG, (String)"Received invalid profile name in Intent. Returning");
            return false;
        }
        if (intent.getStringExtra("geckoProfilePath") == null) {
            Log.w((String)LOGTAG, (String)"Received invalid profile path in Intent. Returning");
            return false;
        }
        return true;
    }

    private void uploadCorePing(@NonNull String string2, int n, @NonNull String string3, @NonNull String string4) {
        String string5;
        GeckoProfile geckoProfile = GeckoProfile.get((Context)this, string3, string4);
        try {
            string5 = geckoProfile.getClientId();
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)"Unable to get client ID to generate core ping: returning.");
            return;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfileName((Context)this, string3);
        String string6 = sharedPreferences.getString("telemetry-serverUrl", "https://incoming.telemetry.mozilla.org");
        TelemetryPing telemetryPing = TelemetryPingGenerator.createCorePing((Context)this, string2, string5, string6, n);
        CorePingResultDelegate corePingResultDelegate = new CorePingResultDelegate();
        this.uploadPing(telemetryPing, corePingResultDelegate);
    }

    private void uploadPing(TelemetryPing telemetryPing, ResultDelegate resultDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(telemetryPing.getURL());
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.w((String)LOGTAG, (String)"URISyntaxException for server URL when creating BaseResource: returning.");
            return;
        }
        resultDelegate.setResource((Resource)baseResource);
        baseResource.delegate = resultDelegate;
        baseResource.postBlocking(telemetryPing.getPayload());
    }

    private static abstract class ResultDelegate
    extends BaseResourceDelegate {
        public ResultDelegate() {
            super(null);
        }

        protected void setResource(Resource resource) {
            this.resource = resource;
        }
    }

    private static class CorePingResultDelegate
    extends ResultDelegate {
        public String getUserAgent() {
            return "Firefox-Android-Telemetry/47.0a1 (Firefox)";
        }

        public void handleHttpResponse(HttpResponse httpResponse) {
            int n = httpResponse.getStatusLine().getStatusCode();
            switch (n) {
                case 200: 
                case 201: {
                    Log.d((String)LOGTAG, (String)"Telemetry upload success.");
                    break;
                }
                default: {
                    Log.w((String)LOGTAG, (String)("Telemetry upload failure. HTTP status: " + n));
                }
            }
        }

        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            Log.w((String)LOGTAG, (String)"HttpProtocolException when trying to upload telemetry");
        }

        public void handleHttpIOException(IOException iOException) {
            Log.w((String)LOGTAG, (String)"HttpIOException when trying to upload telemetry");
        }

        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            Log.w((String)LOGTAG, (String)"Transport exception when trying to upload telemetry");
        }
    }
}

