/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import java.util.ArrayList;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarEditText;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.DrawableUtil;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.InputOptionsUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.widget.themed.ThemedLinearLayout;

public class ToolbarEditLayout
extends ThemedLinearLayout {
    private final ImageView mSearchIcon;
    private final ToolbarEditText mEditText;
    private final ImageButton mVoiceInput;
    private final ImageButton mQrCode;
    private View.OnFocusChangeListener mFocusChangeListener;
    private boolean showKeyboardOnFocus = false;

    public ToolbarEditLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.toolbar_edit_layout, (ViewGroup)this);
        this.mSearchIcon = (ImageView)this.findViewById(R.id.search_icon);
        this.mEditText = (ToolbarEditText)this.findViewById(R.id.url_edit_text);
        this.mVoiceInput = (ImageButton)this.findViewById(R.id.mic);
        this.mQrCode = (ImageButton)this.findViewById(R.id.qrcode);
    }

    @Override
    public void onAttachedToWindow() {
        if (HardwareUtils.isTablet()) {
            this.mSearchIcon.setVisibility(0);
        }
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (ToolbarEditLayout.this.mFocusChangeListener != null) {
                    ToolbarEditLayout.this.mFocusChangeListener.onFocusChange((View)ToolbarEditLayout.this, bl);
                    if (bl) {
                        if (ToolbarEditLayout.this.voiceIsEnabled(ToolbarEditLayout.this.getContext(), ToolbarEditLayout.this.getResources().getString(R.string.voicesearch_prompt))) {
                            ToolbarEditLayout.this.mVoiceInput.setVisibility(0);
                        } else {
                            ToolbarEditLayout.this.mVoiceInput.setVisibility(8);
                        }
                        if (ToolbarEditLayout.this.qrCodeIsEnabled(ToolbarEditLayout.this.getContext())) {
                            ToolbarEditLayout.this.mQrCode.setVisibility(0);
                        } else {
                            ToolbarEditLayout.this.mQrCode.setVisibility(8);
                        }
                    }
                }
            }
        });
        this.mEditText.setOnSearchStateChangeListener(new OnSearchStateChangeListener(){

            @Override
            public void onSearchStateChange(boolean bl) {
                ToolbarEditLayout.this.updateSearchIcon(bl);
            }
        });
        this.mVoiceInput.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ToolbarEditLayout.this.launchVoiceRecognizer();
            }
        });
        this.mQrCode.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ToolbarEditLayout.this.launchQRCodeReader();
            }
        });
        this.updateSearchIcon(false);
    }

    void updateSearchIcon(boolean bl) {
        if (!HardwareUtils.isTablet()) {
            return;
        }
        int n = R.drawable.search_icon_active;
        Drawable drawable2 = !bl ? DrawableUtil.tintDrawable((Context)this.getContext(), (int)n, (int)R.color.placeholder_grey) : (this.isPrivateMode() ? DrawableUtil.tintDrawable((Context)this.getContext(), (int)n, (int)R.color.tabs_tray_icon_grey) : this.getResources().getDrawable(n));
        this.mSearchIcon.setImageDrawable(drawable2);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mFocusChangeListener = onFocusChangeListener;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mEditText.setEnabled(bl);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mEditText.setPrivateMode(bl);
    }

    public void onParentFocus() {
        if (this.showKeyboardOnFocus) {
            this.showKeyboardOnFocus = false;
            Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ToolbarEditLayout.this.mEditText.requestFocus();
                    ToolbarEditLayout.this.showSoftInput();
                }
            });
        }
        if (this.qrCodeIsEnabled(this.getContext())) {
            this.mQrCode.setVisibility(0);
        } else {
            this.mQrCode.setVisibility(8);
        }
    }

    void setToolbarPrefs(ToolbarPrefs toolbarPrefs) {
        this.mEditText.setToolbarPrefs(toolbarPrefs);
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mEditText, 1);
    }

    void prepareShowAnimation(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.mEditText.requestFocus();
            this.showSoftInput();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                ToolbarEditLayout.this.mEditText.requestFocus();
            }

            @Override
            public void onPropertyAnimationEnd() {
                ToolbarEditLayout.this.showSoftInput();
            }
        });
    }

    void setOnCommitListener(BrowserToolbar.OnCommitListener onCommitListener) {
        this.mEditText.setOnCommitListener(onCommitListener);
    }

    void setOnDismissListener(BrowserToolbar.OnDismissListener onDismissListener) {
        this.mEditText.setOnDismissListener(onDismissListener);
    }

    void setOnFilterListener(BrowserToolbar.OnFilterListener onFilterListener) {
        this.mEditText.setOnFilterListener(onFilterListener);
    }

    void onEditSuggestion(String string2) {
        this.mEditText.setText(string2);
        this.mEditText.setSelection(this.mEditText.getText().length());
        this.mEditText.requestFocus();
        this.showSoftInput();
    }

    void setText(String string2) {
        this.mEditText.setText(string2);
    }

    String getText() {
        return this.mEditText.getText().toString();
    }

    protected void saveTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        tabEditingState.lastEditingText = this.mEditText.getNonAutocompleteText();
        tabEditingState.selectionStart = this.mEditText.getSelectionStart();
        tabEditingState.selectionEnd = this.mEditText.getSelectionEnd();
    }

    protected void restoreTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        this.mEditText.setText(tabEditingState.lastEditingText);
        this.mEditText.setSelection(tabEditingState.selectionStart, tabEditingState.selectionEnd);
    }

    private boolean voiceIsEnabled(Context context, String string2) {
        boolean bl = InputOptionsUtils.supportsVoiceRecognizer((Context)context, (String)string2);
        if (!bl) {
            return false;
        }
        return GeckoSharedPrefs.forApp(context).getBoolean("android.not_a_preference.voice_input_enabled", true);
    }

    private void launchVoiceRecognizer() {
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "voice_input_launch");
        Intent intent = InputOptionsUtils.createVoiceRecognizerIntent((String)this.getResources().getString(R.string.voicesearch_prompt));
        Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
        ActivityHandlerHelper.startIntentForActivity(activity, intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                if (n != -1) {
                    return;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "voice_input_success");
                ArrayList arrayList = intent.getStringArrayListExtra("android.speech.extra.RESULTS");
                String string2 = (String)arrayList.get(0);
                ToolbarEditLayout.this.mEditText.setText(string2);
                ToolbarEditLayout.this.mEditText.setSelection(0, string2.length());
                InputMethodManager inputMethodManager = (InputMethodManager)ToolbarEditLayout.this.getContext().getSystemService("input_method");
                inputMethodManager.showSoftInput((View)ToolbarEditLayout.this.mEditText, 1);
            }
        });
    }

    private boolean qrCodeIsEnabled(Context context) {
        boolean bl = InputOptionsUtils.supportsQrCodeReader((Context)context);
        if (!bl) {
            return false;
        }
        return GeckoSharedPrefs.forApp(context).getBoolean("android.not_a_preference.qrcode_enabled", true);
    }

    private void launchQRCodeReader() {
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "qrcode_input_launch");
        Intent intent = InputOptionsUtils.createQRCodeReaderIntent();
        Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
        ActivityHandlerHelper.startIntentForActivity(activity, intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                String string2;
                if (n == -1 && !StringUtils.isSearchQuery((String)(string2 = intent.getStringExtra("SCAN_RESULT")), (boolean)false)) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "qrcode_input_success");
                    ToolbarEditLayout.this.mEditText.setText(string2);
                    ToolbarEditLayout.this.mEditText.selectAll();
                    ToolbarEditLayout.this.showKeyboardOnFocus = true;
                }
            }
        });
    }

    public static interface OnSearchStateChangeListener {
        public void onSearchStateChange(boolean var1);
    }
}

