/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.CalendarView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;

public class DateTimePicker
extends FrameLayout {
    private static final boolean DEBUG = true;
    private static final String LOGTAG = "GeckoDateTimePicker";
    private static final int DEFAULT_START_YEAR = 1;
    private static final int DEFAULT_END_YEAR = 9999;
    private static final int SCREEN_SIZE_THRESHOLD = 5;
    private static final char DATE_FORMAT_DAY = 'd';
    private static final char DATE_FORMAT_MONTH = 'M';
    private static final char DATE_FORMAT_YEAR = 'y';
    boolean mYearEnabled = true;
    boolean mMonthEnabled = true;
    boolean mWeekEnabled;
    boolean mDayEnabled = true;
    boolean mHourEnabled = true;
    boolean mMinuteEnabled = true;
    boolean mIs12HourMode;
    private boolean mCalendarEnabled;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final OnValueChangeListener mOnChangeListener;
    private final LinearLayout mPickers;
    private final LinearLayout mDateSpinners;
    private final LinearLayout mTimeSpinners;
    final NumberPicker mDaySpinner;
    final NumberPicker mMonthSpinner;
    final NumberPicker mWeekSpinner;
    final NumberPicker mYearSpinner;
    final NumberPicker mHourSpinner;
    final NumberPicker mMinuteSpinner;
    final NumberPicker mAMPMSpinner;
    private final CalendarView mCalendar;
    private final EditText mDaySpinnerInput;
    private final EditText mMonthSpinnerInput;
    private final EditText mWeekSpinnerInput;
    private final EditText mYearSpinnerInput;
    private final EditText mHourSpinnerInput;
    private final EditText mMinuteSpinnerInput;
    private final EditText mAMPMSpinnerInput;
    private Locale mCurrentLocale;
    private String[] mShortMonths;
    private String[] mShortAMPMs;
    private int mNumberOfMonths;
    Calendar mTempDate;
    Calendar mCurrentDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private final PickersState mState;
    private static final NumberPicker.Formatter TWO_DIGIT_FORMATTER = new NumberPicker.Formatter(){
        final StringBuilder mBuilder = new StringBuilder();
        final Formatter mFmt = new Formatter(this.mBuilder, Locale.US);
        final Object[] mArgs = new Object[1];

        public String format(int n) {
            this.mArgs[0] = n;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }
    };

    private void displayPickers() {
        this.setWeekShown(false);
        this.set12HourShown(this.mIs12HourMode);
        if (this.mState == PickersState.DATETIME) {
            return;
        }
        this.setHourShown(false);
        this.setMinuteShown(false);
        if (this.mState == PickersState.WEEK) {
            this.setDayShown(false);
            this.setMonthShown(false);
            this.setWeekShown(true);
        } else if (this.mState == PickersState.MONTH) {
            this.setDayShown(false);
        }
    }

    public DateTimePicker(Context context) {
        this(context, "", "", PickersState.DATE, null, null);
    }

    public DateTimePicker(Context context, String string2, String string3, PickersState pickersState, String string4, String string5) {
        super(context);
        if (AppConstants.Versions.preHC) {
            throw new UnsupportedOperationException("Custom DateTimePicker is only available for SDK > 10");
        }
        this.setCurrentLocale(Locale.getDefault());
        this.mState = pickersState;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.datetime_picker, (ViewGroup)this, true);
        this.mOnChangeListener = new OnValueChangeListener();
        this.mDateSpinners = (LinearLayout)this.findViewById(R.id.date_spinners);
        this.mTimeSpinners = (LinearLayout)this.findViewById(R.id.time_spinners);
        this.mPickers = (LinearLayout)this.findViewById(R.id.datetime_picker);
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        this.mScreenWidth = display.getWidth() / displayMetrics.densityDpi;
        this.mScreenHeight = display.getHeight() / displayMetrics.densityDpi;
        Log.d((String)LOGTAG, (String)("screen width: " + this.mScreenWidth + " screen height: " + this.mScreenHeight));
        if (AppConstants.Versions.feature11Plus && (this.mState == PickersState.DATE || this.mState == PickersState.DATETIME) && this.mScreenWidth >= 5) {
            Log.d((String)LOGTAG, (String)"SDK > 10 and screen wide enough, displaying calendar");
            this.mCalendar = new CalendarView(context);
            this.mCalendar.setVisibility(8);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(250, 280);
            this.mCalendar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mCalendar.setFocusable(true);
            this.mCalendar.setFocusableInTouchMode(true);
            this.mCalendar.setMaxDate(this.mMaxDate.getTimeInMillis());
            this.mCalendar.setMinDate(this.mMinDate.getTimeInMillis());
            this.mCalendar.setDate(this.mTempDate.getTimeInMillis(), false, false);
            this.mCalendar.setOnDateChangeListener(new CalendarView.OnDateChangeListener(){

                public void onSelectedDayChange(CalendarView calendarView, int n, int n2, int n3) {
                    DateTimePicker.this.mTempDate.set(n, n2, n3);
                    DateTimePicker.this.setDate(DateTimePicker.this.mTempDate);
                    DateTimePicker.this.notifyDateChanged();
                }
            });
            this.mPickers.addView((View)this.mCalendar);
        } else {
            if (this.mScreenWidth > this.mScreenHeight && this.mState == PickersState.DATETIME) {
                this.mPickers.setOrientation(0);
            }
            this.mCalendar = null;
        }
        try {
            if (!string3.equals("")) {
                this.mTempDate.setTime(new SimpleDateFormat(string2).parse(string3));
            } else {
                this.mTempDate.setTimeInMillis(System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Error parsing format string: " + exception));
            this.mTempDate.setTimeInMillis(System.currentTimeMillis());
        }
        try {
            if (string4 != null && !string4.equals("")) {
                this.mMinDate.setTime(new SimpleDateFormat(string2).parse(string4));
            } else {
                this.mMinDate.set(1, 0, 1);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Error parsing format sting: " + exception));
            this.mMinDate.set(1, 0, 1);
        }
        try {
            if (string5 != null && !string5.equals("")) {
                this.mMaxDate.setTime(new SimpleDateFormat(string2).parse(string5));
            } else {
                this.mMaxDate.set(9999, 11, 31);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Error parsing format string: " + exception));
            this.mMaxDate.set(9999, 11, 31);
        }
        this.mDaySpinner = this.setupSpinner(R.id.day, 1, this.mTempDate.get(5));
        this.mDaySpinner.setFormatter(TWO_DIGIT_FORMATTER);
        this.mDaySpinnerInput = (EditText)this.mDaySpinner.getChildAt(1);
        this.mMonthSpinner = this.setupSpinner(R.id.month, 1, this.mTempDate.get(2) + 1);
        this.mMonthSpinner.setFormatter(TWO_DIGIT_FORMATTER);
        this.mMonthSpinner.setDisplayedValues(this.mShortMonths);
        this.mMonthSpinnerInput = (EditText)this.mMonthSpinner.getChildAt(1);
        this.mWeekSpinner = this.setupSpinner(R.id.week, 1, this.mTempDate.get(3));
        this.mWeekSpinner.setFormatter(TWO_DIGIT_FORMATTER);
        this.mWeekSpinnerInput = (EditText)this.mWeekSpinner.getChildAt(1);
        this.mYearSpinner = this.setupSpinner(R.id.year, 1, 9999);
        this.mYearSpinnerInput = (EditText)this.mYearSpinner.getChildAt(1);
        this.mAMPMSpinner = this.setupSpinner(R.id.ampm, 0, 1);
        this.mAMPMSpinner.setFormatter(TWO_DIGIT_FORMATTER);
        if (this.mIs12HourMode) {
            this.mHourSpinner = this.setupSpinner(R.id.hour, 1, 12);
            this.mAMPMSpinnerInput = (EditText)this.mAMPMSpinner.getChildAt(1);
            this.mAMPMSpinner.setDisplayedValues(this.mShortAMPMs);
        } else {
            this.mHourSpinner = this.setupSpinner(R.id.hour, 0, 23);
            this.mAMPMSpinnerInput = null;
        }
        this.mHourSpinner.setFormatter(TWO_DIGIT_FORMATTER);
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.getChildAt(1);
        this.mMinuteSpinner = this.setupSpinner(R.id.minute, 0, 59);
        this.mMinuteSpinner.setFormatter(TWO_DIGIT_FORMATTER);
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.getChildAt(1);
        this.reorderDateSpinners();
        try {
            this.updateDate(this.mTempDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayPickers();
    }

    public NumberPicker setupSpinner(int n, int n2, int n3) {
        NumberPicker numberPicker = (NumberPicker)this.findViewById(n);
        numberPicker.setMinValue(n2);
        numberPicker.setMaxValue(n3);
        numberPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this.mOnChangeListener);
        numberPicker.setOnLongPressUpdateInterval(100L);
        return numberPicker;
    }

    public long getTimeInMillis() {
        return this.mCurrentDate.getTimeInMillis();
    }

    private void reorderDateSpinners() {
        this.mDateSpinners.removeAllViews();
        char[] cArray = DateFormat.getDateFormatOrder((Context)this.getContext());
        int n = cArray.length;
        block5: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case 'd': {
                    this.mDateSpinners.addView((View)this.mDaySpinner);
                    continue block5;
                }
                case 'M': {
                    this.mDateSpinners.addView((View)this.mMonthSpinner);
                    continue block5;
                }
                case 'y': {
                    this.mDateSpinners.addView((View)this.mYearSpinner);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.mDateSpinners.addView((View)this.mWeekSpinner);
    }

    void setDate(Calendar calendar) {
        this.mCurrentDate = this.mTempDate;
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        } else if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
    }

    void updateInputState() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (this.mYearEnabled && inputMethodManager.isActive((View)this.mYearSpinnerInput)) {
            this.mYearSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        } else if (this.mMonthEnabled && inputMethodManager.isActive((View)this.mMonthSpinnerInput)) {
            this.mMonthSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        } else if (this.mDayEnabled && inputMethodManager.isActive((View)this.mDaySpinnerInput)) {
            this.mDaySpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        } else if (this.mHourEnabled && inputMethodManager.isActive((View)this.mHourSpinnerInput)) {
            this.mHourSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        } else if (this.mMinuteEnabled && inputMethodManager.isActive((View)this.mMinuteSpinnerInput)) {
            this.mMinuteSpinnerInput.clearFocus();
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    void updateSpinners() {
        if (this.mDayEnabled) {
            if (this.mCurrentDate.equals(this.mMinDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            } else if (this.mCurrentDate.equals(this.mMaxDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
            } else {
                this.mDaySpinner.setMinValue(1);
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            }
            this.mDaySpinner.setValue(this.mCurrentDate.get(5));
        }
        if (this.mWeekEnabled) {
            this.mWeekSpinner.setMinValue(1);
            this.mWeekSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(3));
            this.mWeekSpinner.setValue(this.mCurrentDate.get(3));
        }
        if (this.mMonthEnabled) {
            this.mMonthSpinner.setDisplayedValues(null);
            if (this.mCurrentDate.equals(this.mMinDate)) {
                this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
            } else if (this.mCurrentDate.equals(this.mMaxDate)) {
                this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
            } else {
                this.mMonthSpinner.setMinValue(0);
                this.mMonthSpinner.setMaxValue(11);
            }
            String[] stringArray = Arrays.copyOfRange(this.mShortMonths, this.mMonthSpinner.getMinValue(), this.mMonthSpinner.getMaxValue() + 1);
            this.mMonthSpinner.setDisplayedValues(stringArray);
            this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
        }
        if (this.mYearEnabled) {
            this.mYearSpinner.setMinValue(this.mMinDate.get(1));
            this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
            this.mYearSpinner.setValue(this.mCurrentDate.get(1));
        }
        if (this.mHourEnabled) {
            if (this.mIs12HourMode) {
                this.mHourSpinner.setValue(this.mCurrentDate.get(10));
                this.mAMPMSpinner.setValue(this.mCurrentDate.get(9));
                this.mAMPMSpinner.setDisplayedValues(this.mShortAMPMs);
            } else {
                this.mHourSpinner.setValue(this.mCurrentDate.get(11));
            }
        }
        if (this.mMinuteEnabled) {
            this.mMinuteSpinner.setValue(this.mCurrentDate.get(12));
        }
    }

    void updateCalendar() {
        if (this.mCalendarEnabled) {
            this.mCalendar.setDate(this.mCurrentDate.getTimeInMillis(), false, false);
        }
    }

    void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
    }

    public void toggleCalendar(boolean bl) {
        if (AppConstants.Versions.preHC || this.mState != PickersState.DATE && this.mState != PickersState.DATETIME || this.mScreenWidth < 5) {
            Log.d((String)LOGTAG, (String)("Cannot display calendar on this device, in this state: screen width :" + this.mScreenWidth));
            return;
        }
        if (bl) {
            this.mCalendarEnabled = true;
            this.mCalendar.setVisibility(0);
            this.setYearShown(false);
            this.setWeekShown(false);
            this.setMonthShown(false);
            this.setDayShown(false);
        } else {
            this.mCalendar.setVisibility(8);
            this.setYearShown(true);
            this.setMonthShown(true);
            this.setDayShown(true);
            this.mPickers.setOrientation(0);
            this.mCalendarEnabled = false;
        }
    }

    private void setYearShown(boolean bl) {
        if (bl) {
            this.toggleCalendar(false);
            this.mYearSpinner.setVisibility(0);
            this.mYearEnabled = true;
        } else {
            this.mYearSpinner.setVisibility(8);
            this.mYearEnabled = false;
        }
    }

    private void setWeekShown(boolean bl) {
        if (bl) {
            this.toggleCalendar(false);
            this.mWeekSpinner.setVisibility(0);
            this.mWeekEnabled = true;
        } else {
            this.mWeekSpinner.setVisibility(8);
            this.mWeekEnabled = false;
        }
    }

    private void setMonthShown(boolean bl) {
        if (bl) {
            this.toggleCalendar(false);
            this.mMonthSpinner.setVisibility(0);
            this.mMonthEnabled = true;
        } else {
            this.mMonthSpinner.setVisibility(8);
            this.mMonthEnabled = false;
        }
    }

    private void setDayShown(boolean bl) {
        if (bl) {
            this.toggleCalendar(false);
            this.mDaySpinner.setVisibility(0);
            this.mDayEnabled = true;
        } else {
            this.mDaySpinner.setVisibility(8);
            this.mDayEnabled = false;
        }
    }

    private void set12HourShown(boolean bl) {
        if (bl) {
            this.mAMPMSpinner.setVisibility(0);
        } else {
            this.mAMPMSpinner.setVisibility(8);
        }
    }

    private void setHourShown(boolean bl) {
        if (bl) {
            this.mHourSpinner.setVisibility(0);
            this.mHourEnabled = true;
        } else {
            this.mHourSpinner.setVisibility(8);
            this.mAMPMSpinner.setVisibility(8);
            this.mTimeSpinners.setVisibility(8);
            this.mHourEnabled = false;
        }
    }

    private void setMinuteShown(boolean bl) {
        if (bl) {
            this.mMinuteSpinner.setVisibility(0);
            this.mTimeSpinners.findViewById(R.id.mincolon).setVisibility(0);
            this.mMinuteEnabled = true;
        } else {
            this.mMinuteSpinner.setVisibility(8);
            this.mTimeSpinners.findViewById(R.id.mincolon).setVisibility(8);
            this.mMinuteEnabled = false;
        }
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mIs12HourMode = !DateFormat.is24HourFormat((Context)this.getContext());
        this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mNumberOfMonths = this.mTempDate.getActualMaximum(2) + 1;
        this.mShortAMPMs = new String[2];
        this.mShortAMPMs[0] = DateUtils.getAMPMString((int)0);
        this.mShortAMPMs[1] = DateUtils.getAMPMString((int)1);
        this.mShortMonths = new String[this.mNumberOfMonths];
        for (int i = 0; i < this.mNumberOfMonths; ++i) {
            this.mShortMonths[i] = DateUtils.getMonthString((int)(0 + i), (int)20);
        }
    }

    private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
        if (calendar == null) {
            return Calendar.getInstance(locale);
        }
        long l = calendar.getTimeInMillis();
        Calendar calendar2 = Calendar.getInstance(locale);
        calendar2.setTimeInMillis(l);
        return calendar2;
    }

    public void updateDate(Calendar calendar) {
        if (this.mCurrentDate.equals(calendar)) {
            return;
        }
        this.mCurrentDate.setTimeInMillis(calendar.getTimeInMillis());
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        } else if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
        this.updateSpinners();
        this.notifyDateChanged();
    }

    public class OnValueChangeListener
    implements NumberPicker.OnValueChangeListener {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onValueChange(NumberPicker numberPicker, int n, int n2) {
            DateTimePicker.this.updateInputState();
            DateTimePicker.this.mTempDate.setTimeInMillis(DateTimePicker.this.mCurrentDate.getTimeInMillis());
            boolean bl = AppConstants.Versions.feature11Plus;
            if (bl) {
                Log.d((String)DateTimePicker.LOGTAG, (String)"SDK version > 10, using new behavior");
                if (numberPicker == DateTimePicker.this.mDaySpinner && DateTimePicker.this.mDayEnabled) {
                    int n3 = DateTimePicker.this.mTempDate.getActualMaximum(5);
                    int n4 = DateTimePicker.this.mTempDate.get(5);
                    this.setTempDate(5, n4, n2, 1, n3);
                } else if (numberPicker == DateTimePicker.this.mMonthSpinner && DateTimePicker.this.mMonthEnabled) {
                    int n5 = DateTimePicker.this.mTempDate.get(2);
                    this.setTempDate(2, n5, n2, 0, 11);
                } else if (numberPicker == DateTimePicker.this.mWeekSpinner) {
                    int n6 = DateTimePicker.this.mTempDate.get(3);
                    int n7 = DateTimePicker.this.mTempDate.getActualMaximum(3);
                    this.setTempDate(3, n6, n2, 0, n7);
                } else if (numberPicker == DateTimePicker.this.mYearSpinner && DateTimePicker.this.mYearEnabled) {
                    int n8 = DateTimePicker.this.mTempDate.get(2);
                    DateTimePicker.this.mTempDate.set(1, n2);
                    if (n8 != DateTimePicker.this.mTempDate.get(2)) {
                        DateTimePicker.this.mTempDate.set(2, n8);
                        DateTimePicker.this.mTempDate.set(5, DateTimePicker.this.mTempDate.getActualMaximum(5));
                    }
                } else if (numberPicker == DateTimePicker.this.mHourSpinner && DateTimePicker.this.mHourEnabled) {
                    if (DateTimePicker.this.mIs12HourMode) {
                        this.setTempDate(10, n, n2, 1, 12);
                    } else {
                        this.setTempDate(11, n, n2, 0, 23);
                    }
                } else if (numberPicker == DateTimePicker.this.mMinuteSpinner && DateTimePicker.this.mMinuteEnabled) {
                    this.setTempDate(12, n, n2, 0, 59);
                } else {
                    if (numberPicker != DateTimePicker.this.mAMPMSpinner || !DateTimePicker.this.mHourEnabled) throw new IllegalArgumentException();
                    DateTimePicker.this.mTempDate.set(9, n2);
                }
            } else {
                Log.d((String)DateTimePicker.LOGTAG, (String)"Sdk version < 10, using old behavior");
                if (numberPicker == DateTimePicker.this.mDaySpinner && DateTimePicker.this.mDayEnabled) {
                    DateTimePicker.this.mTempDate.set(5, n2);
                } else if (numberPicker == DateTimePicker.this.mMonthSpinner && DateTimePicker.this.mMonthEnabled) {
                    DateTimePicker.this.mTempDate.set(2, n2);
                    if (DateTimePicker.this.mTempDate.get(2) == n2 + 1) {
                        DateTimePicker.this.mTempDate.set(2, n2);
                        DateTimePicker.this.mTempDate.set(5, DateTimePicker.this.mTempDate.getActualMaximum(5));
                    }
                } else if (numberPicker == DateTimePicker.this.mWeekSpinner) {
                    DateTimePicker.this.mTempDate.set(3, n2);
                } else if (numberPicker == DateTimePicker.this.mYearSpinner && DateTimePicker.this.mYearEnabled) {
                    int n9 = DateTimePicker.this.mTempDate.get(2);
                    DateTimePicker.this.mTempDate.set(1, n2);
                    if (n9 != DateTimePicker.this.mTempDate.get(2)) {
                        DateTimePicker.this.mTempDate.set(2, n9);
                        DateTimePicker.this.mTempDate.set(5, DateTimePicker.this.mTempDate.getActualMaximum(5));
                    }
                } else if (numberPicker == DateTimePicker.this.mHourSpinner && DateTimePicker.this.mHourEnabled) {
                    if (DateTimePicker.this.mIs12HourMode) {
                        DateTimePicker.this.mTempDate.set(10, n2);
                    } else {
                        DateTimePicker.this.mTempDate.set(11, n2);
                    }
                } else if (numberPicker == DateTimePicker.this.mMinuteSpinner && DateTimePicker.this.mMinuteEnabled) {
                    DateTimePicker.this.mTempDate.set(12, n2);
                } else {
                    if (numberPicker != DateTimePicker.this.mAMPMSpinner || !DateTimePicker.this.mHourEnabled) throw new IllegalArgumentException();
                    DateTimePicker.this.mTempDate.set(9, n2);
                }
            }
            DateTimePicker.this.setDate(DateTimePicker.this.mTempDate);
            if (DateTimePicker.this.mDayEnabled) {
                DateTimePicker.this.mDaySpinner.setMaxValue(DateTimePicker.this.mCurrentDate.getActualMaximum(5));
            }
            if (DateTimePicker.this.mWeekEnabled) {
                DateTimePicker.this.mWeekSpinner.setMaxValue(DateTimePicker.this.mCurrentDate.getActualMaximum(3));
            }
            DateTimePicker.this.updateCalendar();
            DateTimePicker.this.updateSpinners();
            DateTimePicker.this.notifyDateChanged();
        }

        private void setTempDate(int n, int n2, int n3, int n4, int n5) {
            if (n2 == n5 && n3 == n4) {
                DateTimePicker.this.mTempDate.add(n, 1);
            } else if (n2 == n4 && n3 == n5) {
                DateTimePicker.this.mTempDate.add(n, -1);
            } else {
                DateTimePicker.this.mTempDate.add(n, n3 - n2);
            }
        }
    }

    public static enum PickersState {
        DATE,
        MONTH,
        WEEK,
        TIME,
        DATETIME;

    }
}

