/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import org.mozilla.gecko.SysInfo;

public final class HardwareUtils {
    private static final String LOGTAG = "GeckoHardwareUtils";
    private static final int LOW_MEMORY_THRESHOLD_MB = 384;
    private static final boolean IS_AMAZON_DEVICE = Build.MANUFACTURER.equalsIgnoreCase("Amazon");
    public static final boolean IS_KINDLE_DEVICE = IS_AMAZON_DEVICE && (Build.MODEL.equals("Kindle Fire") || Build.MODEL.startsWith("KF"));
    private static volatile boolean sInited;
    private static volatile boolean sIsLargeTablet;
    private static volatile boolean sIsSmallTablet;
    private static volatile boolean sIsTelevision;

    private HardwareUtils() {
    }

    public static void init(Context context) {
        if (sInited) {
            Log.d((String)LOGTAG, (String)"HardwareUtils already inited.");
            return;
        }
        int n = context.getResources().getConfiguration().screenLayout & 0xF;
        if (Build.VERSION.SDK_INT >= 11) {
            if (n == 4) {
                sIsLargeTablet = true;
            } else if (n == 3) {
                sIsSmallTablet = true;
            }
            if (Build.VERSION.SDK_INT >= 16 && context.getPackageManager().hasSystemFeature("android.hardware.type.television")) {
                sIsTelevision = true;
            }
        }
        sInited = true;
    }

    public static boolean isTablet() {
        return sIsLargeTablet || sIsSmallTablet;
    }

    public static boolean isLargeTablet() {
        return sIsLargeTablet;
    }

    public static boolean isSmallTablet() {
        return sIsSmallTablet;
    }

    public static boolean isTelevision() {
        return sIsTelevision;
    }

    public static int getMemSize() {
        return SysInfo.getMemSize();
    }

    public static boolean isLowMemoryPlatform() {
        int n = HardwareUtils.getMemSize();
        if (n == 0) {
            Log.w((String)LOGTAG, (String)"Could not compute system memory. Falling back to isLowMemoryPlatform = false.");
            return false;
        }
        return n < 384;
    }
}

