/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.preferences;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.support.v4.app.Fragment;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.preferences.PreferenceManagerCompat;
import org.mozilla.gecko.util.WeakReferenceHandler;

public abstract class PreferenceFragment
extends Fragment
implements PreferenceManagerCompat.OnPreferenceTreeClickListener {
    private static final String PREFERENCES_TAG = "android:preferences";
    private PreferenceManager mPreferenceManager;
    private ListView mList;
    private boolean mHavePrefs;
    private boolean mInitDone;
    private static final int FIRST_REQUEST_CODE = 100;
    private static final int MSG_BIND_PREFERENCES = 1;
    private final Handler mHandler = new PreferenceFragmentHandler(this);
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            PreferenceFragment.this.mList.focusableViewAvailable((View)PreferenceFragment.this.mList);
        }
    };
    private final View.OnKeyListener mListOnKeyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int n, KeyEvent keyEvent) {
            Object object = PreferenceFragment.this.mList.getSelectedItem();
            if (object instanceof Preference) {
                View view2 = PreferenceFragment.this.mList.getSelectedView();
                return false;
            }
            return false;
        }
    };

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mPreferenceManager = PreferenceManagerCompat.newInstance((Activity)this.getActivity(), 100);
        PreferenceManagerCompat.setFragment(this.mPreferenceManager, this);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.fxaccount_preference_list_fragment, viewGroup, false);
    }

    public void onActivityCreated(Bundle bundle) {
        PreferenceScreen preferenceScreen;
        Bundle bundle2;
        super.onActivityCreated(bundle);
        if (this.mHavePrefs) {
            this.bindPreferences();
        }
        this.mInitDone = true;
        if (bundle != null && (bundle2 = bundle.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(bundle2);
        }
    }

    public void onStart() {
        super.onStart();
        PreferenceManagerCompat.setOnPreferenceTreeClickListener(this.mPreferenceManager, this);
    }

    public void onStop() {
        super.onStop();
        PreferenceManagerCompat.dispatchActivityStop(this.mPreferenceManager);
        PreferenceManagerCompat.setOnPreferenceTreeClickListener(this.mPreferenceManager, null);
    }

    public void onDestroyView() {
        this.mList = null;
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mHandler.removeMessages(1);
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        PreferenceManagerCompat.dispatchActivityDestroy(this.mPreferenceManager);
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            Bundle bundle2 = new Bundle();
            preferenceScreen.saveHierarchyState(bundle2);
            bundle.putBundle(PREFERENCES_TAG, bundle2);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        PreferenceManagerCompat.dispatchActivityResult(this.mPreferenceManager, n, n2, intent);
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        if (PreferenceManagerCompat.setPreferences(this.mPreferenceManager, preferenceScreen) && preferenceScreen != null) {
            this.mHavePrefs = true;
            if (this.mInitDone) {
                this.postBindPreferences();
            }
        }
    }

    public PreferenceScreen getPreferenceScreen() {
        return PreferenceManagerCompat.getPreferenceScreen(this.mPreferenceManager);
    }

    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(PreferenceManagerCompat.inflateFromIntent(this.mPreferenceManager, intent, this.getPreferenceScreen()));
    }

    public void addPreferencesFromResource(int n) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(PreferenceManagerCompat.inflateFromResource(this.mPreferenceManager, (Activity)this.getActivity(), n, this.getPreferenceScreen()));
    }

    @Override
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (this.getActivity() instanceof OnPreferenceStartFragmentCallback) {
            return ((OnPreferenceStartFragmentCallback)this.getActivity()).onPreferenceStartFragment(this, preference);
        }
        return false;
    }

    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(charSequence);
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            throw new RuntimeException("This should be called after super.onCreate.");
        }
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.bind(this.getListView());
        }
    }

    public ListView getListView() {
        this.ensureList();
        return this.mList;
    }

    private void ensureList() {
        if (this.mList != null) {
            return;
        }
        View view = this.getView();
        if (view == null) {
            throw new IllegalStateException("Content view not yet created");
        }
        View view2 = view.findViewById(16908298);
        if (!(view2 instanceof ListView)) {
            throw new RuntimeException("Content has view with id attribute 'android.R.id.list' that is not a ListView class");
        }
        this.mList = (ListView)view2;
        if (this.mList == null) {
            throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
        }
        this.mList.setOnKeyListener(this.mListOnKeyListener);
        this.mHandler.post(this.mRequestFocus);
    }

    public static interface OnPreferenceStartFragmentCallback {
        public boolean onPreferenceStartFragment(PreferenceFragment var1, Preference var2);
    }

    private static class PreferenceFragmentHandler
    extends WeakReferenceHandler<PreferenceFragment> {
        public PreferenceFragmentHandler(PreferenceFragment preferenceFragment) {
            super((Object)preferenceFragment);
        }

        public void handleMessage(Message message) {
            PreferenceFragment preferenceFragment = (PreferenceFragment)this.mTarget.get();
            if (preferenceFragment == null) {
                return;
            }
            switch (message.what) {
                case 1: {
                    preferenceFragment.bindPreferences();
                }
            }
        }
    }
}

