/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.mozilla.apache.commons.codec.binary.Base32;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.nativecode.NativeCrypto;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class Utils {
    private static final String LOG_TAG = "Utils";
    private static final SecureRandom sharedSecureRandom = new SecureRandom();
    public static final int SHARED_PREFERENCES_MODE = 0;

    public static String generateGuid() {
        byte[] byArray = Base64.encodeBase64((byte[])Utils.generateRandomBytes(9), (boolean)false);
        return new String(byArray).replace("+", "-").replace("/", "_");
    }

    public static byte[] generateRandomBytes(int n) {
        byte[] byArray = new byte[n];
        sharedSecureRandom.nextBytes(byArray);
        return byArray;
    }

    public static BigInteger generateBigIntegerLessThan(BigInteger bigInteger) {
        int n = (int)Math.ceil((double)bigInteger.bitLength() / 8.0);
        BigInteger bigInteger2 = new BigInteger(Utils.generateRandomBytes(n));
        return bigInteger2.mod(bigInteger);
    }

    public static String byte2Hex(byte[] byArray) {
        return Utils.byte2Hex(byArray, 2 * byArray.length);
    }

    public static String byte2Hex(byte[] byArray, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(Math.max(2 * byArray.length, n));
        for (n2 = 0; n2 < n - 2 * byArray.length; ++n2) {
            stringBuilder.append("0");
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            String string = Integer.toHexString(byArray[n2] & 0xFF);
            if (string.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] concatAll(byte[] byArray, byte[] ... byArray2) {
        int n = byArray.length;
        for (byte[] byArray3 : byArray2) {
            n += byArray3.length;
        }
        byte[] byArray4 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        for (byte[] byArray5 : byArray2) {
            System.arraycopy(byArray5, 0, byArray4, n2, byArray5.length);
            n2 += byArray5.length;
        }
        return byArray4;
    }

    public static byte[] decodeBase64(String string) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])string.getBytes("UTF-8"));
    }

    public static byte[] decodeFriendlyBase32(String string) {
        Base32 base32 = new Base32();
        String string2 = string.replace('8', 'l').replace('9', 'o');
        return base32.decode(string2.toUpperCase(Locale.US));
    }

    public static byte[] hex2Byte(String string, int n) {
        byte[] byArray = Utils.hex2Byte(string);
        if (byArray.length >= n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n - byArray.length];
        return Utils.concatAll(byArray2, new byte[][]{byArray});
    }

    public static byte[] hex2Byte(String string) {
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    public static String millisecondsToDecimalSecondsString(long l) {
        return Utils.millisecondsToDecimalSeconds(l).toString();
    }

    public static BigDecimal millisecondsToDecimalSeconds(long l) {
        return new BigDecimal(l).movePointLeft(3);
    }

    public static long decimalSecondsToMilliseconds(String string) {
        try {
            return new BigDecimal(string).movePointRight(3).longValue();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long decimalSecondsToMilliseconds(Double d) {
        return (long)(d * 1000.0);
    }

    public static long decimalSecondsToMilliseconds(Long l) {
        return l * 1000L;
    }

    public static long decimalSecondsToMilliseconds(Integer n) {
        return n * 1000;
    }

    public static byte[] sha256(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        return messageDigest.digest(byArray);
    }

    protected static byte[] sha1(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray = string.getBytes("UTF-8");
        try {
            return NativeCrypto.sha1(byArray);
        }
        catch (LinkageError linkageError) {
            Logger.warn(LOG_TAG, "Got throwable stretching password using native sha1 implementation; ignoring and using Java implementation.", linkageError);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(string.getBytes("UTF-8"));
        }
    }

    protected static String sha1Base32(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return new Base32().encodeAsString(Utils.sha1(string)).toLowerCase(Locale.US);
    }

    public static String usernameFromAccount(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("No account name provided.");
        }
        if (string.matches("^[A-Za-z0-9._-]+$")) {
            return string.toLowerCase(Locale.US);
        }
        return Utils.sha1Base32(string.toLowerCase(Locale.US));
    }

    public static SharedPreferences getSharedPreferences(Context context, String string, String string2, String string3, String string4, long l) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String string5 = Utils.getPrefsPath(string, string2, string3, string4, l);
        return context.getSharedPreferences(string5, 0);
    }

    public static String getPrefsPath(String string, String string2, String string3, String string4, long l) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String string5 = Utils.sha1Base32(string3 + ":" + Utils.usernameFromAccount(string2));
        if (l <= 0L) {
            return "sync.prefs." + string5;
        }
        String string6 = string.replace('.', '!').replace(' ', '!');
        return "sync.prefs." + string6 + "." + string5 + "." + string4 + "." + l;
    }

    public static void addToIndexBucketMap(TreeMap<Long, ArrayList<String>> treeMap, long l, String string) {
        ArrayList<String> arrayList = treeMap.get(l);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(string);
        treeMap.put(l, arrayList);
    }

    private static boolean same(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean sameArrays(JSONArray jSONArray, JSONArray jSONArray2) {
        if (jSONArray == jSONArray2) {
            return true;
        }
        if (jSONArray == null || jSONArray2 == null) {
            return false;
        }
        int n = jSONArray.size();
        if (n != jSONArray2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Utils.same(jSONArray.get(i), jSONArray2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> extractURIComponents(String string, String string2) {
        if (string2.indexOf(string) != 0) {
            throw new IllegalArgumentException("URI scheme does not match: " + string);
        }
        String string3 = string2.substring(string.length());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string3.split("&");
        block5: for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() == 0) continue;
            String[] stringArray2 = string4.split("=", 2);
            switch (stringArray2.length) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    hashMap.put(URLDecoder.decode(stringArray2[0]), null);
                    continue block5;
                }
                case 2: {
                    hashMap.put(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
                }
            }
        }
        return hashMap;
    }

    public static String toDelimitedString(String string, Collection<? extends Object> collection) {
        if (collection == null || collection.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = collection.size();
        for (Object object : collection) {
            stringBuilder.append(object.toString());
            if (++n >= n2) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toCommaSeparatedString(Collection<? extends Object> collection) {
        return Utils.toDelimitedString(", ", collection);
    }

    public static Collection<String> getStagesToSync(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        collection3 = collection3 == null ? new HashSet<String>() : new HashSet<String>(collection3);
        collection2 = collection2 == null ? new HashSet<String>(collection) : new HashSet<String>(collection2);
        collection2.retainAll(collection);
        collection2.removeAll(collection3);
        return collection2;
    }

    public static Collection<String> getStagesToSyncFromBundle(Collection<String> collection, Bundle bundle) {
        if (bundle == null) {
            return collection;
        }
        String string = bundle.getString("sync");
        String string2 = bundle.getString("skip");
        if (string == null && string2 == null) {
            return collection;
        }
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        if (string != null) {
            try {
                arrayList = new ArrayList<String>(new ExtendedJSONObject(string).keySet());
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception parsing stages to sync: '" + string + "'.", exception);
            }
        }
        if (string2 != null) {
            try {
                arrayList2 = new ArrayList<String>(new ExtendedJSONObject(string2).keySet());
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception parsing stages to skip: '" + string2 + "'.", exception);
            }
        }
        Logger.info(LOG_TAG, "Asked to sync '" + Utils.toCommaSeparatedString(arrayList) + "' and to skip '" + Utils.toCommaSeparatedString(arrayList2) + "'.");
        return Utils.getStagesToSync(collection, arrayList, arrayList2);
    }

    public static void putStageNamesToSync(Bundle bundle, String[] stringArray, String[] stringArray2) {
        ExtendedJSONObject extendedJSONObject;
        if (bundle == null) {
            return;
        }
        if (stringArray != null) {
            extendedJSONObject = new ExtendedJSONObject();
            for (String string : stringArray) {
                extendedJSONObject.put(string, 0);
            }
            bundle.putString("sync", extendedJSONObject.toJSONString());
        }
        if (stringArray2 != null) {
            extendedJSONObject = new ExtendedJSONObject();
            for (String string : stringArray2) {
                extendedJSONObject.put(string, 0);
            }
            bundle.putString("skip", extendedJSONObject.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(Context context, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Passed null filename in readFile.");
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileInputStream = context.openFileInput(string);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        catch (Exception exception) {
            String string4 = null;
            return string4;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String formatDuration(long l, long l2) {
        long l3 = l2 - l;
        return new DecimalFormat("#0.00 seconds").format((double)l3 / 1000.0);
    }

    public static String decodeUTF8(String string) throws UnsupportedEncodingException {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.codePointAt(i);
        }
        return new String(byArray, "UTF-8");
    }

    public static String obfuscateEmail(String string) {
        return string.replaceAll("[^@\\.]", "X");
    }

    public static void throwIfNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new IllegalArgumentException("object must not be null");
        }
    }

    public static String getLanguageTag(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("iw")) {
            string = "he";
        } else if (string.equals("in")) {
            string = "id";
        } else if (string.equals("ji")) {
            string = "yi";
        }
        String string2 = locale.getCountry();
        if (string2.equals("")) {
            return string;
        }
        return string + "-" + string2;
    }
}

