/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.cookie;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.cookie.Cookie;
import ch.boye.httpclientandroidlib.cookie.CookieAttributeHandler;
import ch.boye.httpclientandroidlib.cookie.CookieOrigin;
import ch.boye.httpclientandroidlib.cookie.CookieRestrictionViolationException;
import ch.boye.httpclientandroidlib.cookie.MalformedCookieException;
import ch.boye.httpclientandroidlib.cookie.SetCookie;
import ch.boye.httpclientandroidlib.util.Args;

@Immutable
public class BasicDomainHandler
implements CookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (string.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        setCookie.setDomain(string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (string.contains(".")) {
            if (!string.endsWith(string2)) {
                if (string2.startsWith(".")) {
                    string2 = string2.substring(1, string2.length());
                }
                if (!string.equals(string2)) {
                    throw new CookieRestrictionViolationException("Illegal domain attribute \"" + string2 + "\". Domain of origin: \"" + string + "\"");
                }
            }
        } else if (!string.equals(string2)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + string2 + "\". Domain of origin: \"" + string + "\"");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        if (!string2.startsWith(".")) {
            string2 = '.' + string2;
        }
        return string.endsWith(string2) || string.equals(string2.substring(1));
    }
}

