/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.JSONUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.WebActivityMapper;
import org.mozilla.gecko.widget.ExternalIntentDuringPrivateBrowsingPromptFragment;

public final class IntentHelper
implements GeckoEventListener,
NativeEventListener {
    private static final String LOGTAG = "GeckoIntentHelper";
    private static final String[] EVENTS = new String[]{"Intent:GetHandlers", "Intent:Open", "Intent:OpenForResult", "WebActivity:Open"};
    private static final String[] NATIVE_EVENTS = new String[]{"Intent:OpenNoHandler"};
    private static String MARKET_INTENT_URI_PACKAGE_PREFIX = "market://details?id=";
    private static String EXTRA_BROWSER_FALLBACK_URL = "browser_fallback_url";
    private static String UNKNOWN_PROTOCOL_URI_PREFIX = "about:neterror?e=unknownProtocolFound&u=";
    private static IntentHelper instance;
    private final FragmentActivity activity;

    private IntentHelper(FragmentActivity fragmentActivity) {
        this.activity = fragmentActivity;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, EVENTS);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, NATIVE_EVENTS);
    }

    public static IntentHelper init(FragmentActivity fragmentActivity) {
        if (instance == null) {
            instance = new IntentHelper(fragmentActivity);
        } else {
            Log.w((String)LOGTAG, (String)"IntentHelper.init() called twice, ignoring.");
        }
        return instance;
    }

    public static void destroy() {
        if (instance != null) {
            EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, EVENTS);
            EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, NATIVE_EVENTS);
            instance = null;
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if (string2.equals("Intent:OpenNoHandler")) {
            this.openNoHandler(nativeJSObject, eventCallback);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Intent:GetHandlers")) {
                this.getHandlers(jSONObject);
            } else if (string2.equals("Intent:Open")) {
                this.open(jSONObject);
            } else if (string2.equals("Intent:OpenForResult")) {
                this.openForResult(jSONObject);
            } else if (string2.equals("WebActivity:Open")) {
                this.openWebActivity(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)jSONException);
        }
    }

    private void getHandlers(JSONObject jSONObject) throws JSONException {
        Intent intent = GeckoAppShell.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        List<String> list = Arrays.asList(GeckoAppShell.getHandlersForIntent(intent));
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("apps", (Object)new JSONArray(list));
        EventDispatcher.sendResponse(jSONObject, jSONObject2);
    }

    private void open(JSONObject jSONObject) throws JSONException {
        GeckoAppShell.openUriExternal(jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("packageName"), jSONObject.optString("className"), jSONObject.optString("action"), jSONObject.optString("title"), false);
    }

    private void openForResult(JSONObject jSONObject) throws JSONException {
        Intent intent = GeckoAppShell.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        intent.setClassName(jSONObject.optString("packageName"), jSONObject.optString("className"));
        intent.setFlags(0x4000000);
        ResultHandler resultHandler = new ResultHandler(jSONObject);
        try {
            ActivityHandlerHelper.startIntentForActivity((Activity)this.activity, intent, resultHandler);
        }
        catch (SecurityException securityException) {
            Log.w((String)LOGTAG, (String)"Forbidden to launch activity.", (Throwable)securityException);
        }
    }

    private void openNoHandler(NativeJSObject nativeJSObject, EventCallback eventCallback) {
        Intent intent;
        String string2 = nativeJSObject.getString("uri");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.w((String)LOGTAG, (String)"Received empty URL - loading about:neterror");
            eventCallback.sendError((Object)this.getUnknownProtocolErrorPageUri(""));
            return;
        }
        try {
            intent = Intent.parseUri((String)string2, (int)0);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string3;
            try {
                string3 = this.getUnknownProtocolErrorPageUri(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = this.getUnknownProtocolErrorPageUri("");
            }
            Log.w((String)LOGTAG, (String)"Unable to parse Intent URI - loading about:neterror");
            eventCallback.sendError((Object)string3);
            return;
        }
        String string4 = intent.getStringExtra(EXTRA_BROWSER_FALLBACK_URL);
        if (IntentHelper.isFallbackUrlValid(string4)) {
            eventCallback.sendError((Object)string4);
        } else if (intent.getPackage() != null) {
            String string5 = MARKET_INTENT_URI_PACKAGE_PREFIX + intent.getPackage();
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)string5));
            intent2.addCategory("android.intent.category.BROWSABLE");
            intent2.addFlags(0x10000000);
            ExternalIntentDuringPrivateBrowsingPromptFragment.showDialogOrAndroidChooser((Context)this.activity, this.activity.getSupportFragmentManager(), intent2);
            eventCallback.sendSuccess(null);
        } else {
            Log.w((String)LOGTAG, (String)"Unable to open URI, default case - loading about:neterror");
            eventCallback.sendError((Object)this.getUnknownProtocolErrorPageUri(intent.getData().toString()));
        }
    }

    private static boolean isFallbackUrlValid(@Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        try {
            String string3;
            String string4 = new URI(string2).getScheme();
            String string5 = string3 = string4 == null ? null : string4.toLowerCase(Locale.US);
            if ("http".equals(string3) || "https".equals(string3)) {
                return true;
            }
            Log.w((String)LOGTAG, (String)("Fallback URI uses unsupported scheme: " + string3 + ". Try http or https."));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.w((String)LOGTAG, (String)"URISyntaxException parsing fallback URI");
        }
        return false;
    }

    private String getUnknownProtocolErrorPageUri(String string2) {
        return UNKNOWN_PROTOCOL_URI_PREFIX + string2;
    }

    private void openWebActivity(JSONObject jSONObject) throws JSONException {
        Intent intent = WebActivityMapper.getIntentForWebActivity((JSONObject)jSONObject.getJSONObject("activity"));
        ActivityHandlerHelper.startIntentForActivity((Activity)this.activity, intent, new ResultHandler(jSONObject));
    }

    private static class ResultHandler
    implements ActivityResultHandler {
        private final JSONObject message;

        public ResultHandler(JSONObject jSONObject) {
            this.message = jSONObject;
        }

        public void onActivityResult(int n, Intent intent) {
            JSONObject jSONObject = new JSONObject();
            try {
                if (intent != null) {
                    jSONObject.put("extras", (Object)JSONUtils.bundleToJSON((Bundle)intent.getExtras()));
                    jSONObject.put("uri", (Object)intent.getData().toString());
                }
                jSONObject.put("resultCode", n);
            }
            catch (JSONException jSONException) {
                Log.w((String)IntentHelper.LOGTAG, (String)"Error building JSON response.", (Throwable)jSONException);
            }
            EventDispatcher.sendResponse(this.message, jSONObject);
        }
    }
}

