/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import com.google.android.gms.cast.CastMediaControlIntent;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.ChromeCast;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoMediaPlayer;
import org.mozilla.gecko.PresentationMediaPlayerManager;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.annotation.ReflectionTarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class MediaPlayerManager
extends Fragment
implements NativeEventListener {
    private static final String LOGTAG = "GeckoMediaPlayerManager";
    @ReflectionTarget
    public static final String MEDIA_PLAYER_TAG = "MPManagerFragment";
    private static final boolean SHOW_DEBUG = false;
    protected MediaRouter mediaRouter = null;
    protected final Map<String, GeckoMediaPlayer> displays = new HashMap<String, GeckoMediaPlayer>();
    private final MediaRouter.Callback callback = new MediaRouter.Callback(){

        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteRemoved: route=" + routeInfo);
            MediaPlayerManager.this.displays.remove(routeInfo.getId());
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("MediaPlayer:Removed", routeInfo.getId()));
            MediaPlayerManager.this.updatePresentation();
        }

        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.this.updatePresentation();
        }

        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.this.updatePresentation();
        }

        public void onRoutePresentationDisplayChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.this.updatePresentation();
        }

        public void onRouteVolumeChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        }

        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteAdded: route=" + routeInfo);
            GeckoMediaPlayer geckoMediaPlayer = MediaPlayerManager.this.getMediaPlayerForRoute(routeInfo);
            this.saveAndNotifyOfDisplay("MediaPlayer:Added", routeInfo, geckoMediaPlayer);
            MediaPlayerManager.this.updatePresentation();
        }

        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteChanged: route=" + routeInfo);
            GeckoMediaPlayer geckoMediaPlayer = MediaPlayerManager.this.displays.get(routeInfo.getId());
            this.saveAndNotifyOfDisplay("MediaPlayer:Changed", routeInfo, geckoMediaPlayer);
            MediaPlayerManager.this.updatePresentation();
        }

        private void saveAndNotifyOfDisplay(String string2, MediaRouter.RouteInfo routeInfo, GeckoMediaPlayer geckoMediaPlayer) {
            if (geckoMediaPlayer == null) {
                return;
            }
            JSONObject jSONObject = geckoMediaPlayer.toJSON();
            if (jSONObject == null) {
                return;
            }
            MediaPlayerManager.this.displays.put(routeInfo.getId(), geckoMediaPlayer);
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent(string2, jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
    };

    @ReflectionTarget
    public static MediaPlayerManager newInstance() {
        if (AppConstants.Versions.feature17Plus) {
            return new PresentationMediaPlayerManager();
        }
        return new MediaPlayerManager();
    }

    private static void debug(String string2, Exception exception) {
    }

    private static void debug(String string2) {
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "MediaPlayer:Load", "MediaPlayer:Start", "MediaPlayer:Stop", "MediaPlayer:Play", "MediaPlayer:Pause", "MediaPlayer:End", "MediaPlayer:Mirror", "MediaPlayer:Message");
    }

    @JNITarget
    public void onDestroy() {
        super.onDestroy();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "MediaPlayer:Load", "MediaPlayer:Start", "MediaPlayer:Stop", "MediaPlayer:Play", "MediaPlayer:Pause", "MediaPlayer:End", "MediaPlayer:Mirror", "MediaPlayer:Message");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        MediaPlayerManager.debug(string2);
        GeckoMediaPlayer geckoMediaPlayer = this.displays.get(nativeJSObject.getString("id"));
        if (geckoMediaPlayer == null) {
            Log.e((String)LOGTAG, (String)("Couldn't find a display for this id: " + nativeJSObject.getString("id") + " for message: " + string2));
            if (eventCallback != null) {
                eventCallback.sendError(null);
            }
            return;
        }
        if ("MediaPlayer:Play".equals(string2)) {
            geckoMediaPlayer.play(eventCallback);
        } else if ("MediaPlayer:Start".equals(string2)) {
            geckoMediaPlayer.start(eventCallback);
        } else if ("MediaPlayer:Stop".equals(string2)) {
            geckoMediaPlayer.stop(eventCallback);
        } else if ("MediaPlayer:Pause".equals(string2)) {
            geckoMediaPlayer.pause(eventCallback);
        } else if ("MediaPlayer:End".equals(string2)) {
            geckoMediaPlayer.end(eventCallback);
        } else if ("MediaPlayer:Mirror".equals(string2)) {
            geckoMediaPlayer.mirror(eventCallback);
        } else if ("MediaPlayer:Message".equals(string2) && nativeJSObject.has("data")) {
            geckoMediaPlayer.message(nativeJSObject.getString("data"), eventCallback);
        } else if ("MediaPlayer:Load".equals(string2)) {
            String string3 = nativeJSObject.optString("source", "");
            String string4 = nativeJSObject.optString("type", "video/mp4");
            String string5 = nativeJSObject.optString("title", "");
            geckoMediaPlayer.load(string5, string3, string4, eventCallback);
        }
    }

    private GeckoMediaPlayer getMediaPlayerForRoute(MediaRouter.RouteInfo routeInfo) {
        try {
            if (routeInfo.supportsControlCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                return new ChromeCast((Context)this.getActivity(), routeInfo);
            }
        }
        catch (Exception exception) {
            MediaPlayerManager.debug("Error handling presentation", exception);
        }
        return null;
    }

    public void onPause() {
        super.onPause();
        this.mediaRouter.removeCallback(this.callback);
        this.mediaRouter = null;
    }

    public void onResume() {
        super.onResume();
        if (this.mediaRouter != null) {
            return;
        }
        this.mediaRouter = MediaRouter.getInstance((Context)this.getActivity());
        MediaRouteSelector mediaRouteSelector = new MediaRouteSelector.Builder().addControlCategory("android.media.intent.category.LIVE_VIDEO").addControlCategory("android.media.intent.category.REMOTE_PLAYBACK").addControlCategory(CastMediaControlIntent.categoryForCast((String)"08FF1091")).build();
        this.mediaRouter.addCallback(mediaRouteSelector, this.callback, 4);
    }

    protected void updatePresentation() {
    }
}

