/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.gecko.background.nativecode.NativeCrypto;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.IOUtils;

public abstract class BaseAction {
    private static final String LOGTAG = "GeckoDLCBaseAction";

    public abstract void perform(Context var1, DownloadContentCatalog var2);

    protected File getDestinationFile(Context context, DownloadContent downloadContent) throws UnrecoverableDownloadContentException, RecoverableDownloadContentException {
        if (downloadContent.isFont()) {
            File file = new File(context.getApplicationInfo().dataDir, "fonts");
            if (!file.exists() && !file.mkdirs()) {
                throw new RecoverableDownloadContentException(2, "Destination directory does not exist and cannot be created");
            }
            return new File(file, downloadContent.getFilename());
        }
        throw new UnrecoverableDownloadContentException("Can't determine destination for kind: " + downloadContent.getKind());
    }

    protected boolean verify(File file, String string2) throws RecoverableDownloadContentException, UnrecoverableDownloadContentException {
        boolean bl;
        BufferedInputStream bufferedInputStream;
        block7: {
            int n;
            bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = NativeCrypto.sha256init();
            if (byArray == null) {
                throw new RecoverableDownloadContentException(1, "Could not create SHA-256 context");
            }
            byte[] byArray2 = new byte[4096];
            while ((n = ((InputStream)bufferedInputStream).read(byArray2)) != -1) {
                NativeCrypto.sha256update((byte[])byArray, (byte[])byArray2, (int)n);
            }
            String string3 = Utils.byte2Hex((byte[])NativeCrypto.sha256finalize((byte[])byArray));
            if (string3.equalsIgnoreCase(string2)) break block7;
            Log.w((String)LOGTAG, (String)("Checksums do not match. Expected=" + string2 + ", Actual=" + string3));
            boolean bl2 = false;
            IOUtils.safeStreamClose((Closeable)bufferedInputStream);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (IOException iOException) {
            try {
                throw new RecoverableDownloadContentException(2, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.safeStreamClose(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.safeStreamClose((Closeable)bufferedInputStream);
        return bl;
    }

    static class UnrecoverableDownloadContentException
    extends Exception {
        private static final long serialVersionUID = 8956080754787367105L;

        public UnrecoverableDownloadContentException(String string2) {
            super(string2);
        }

        public UnrecoverableDownloadContentException(Throwable throwable) {
            super(throwable);
        }
    }

    static class RecoverableDownloadContentException
    extends Exception {
        private static final long serialVersionUID = -2246772819507370734L;
        public static final int MEMORY = 1;
        public static final int DISK_IO = 2;
        public static final int SERVER = 3;
        public static final int NETWORK = 4;
        private int errorType;

        public RecoverableDownloadContentException(@ErrorType int n, String string2) {
            super(string2);
            this.errorType = n;
        }

        public RecoverableDownloadContentException(@ErrorType int n, Throwable throwable) {
            super(throwable);
            this.errorType = n;
        }

        @ErrorType
        public int getErrorType() {
            return this.errorType;
        }

        public boolean shouldBeCountedAsFailure() {
            return 4 != this.errorType;
        }

        public static @interface ErrorType {
        }
    }
}

