/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.util.Log;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;

public class StudyAction
extends BaseAction {
    private static final String LOGTAG = "DLCStudyAction";

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Studying catalog..");
        for (DownloadContent downloadContent : downloadContentCatalog.getContentWithoutState()) {
            if (!downloadContent.isAssetArchive() || !downloadContent.isFont()) continue;
            downloadContentCatalog.scheduleDownload(downloadContent);
            Log.d((String)LOGTAG, (String)("Scheduled download: " + downloadContent));
        }
        if (downloadContentCatalog.hasScheduledDownloads()) {
            this.startDownloads(context);
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected void startDownloads(Context context) {
        DownloadContentService.startDownloads(context);
    }
}

