/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc.catalog;

import android.support.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadContent {
    private static final String KEY_ID = "id";
    private static final String KEY_LOCATION = "location";
    private static final String KEY_FILENAME = "filename";
    private static final String KEY_CHECKSUM = "checksum";
    private static final String KEY_DOWNLOAD_CHECKSUM = "download_checksum";
    private static final String KEY_LAST_MODIFIED = "last_modified";
    private static final String KEY_TYPE = "type";
    private static final String KEY_KIND = "kind";
    private static final String KEY_SIZE = "size";
    private static final String KEY_STATE = "state";
    private static final String KEY_FAILURES = "failures";
    private static final String KEY_LAST_FAILURE_TYPE = "last_failure_type";
    public static final int STATE_NONE = 0;
    public static final int STATE_SCHEDULED = 1;
    public static final int STATE_DOWNLOADED = 2;
    public static final int STATE_FAILED = 3;
    public static final int STATE_IGNORED = 4;
    public static final String TYPE_ASSET_ARCHIVE = "asset-archive";
    public static final String KIND_FONT = "font";
    private final String id;
    private final String location;
    private final String filename;
    private final String checksum;
    private final String downloadChecksum;
    private final long lastModified;
    private final String type;
    private final String kind;
    private final long size;
    private int state;
    private int failures;
    private int lastFailureType;

    private DownloadContent(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull String string6, @NonNull long l, @NonNull String string7, @NonNull String string8, long l2) {
        this.id = string2;
        this.location = string3;
        this.filename = string4;
        this.checksum = string5;
        this.downloadChecksum = string6;
        this.lastModified = l;
        this.type = string7;
        this.kind = string8;
        this.size = l2;
        this.state = 0;
    }

    public String getId() {
        return this.id;
    }

    void setState(@State int n) {
        this.state = n;
    }

    @State
    public int getState() {
        return this.state;
    }

    @Kind
    public String getKind() {
        return this.kind;
    }

    @Type
    public String getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getDownloadChecksum() {
        return this.downloadChecksum;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFont() {
        return KIND_FONT.equals(this.kind);
    }

    public boolean isAssetArchive() {
        return TYPE_ASSET_ARCHIVE.equals(this.type);
    }

    int getFailures() {
        return this.failures;
    }

    void rememberFailure(int n) {
        if (this.lastFailureType != n) {
            this.lastFailureType = n;
            this.failures = 1;
        } else {
            ++this.failures;
        }
    }

    void resetFailures() {
        this.failures = 0;
        this.lastFailureType = 0;
    }

    public static DownloadContent fromJSON(JSONObject jSONObject) throws JSONException {
        return new Builder().setId(jSONObject.getString(KEY_ID)).setLocation(jSONObject.getString(KEY_LOCATION)).setFilename(jSONObject.getString(KEY_FILENAME)).setChecksum(jSONObject.getString(KEY_CHECKSUM)).setDownloadChecksum(jSONObject.getString(KEY_DOWNLOAD_CHECKSUM)).setLastModified(jSONObject.getLong(KEY_LAST_MODIFIED)).setType(jSONObject.getString(KEY_TYPE)).setKind(jSONObject.getString(KEY_KIND)).setSize(jSONObject.getLong(KEY_SIZE)).setState(jSONObject.getInt(KEY_STATE)).setFailures(jSONObject.optInt(KEY_FAILURES), jSONObject.optInt(KEY_LAST_FAILURE_TYPE)).build();
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, (Object)this.id);
        jSONObject.put(KEY_LOCATION, (Object)this.location);
        jSONObject.put(KEY_FILENAME, (Object)this.filename);
        jSONObject.put(KEY_CHECKSUM, (Object)this.checksum);
        jSONObject.put(KEY_DOWNLOAD_CHECKSUM, (Object)this.downloadChecksum);
        jSONObject.put(KEY_LAST_MODIFIED, this.lastModified);
        jSONObject.put(KEY_TYPE, (Object)this.type);
        jSONObject.put(KEY_KIND, (Object)this.kind);
        jSONObject.put(KEY_SIZE, this.size);
        jSONObject.put(KEY_STATE, this.state);
        if (this.failures > 0) {
            jSONObject.put(KEY_FAILURES, this.failures);
            jSONObject.put(KEY_LAST_FAILURE_TYPE, this.lastFailureType);
        }
        return jSONObject;
    }

    public String toString() {
        return String.format("[%s,%s] %s (%d bytes) %s", this.getType(), this.getKind(), this.getId(), this.getSize(), this.getChecksum());
    }

    public static class Builder {
        private String id;
        private String location;
        private String filename;
        private String checksum;
        private String downloadChecksum;
        private long lastModified;
        private String type;
        private String kind;
        private long size;
        private int state;
        private int failures;
        private int lastFailureType;

        public DownloadContent build() {
            DownloadContent downloadContent = new DownloadContent(this.id, this.location, this.filename, this.checksum, this.downloadChecksum, this.lastModified, this.type, this.kind, this.size);
            downloadContent.setState(this.state);
            downloadContent.failures = this.failures;
            downloadContent.lastFailureType = this.lastFailureType;
            return downloadContent;
        }

        public Builder setId(String string2) {
            this.id = string2;
            return this;
        }

        public Builder setLocation(String string2) {
            this.location = string2;
            return this;
        }

        public Builder setFilename(String string2) {
            this.filename = string2;
            return this;
        }

        public Builder setChecksum(String string2) {
            this.checksum = string2;
            return this;
        }

        public Builder setDownloadChecksum(String string2) {
            this.downloadChecksum = string2;
            return this;
        }

        public Builder setLastModified(long l) {
            this.lastModified = l;
            return this;
        }

        public Builder setType(String string2) {
            this.type = string2;
            return this;
        }

        public Builder setKind(String string2) {
            this.kind = string2;
            return this;
        }

        public Builder setSize(long l) {
            this.size = l;
            return this;
        }

        public Builder setState(int n) {
            this.state = n;
            return this;
        }

        Builder setFailures(int n, int n2) {
            this.failures = n;
            this.lastFailureType = n2;
            return this;
        }
    }

    public static @interface Kind {
    }

    public static @interface Type {
    }

    public static @interface State {
    }
}

