/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.keepsafe.switchboard.SwitchBoard;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.DataPanel;
import org.mozilla.gecko.firstrun.FirstrunPanel;
import org.mozilla.gecko.firstrun.RestrictedWelcomePanel;
import org.mozilla.gecko.firstrun.SyncPanel;
import org.mozilla.gecko.firstrun.WelcomePanel;

public class FirstrunPagerConfig {
    public static final String LOGTAG = "FirstrunPagerConfig";
    public static final String KEY_IMAGE = "imageRes";
    public static final String KEY_TEXT = "textRes";
    public static final String KEY_SUBTEXT = "subtextRes";

    public static List<FirstrunPanelConfig> getDefault(Context context) {
        LinkedList<FirstrunPanelConfig> linkedList = new LinkedList<FirstrunPanelConfig>();
        if (FirstrunPagerConfig.isInExperimentLocal(context, "onboarding2-a")) {
            linkedList.add(new FirstrunPanelConfig(WelcomePanel.class.getName(), WelcomePanel.TITLE_RES));
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-a");
        } else if (FirstrunPagerConfig.isInExperimentLocal(context, "onboarding2-b")) {
            linkedList.add(SimplePanelConfigs.urlbarPanelConfig);
            linkedList.add(SimplePanelConfigs.bookmarksPanelConfig);
            linkedList.add(SimplePanelConfigs.syncPanelConfig);
            linkedList.add(new FirstrunPanelConfig(SyncPanel.class.getName(), SyncPanel.TITLE_RES));
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-b");
        } else if (FirstrunPagerConfig.isInExperimentLocal(context, "onboarding2-c")) {
            linkedList.add(SimplePanelConfigs.urlbarPanelConfig);
            linkedList.add(SimplePanelConfigs.bookmarksPanelConfig);
            linkedList.add(SimplePanelConfigs.dataPanelConfig);
            linkedList.add(SimplePanelConfigs.syncPanelConfig);
            linkedList.add(new FirstrunPanelConfig(SyncPanel.class.getName(), SyncPanel.TITLE_RES));
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "onboarding2-c");
        } else {
            Log.d((String)LOGTAG, (String)"Not in an experiment!");
            linkedList.add(new FirstrunPanelConfig(WelcomePanel.class.getName(), WelcomePanel.TITLE_RES));
        }
        return linkedList;
    }

    private static boolean isInExperimentLocal(Context context, String string2) {
        if (SwitchBoard.isInBucket((Context)context, (int)0, (int)33)) {
            return "onboarding2-a".equals(string2);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)33, (int)66)) {
            return "onboarding2-b".equals(string2);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)66, (int)100)) {
            return "onboarding2-c".equals(string2);
        }
        return false;
    }

    public static List<FirstrunPanelConfig> getRestricted() {
        LinkedList<FirstrunPanelConfig> linkedList = new LinkedList<FirstrunPanelConfig>();
        linkedList.add(new FirstrunPanelConfig(RestrictedWelcomePanel.class.getName(), RestrictedWelcomePanel.TITLE_RES));
        return linkedList;
    }

    protected static class SimplePanelConfigs {
        public static final FirstrunPanelConfig urlbarPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_panel_title_welcome, R.drawable.firstrun_urlbar, R.string.firstrun_urlbar_message, R.string.firstrun_urlbar_subtext);
        public static final FirstrunPanelConfig bookmarksPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_bookmarks_title, R.drawable.firstrun_bookmarks, R.string.firstrun_bookmarks_message, R.string.firstrun_bookmarks_subtext);
        public static final FirstrunPanelConfig syncPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_sync_title, R.drawable.firstrun_sync, R.string.firstrun_sync_message, R.string.firstrun_sync_subtext);
        public static final FirstrunPanelConfig dataPanelConfig = new FirstrunPanelConfig(DataPanel.class.getName(), R.string.firstrun_data_title, R.drawable.firstrun_data_off, R.string.firstrun_data_message, R.string.firstrun_data_subtext);

        protected SimplePanelConfigs() {
        }
    }

    public static class FirstrunPanelConfig {
        private String classname;
        private int titleRes;
        private Bundle args;

        public FirstrunPanelConfig(String string2, int n) {
            this(string2, n, -1, -1, -1, true);
        }

        public FirstrunPanelConfig(String string2, int n, int n2, int n3, int n4) {
            this(string2, n, n2, n3, n4, false);
        }

        private FirstrunPanelConfig(String string2, int n, int n2, int n3, int n4, boolean bl) {
            this.classname = string2;
            this.titleRes = n;
            if (!bl) {
                this.args = new Bundle();
                this.args.putInt(FirstrunPagerConfig.KEY_IMAGE, n2);
                this.args.putInt(FirstrunPagerConfig.KEY_TEXT, n3);
                this.args.putInt(FirstrunPagerConfig.KEY_SUBTEXT, n4);
            }
        }

        public String getClassname() {
            return this.classname;
        }

        public int getTitleRes() {
            return this.titleRes;
        }

        public Bundle getArgs() {
            return this.args;
        }
    }
}

