/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.util.FloatUtils;

public class ImmutableViewportMetrics {
    public final float pageRectLeft;
    public final float pageRectTop;
    public final float pageRectRight;
    public final float pageRectBottom;
    public final float cssPageRectLeft;
    public final float cssPageRectTop;
    public final float cssPageRectRight;
    public final float cssPageRectBottom;
    public final float viewportRectLeft;
    public final float viewportRectTop;
    public final int viewportRectWidth;
    public final int viewportRectHeight;
    public final float zoomFactor;
    public final boolean isRTL;

    public ImmutableViewportMetrics(DisplayMetrics displayMetrics) {
        this.cssPageRectLeft = 0.0f;
        this.pageRectLeft = 0.0f;
        this.viewportRectLeft = 0.0f;
        this.cssPageRectTop = 0.0f;
        this.pageRectTop = 0.0f;
        this.viewportRectTop = 0.0f;
        this.viewportRectWidth = displayMetrics.widthPixels;
        this.viewportRectHeight = displayMetrics.heightPixels;
        this.pageRectRight = this.cssPageRectRight = (float)displayMetrics.widthPixels;
        this.pageRectBottom = this.cssPageRectBottom = (float)displayMetrics.heightPixels;
        this.zoomFactor = 1.0f;
        this.isRTL = false;
    }

    @WrapForJNI(allowMultithread=true)
    public ImmutableViewportMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n, int n2, float f11) {
        this(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, n, n2, f11, false);
    }

    private ImmutableViewportMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n, int n2, float f11, boolean bl) {
        this.pageRectLeft = f;
        this.pageRectTop = f2;
        this.pageRectRight = f3;
        this.pageRectBottom = f4;
        this.cssPageRectLeft = f5;
        this.cssPageRectTop = f6;
        this.cssPageRectRight = f7;
        this.cssPageRectBottom = f8;
        this.viewportRectLeft = f9;
        this.viewportRectTop = f10;
        this.viewportRectWidth = n;
        this.viewportRectHeight = n2;
        this.zoomFactor = f11;
        this.isRTL = bl;
    }

    public float getWidth() {
        return this.viewportRectWidth;
    }

    public float getHeight() {
        return this.viewportRectHeight;
    }

    public float viewportRectRight() {
        return this.viewportRectLeft + (float)this.viewportRectWidth;
    }

    public float viewportRectBottom() {
        return this.viewportRectTop + (float)this.viewportRectHeight;
    }

    public PointF getOrigin() {
        return new PointF(this.viewportRectLeft, this.viewportRectTop);
    }

    public FloatSize getSize() {
        return new FloatSize(this.viewportRectWidth, this.viewportRectHeight);
    }

    public RectF getViewport() {
        return new RectF(this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight(), this.viewportRectBottom());
    }

    public RectF getCssViewport() {
        return RectUtils.scale(this.getViewport(), 1.0f / this.zoomFactor);
    }

    public RectF getPageRect() {
        return new RectF(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom);
    }

    public float getPageWidth() {
        return this.pageRectRight - this.pageRectLeft;
    }

    public float getPageHeight() {
        return this.pageRectBottom - this.pageRectTop;
    }

    public RectF getCssPageRect() {
        return new RectF(this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom);
    }

    public RectF getOverscroll() {
        return new RectF(Math.max(0.0f, this.pageRectLeft - this.viewportRectLeft), Math.max(0.0f, this.pageRectTop - this.viewportRectTop), Math.max(0.0f, this.viewportRectRight() - this.pageRectRight), Math.max(0.0f, this.viewportRectBottom() - this.pageRectBottom));
    }

    public ImmutableViewportMetrics interpolate(ImmutableViewportMetrics immutableViewportMetrics, float f) {
        return new ImmutableViewportMetrics(FloatUtils.interpolate((float)this.pageRectLeft, (float)immutableViewportMetrics.pageRectLeft, (float)f), FloatUtils.interpolate((float)this.pageRectTop, (float)immutableViewportMetrics.pageRectTop, (float)f), FloatUtils.interpolate((float)this.pageRectRight, (float)immutableViewportMetrics.pageRectRight, (float)f), FloatUtils.interpolate((float)this.pageRectBottom, (float)immutableViewportMetrics.pageRectBottom, (float)f), FloatUtils.interpolate((float)this.cssPageRectLeft, (float)immutableViewportMetrics.cssPageRectLeft, (float)f), FloatUtils.interpolate((float)this.cssPageRectTop, (float)immutableViewportMetrics.cssPageRectTop, (float)f), FloatUtils.interpolate((float)this.cssPageRectRight, (float)immutableViewportMetrics.cssPageRectRight, (float)f), FloatUtils.interpolate((float)this.cssPageRectBottom, (float)immutableViewportMetrics.cssPageRectBottom, (float)f), FloatUtils.interpolate((float)this.viewportRectLeft, (float)immutableViewportMetrics.viewportRectLeft, (float)f), FloatUtils.interpolate((float)this.viewportRectTop, (float)immutableViewportMetrics.viewportRectTop, (float)f), (int)FloatUtils.interpolate((float)this.viewportRectWidth, (float)immutableViewportMetrics.viewportRectWidth, (float)f), (int)FloatUtils.interpolate((float)this.viewportRectHeight, (float)immutableViewportMetrics.viewportRectHeight, (float)f), FloatUtils.interpolate((float)this.zoomFactor, (float)immutableViewportMetrics.zoomFactor, (float)f), (double)f >= 0.5 ? immutableViewportMetrics.isRTL : this.isRTL);
    }

    public ImmutableViewportMetrics setViewportSize(int n, int n2) {
        if (n == this.viewportRectWidth && n2 == this.viewportRectHeight) {
            return this;
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, n, n2, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setViewportOrigin(float f, float f2) {
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, f, f2, this.viewportRectWidth, this.viewportRectHeight, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setZoomFactor(float f) {
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectWidth, this.viewportRectHeight, f, this.isRTL);
    }

    public ImmutableViewportMetrics offsetViewportBy(float f, float f2) {
        return this.setViewportOrigin(this.viewportRectLeft + f, this.viewportRectTop + f2);
    }

    public ImmutableViewportMetrics offsetViewportByAndClamp(float f, float f2) {
        if (this.isRTL) {
            return this.setViewportOrigin(Math.min(this.pageRectRight - this.getWidth(), Math.max(this.viewportRectLeft + f, this.pageRectLeft)), Math.max(this.pageRectTop, Math.min(this.viewportRectTop + f2, this.pageRectBottom - this.getHeight())));
        }
        return this.setViewportOrigin(Math.max(this.pageRectLeft, Math.min(this.viewportRectLeft + f, this.pageRectRight - this.getWidth())), Math.max(this.pageRectTop, Math.min(this.viewportRectTop + f2, this.pageRectBottom - this.getHeight())));
    }

    public ImmutableViewportMetrics setPageRect(RectF rectF, RectF rectF2) {
        return new ImmutableViewportMetrics(rectF.left, rectF.top, rectF.right, rectF.bottom, rectF2.left, rectF2.top, rectF2.right, rectF2.bottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectWidth, this.viewportRectHeight, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setPageRectFrom(ImmutableViewportMetrics immutableViewportMetrics) {
        if (immutableViewportMetrics.cssPageRectLeft == this.cssPageRectLeft && immutableViewportMetrics.cssPageRectTop == this.cssPageRectTop && immutableViewportMetrics.cssPageRectRight == this.cssPageRectRight && immutableViewportMetrics.cssPageRectBottom == this.cssPageRectBottom) {
            return this;
        }
        RectF rectF = immutableViewportMetrics.getCssPageRect();
        return this.setPageRect(RectUtils.scale(rectF, this.zoomFactor), rectF);
    }

    public ImmutableViewportMetrics setIsRTL(boolean bl) {
        if (this.isRTL == bl) {
            return this;
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectWidth, this.viewportRectHeight, this.zoomFactor, bl);
    }

    public ImmutableViewportMetrics scaleTo(float f, PointF pointF) {
        float f2 = this.cssPageRectLeft * f;
        float f3 = this.cssPageRectTop * f;
        float f4 = this.cssPageRectLeft + (this.cssPageRectRight - this.cssPageRectLeft) * f;
        float f5 = this.cssPageRectTop + (this.cssPageRectBottom - this.cssPageRectTop) * f;
        PointF pointF2 = this.getOrigin();
        pointF2.offset(pointF.x, pointF.y);
        pointF2 = PointUtils.scale(pointF2, f / this.zoomFactor);
        pointF2.offset(-pointF.x, -pointF.y);
        return new ImmutableViewportMetrics(f2, f3, f4, f5, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, pointF2.x, pointF2.y, this.viewportRectWidth, this.viewportRectHeight, f, this.isRTL);
    }

    public ImmutableViewportMetrics clamp() {
        RectF rectF = this.getViewport();
        if (rectF.right > this.pageRectRight) {
            rectF.offset(this.pageRectRight - rectF.right, 0.0f);
        }
        if (rectF.left < this.pageRectLeft) {
            rectF.offset(this.pageRectLeft - rectF.left, 0.0f);
        }
        if (rectF.bottom > this.pageRectBottom) {
            rectF.offset(0.0f, this.pageRectBottom - rectF.bottom);
        }
        if (rectF.top < this.pageRectTop) {
            rectF.offset(0.0f, this.pageRectTop - rectF.top);
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, rectF.left, rectF.top, this.viewportRectWidth, this.viewportRectHeight, this.zoomFactor, this.isRTL);
    }

    public boolean fuzzyEquals(ImmutableViewportMetrics immutableViewportMetrics) {
        return FloatUtils.fuzzyEquals((float)this.cssPageRectLeft, (float)immutableViewportMetrics.cssPageRectLeft) && FloatUtils.fuzzyEquals((float)this.cssPageRectTop, (float)immutableViewportMetrics.cssPageRectTop) && FloatUtils.fuzzyEquals((float)this.cssPageRectRight, (float)immutableViewportMetrics.cssPageRectRight) && FloatUtils.fuzzyEquals((float)this.cssPageRectBottom, (float)immutableViewportMetrics.cssPageRectBottom) && FloatUtils.fuzzyEquals((float)this.viewportRectLeft, (float)immutableViewportMetrics.viewportRectLeft) && FloatUtils.fuzzyEquals((float)this.viewportRectTop, (float)immutableViewportMetrics.viewportRectTop) && this.viewportRectWidth == immutableViewportMetrics.viewportRectWidth && this.viewportRectHeight == immutableViewportMetrics.viewportRectHeight && FloatUtils.fuzzyEquals((float)this.zoomFactor, (float)immutableViewportMetrics.zoomFactor);
    }

    public String toString() {
        return "ImmutableViewportMetrics v=(" + this.viewportRectLeft + "," + this.viewportRectTop + "," + this.viewportRectWidth + "x" + this.viewportRectHeight + ") p=(" + this.pageRectLeft + "," + this.pageRectTop + "," + this.pageRectRight + "," + this.pageRectBottom + ") c=(" + this.cssPageRectLeft + "," + this.cssPageRectTop + "," + this.cssPageRectRight + "," + this.cssPageRectBottom + ") z=" + this.zoomFactor + ", rtl=" + this.isRTL;
    }
}

