/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HistoryHeaderListCursorAdapter;
import org.mozilla.gecko.home.HistoryItemAdapter;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TransitionAwareCursorLoaderCallbacks;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.util.HardwareUtils;

public class HistoryPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoHistoryPanel";
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_WEEK = 604800000L;
    private static final List<MostRecentSectionRange> recentSectionTimeOffsetList = new ArrayList<MostRecentSectionRange>(MostRecentSection.values().length);
    private static final int LOADER_ID_HISTORY = 0;
    private static final String FORMAT_S1 = "%1$s";
    private static final String FORMAT_S2 = "%2$s";
    private static MostRecentSection selected;
    private CursorAdapter mAdapter;
    private ArrayAdapter<MostRecentSection> mRangeAdapter;
    private HomeListView mList;
    private HomeListView mRangeList;
    private View mClearHistoryButton;
    private View mEmptyView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_history_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mRangeList = (HomeListView)view.findViewById(R.id.range_list);
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mList.setTag("history");
        if (this.mRangeList != null) {
            this.mRangeList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                    MostRecentSection mostRecentSection = (MostRecentSection)((Object)adapterView.getItemAtPosition(n));
                    if (mostRecentSection != null) {
                        selected = mostRecentSection;
                        HistoryPanel.this.mRangeAdapter.notifyDataSetChanged();
                        HistoryPanel.this.getLoaderManager().getLoader(0).forceLoad();
                        HistoryPanel.this.mList.smoothScrollToPosition(0);
                    }
                }
            });
        }
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                String string2 = ((HistoryUrlProvider)HistoryPanel.this.mAdapter).getURL(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "history");
                HistoryPanel.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                homeContextMenuInfo.historyId = cursor.getInt(cursor.getColumnIndexOrThrow("history_id"));
                homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.HISTORY;
                int n2 = cursor.getColumnIndexOrThrow("bookmark_id");
                homeContextMenuInfo.bookmarkId = cursor.isNull(n2) ? -1 : cursor.getInt(n2);
                return homeContextMenuInfo;
            }
        });
        this.registerForContextMenu((View)this.mList);
        this.mClearHistoryButton = view.findViewById(R.id.clear_history_button);
        this.mClearHistoryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FragmentActivity fragmentActivity = HistoryPanel.this.getActivity();
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)fragmentActivity);
                builder.setMessage(R.string.home_clear_history_confirm);
                builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        dialogInterface.dismiss();
                    }
                });
                builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        dialogInterface.dismiss();
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("history", true);
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)HistoryPanel.LOGTAG, (String)"JSON error", (Throwable)jSONException);
                        }
                        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Sanitize:ClearData", jSONObject.toString()));
                        Telemetry.sendUIEvent(TelemetryContract.Event.SANITIZE, TelemetryContract.Method.BUTTON, "history");
                    }
                });
                builder.show();
            }
        });
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
        if (!Restrictions.isAllowed((Context)this.getActivity(), Restrictable.CLEAR_HISTORY)) {
            contextMenu.findItem(R.id.home_remove).setVisible(false);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mRangeList != null) {
            this.mRangeList.setOnItemClickListener(null);
        }
        this.mList.setOnItemClickListener(null);
        this.mRangeList = null;
        this.mList = null;
        this.mEmptyView = null;
        this.mClearHistoryButton = null;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        MostRecentSection mostRecentSection = selected = this.mRangeList == null ? MostRecentSection.THIS_MONTH : MostRecentSection.TODAY;
        if (this.mRangeList != null) {
            this.mAdapter = new HistoryItemAdapter((Context)this.getActivity(), null, R.layout.home_item_row);
            this.mRangeAdapter = new HistoryRangeAdapter((Context)this.getActivity(), R.layout.home_history_range_item);
            this.mRangeList.setAdapter((ListAdapter)this.mRangeAdapter);
            this.mList.setAdapter((ListAdapter)this.mAdapter);
        } else {
            this.mAdapter = new HistoryHeaderListCursorAdapter((Context)this.getActivity());
            this.mList.setAdapter((ListAdapter)this.mAdapter);
        }
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        HistoryPanel.updateRecentSectionOffset((Context)this.getActivity());
        this.loadIfVisible();
    }

    @Override
    protected void loadIfVisible() {
        if (this.canLoad() && HardwareUtils.isTablet()) {
            this.load();
            return;
        }
        super.loadIfVisible();
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            if (Restrictions.isAllowed((Context)this.getActivity(), Restrictable.CLEAR_HISTORY)) {
                this.mClearHistoryButton.setVisibility(0);
            }
            return;
        }
        this.mClearHistoryButton.setVisibility(8);
        if (this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_most_recent_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            if (selected == null || this.mRangeAdapter == null || this.mRangeList == null) {
                textView.setText(R.string.home_most_recent_empty);
            } else {
                textView.setText(R.string.home_selected_empty);
            }
            TextView textView2 = (TextView)this.mEmptyView.findViewById(R.id.home_empty_hint);
            String string2 = this.getResources().getString(R.string.home_most_recent_emptyhint);
            SpannableStringBuilder spannableStringBuilder = this.formatHintText(string2);
            if (spannableStringBuilder != null) {
                textView2.setText((CharSequence)spannableStringBuilder);
                textView2.setMovementMethod(LinkMovementMethod.getInstance());
                textView2.setVisibility(0);
            }
            if (!Restrictions.isAllowed((Context)this.getActivity(), Restrictable.PRIVATE_BROWSING)) {
                textView2.setVisibility(8);
            }
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    private SpannableStringBuilder formatHintText(String string2) {
        int n;
        int n2 = string2.indexOf(FORMAT_S1);
        if (n2 >= (n = string2.indexOf(FORMAT_S2))) {
            return null;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.PANEL, "hint-private-browsing");
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("type", (Object)"Menu:Open");
                    EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
                }
                catch (JSONException jSONException) {
                    Log.e((String)HistoryPanel.LOGTAG, (String)"Error forming JSON for Private Browsing contextual hint", (Throwable)jSONException);
                }
            }
        };
        spannableStringBuilder.setSpan((Object)clickableSpan, 0, string2.length(), 0);
        UnderlineSpan underlineSpan = new UnderlineSpan(){

            public void updateDrawState(TextPaint textPaint) {
                textPaint.setUnderlineText(false);
            }
        };
        spannableStringBuilder.setSpan((Object)underlineSpan, 0, string2.length(), 0);
        spannableStringBuilder.setSpan((Object)new UnderlineSpan(), n2, n, 0);
        spannableStringBuilder.delete(n, n + FORMAT_S2.length());
        spannableStringBuilder.delete(n2, n2 + FORMAT_S1.length());
        return spannableStringBuilder;
    }

    private static void updateRecentSectionOffset(Context context) {
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 1);
        recentSectionTimeOffsetList.add(MostRecentSection.TODAY.ordinal(), new MostRecentSectionRange(calendar.getTimeInMillis(), l, context.getString(R.string.history_today_section)));
        recentSectionTimeOffsetList.add(MostRecentSection.YESTERDAY.ordinal(), new MostRecentSectionRange(calendar.getTimeInMillis() - 86400000L, calendar.getTimeInMillis(), context.getString(R.string.history_yesterday_section)));
        recentSectionTimeOffsetList.add(MostRecentSection.WEEK.ordinal(), new MostRecentSectionRange(calendar.getTimeInMillis() - 604800000L, l, context.getString(R.string.history_week_section)));
        calendar.add(2, 1);
        calendar.set(5, calendar.getMinimum(5));
        for (int i = MostRecentSection.THIS_MONTH.ordinal(); i < MostRecentSection.OLDER_THAN_SIX_MONTHS.ordinal(); ++i) {
            long l2 = calendar.getTimeInMillis();
            calendar.add(2, -1);
            long l3 = calendar.getTimeInMillis();
            String string2 = calendar.getDisplayName(2, 2, Locale.getDefault());
            recentSectionTimeOffsetList.add(i, new MostRecentSectionRange(l3, l2, string2));
        }
        recentSectionTimeOffsetList.add(MostRecentSection.OLDER_THAN_SIX_MONTHS.ordinal(), new MostRecentSectionRange(0L, calendar.getTimeInMillis(), context.getString(R.string.history_older_section)));
    }

    protected static String getMostRecentSectionTitle(MostRecentSection mostRecentSection) {
        return recentSectionTimeOffsetList.get(mostRecentSection.ordinal()).displayName;
    }

    protected static MostRecentSection getMostRecentSectionForTime(long l) {
        for (int i = 0; i < MostRecentSection.OLDER_THAN_SIX_MONTHS.ordinal(); ++i) {
            if (l <= recentSectionTimeOffsetList.get(i).start) continue;
            return MostRecentSection.values()[i];
        }
        return MostRecentSection.OLDER_THAN_SIX_MONTHS;
    }

    private class CursorLoaderCallbacks
    extends TransitionAwareCursorLoaderCallbacks {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new HistoryCursorLoader((Context)HistoryPanel.this.getActivity());
        }

        @Override
        public void onLoadFinishedAfterTransitions(Loader<Cursor> loader, Cursor cursor) {
            HistoryPanel.this.mAdapter.swapCursor(cursor);
            HistoryPanel.this.updateUiFromCursor(cursor);
        }

        @Override
        public void onLoaderReset(Loader<Cursor> loader) {
            super.onLoaderReset(loader);
            HistoryPanel.this.mAdapter.swapCursor(null);
        }
    }

    private static class HistoryRangeAdapter
    extends ArrayAdapter<MostRecentSection> {
        private final Context context;
        private final int resource;

        public HistoryRangeAdapter(Context context, int n) {
            super(context, n, (Object[])MostRecentSection.values());
            this.context = context;
            this.resource = n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            Object object;
            View view2;
            if (view != null) {
                view2 = view;
            } else {
                object = LayoutInflater.from((Context)this.context);
                view2 = object.inflate(this.resource, viewGroup, false);
                view2.setTag((Object)view2.findViewById(R.id.range_title));
            }
            object = (MostRecentSection)((Object)this.getItem(n));
            TextView textView = (TextView)view2.getTag();
            textView.setText((CharSequence)HistoryPanel.getMostRecentSectionTitle((MostRecentSection)((Object)object)));
            textView.setTextColor(ColorUtils.getColor((Context)this.context, (int)(object == selected ? R.color.text_and_tabs_tray_grey : R.color.disabled_grey)));
            textView.setCompoundDrawablesWithIntrinsicBounds(0, 0, object == selected ? R.drawable.home_group_collapsed : 0, 0);
            return view2;
        }
    }

    private static class MostRecentSectionRange {
        private final long start;
        private final long end;
        private final String displayName;

        private MostRecentSectionRange(long l, long l2, String string2) {
            this.start = l;
            this.end = l2;
            this.displayName = string2;
        }
    }

    private static class HistoryCursorLoader
    extends SimpleCursorLoader {
        private static final int HISTORY_LIMIT = 100;
        private final BrowserDB mDB;

        public HistoryCursorLoader(Context context) {
            super(context);
            this.mDB = GeckoProfile.get(context).getDB();
        }

        @Override
        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            HistoryPanel.updateRecentSectionOffset(this.getContext());
            MostRecentSectionRange mostRecentSectionRange = (MostRecentSectionRange)recentSectionTimeOffsetList.get(selected.ordinal());
            return this.mDB.getRecentHistoryBetweenTime(contentResolver, 100, mostRecentSectionRange.start, mostRecentSectionRange.end);
        }
    }

    protected static interface HistoryUrlProvider {
        public String getURL(int var1);
    }

    public static enum MostRecentSection {
        TODAY,
        YESTERDAY,
        WEEK,
        THIS_MONTH,
        MONTH_AGO,
        TWO_MONTHS_AGO,
        THREE_MONTHS_AGO,
        FOUR_MONTHS_AGO,
        FIVE_MONTHS_AGO,
        OLDER_THAN_SIX_MONTHS;

    }
}

