/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import java.util.EnumSet;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.TopSitesGridView;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public abstract class HomeFragment
extends Fragment {
    private static final String LOGTAG = "GeckoHomeFragment";
    protected static final String SHARE_MIME_TYPE = "text/plain";
    static final boolean DEFAULT_CAN_LOAD_HINT = false;
    private boolean mCanLoadHint;
    private boolean mIsLoaded;
    protected HomePager.OnUrlOpenListener mUrlOpenListener;
    private HomePager.OnUrlOpenInBackgroundListener mUrlOpenInBackgroundListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
        try {
            this.mUrlOpenInBackgroundListener = (HomePager.OnUrlOpenInBackgroundListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenInBackgroundListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
        this.mUrlOpenInBackgroundListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        this.mCanLoadHint = bundle2 != null ? bundle2.getBoolean("canLoad", false) : false;
        this.mIsLoaded = false;
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (!(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return;
        }
        HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        if (homeContextMenuInfo.isFolder) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_contextmenu, (Menu)contextMenu);
        contextMenu.setHeaderTitle((CharSequence)homeContextMenuInfo.getDisplayTitle());
        contextMenu.findItem(R.id.top_sites_edit).setVisible(false);
        contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
        contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
        if (!homeContextMenuInfo.hasBookmarkId() || homeContextMenuInfo.isInReadingList()) {
            contextMenu.findItem(R.id.home_edit_bookmark).setVisible(false);
        }
        if (!homeContextMenuInfo.canRemove()) {
            contextMenu.findItem(R.id.home_remove).setVisible(false);
        }
        if (!StringUtils.isShareableUrl((String)homeContextMenuInfo.url) || GeckoProfile.get((Context)this.getActivity()).inGuestMode()) {
            contextMenu.findItem(R.id.home_share).setVisible(false);
        }
        if (!Restrictions.isAllowed(view.getContext(), Restrictable.PRIVATE_BROWSING)) {
            contextMenu.findItem(R.id.home_open_private_tab).setVisible(false);
        }
        contextMenu.findItem(R.id.mark_read).setVisible(homeContextMenuInfo.isInReadingList() && homeContextMenuInfo.isUnread);
        contextMenu.findItem(R.id.mark_unread).setVisible(homeContextMenuInfo.isInReadingList() && !homeContextMenuInfo.isUnread);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (!(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return false;
        }
        final HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        FragmentActivity fragmentActivity = this.getActivity();
        int n = menuItem.getItemId();
        String string2 = this.getResources().getResourceEntryName(n);
        if (TextUtils.equals((CharSequence)string2, (CharSequence)"home_open_private_tab")) {
            string2 = "home_open_new_tab";
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, string2);
        if (n == R.id.home_copyurl) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't copy address because URL is null");
                return false;
            }
            Clipboard.setText((CharSequence)homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_share) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't share because URL is null");
                return false;
            }
            GeckoAppShell.openUriExternal(homeContextMenuInfo.url, SHARE_MIME_TYPE, "", "", "android.intent.action.SEND", homeContextMenuInfo.getDisplayTitle(), false);
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST, "home_contextmenu");
            return true;
        }
        if (n == R.id.home_add_to_launcher) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't add to home screen because URL is null");
                return false;
            }
            final String string3 = homeContextMenuInfo.getDisplayTitle();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoAppShell.createShortcut(string3, homeContextMenuInfo.url);
                }
            });
            return true;
        }
        if (n == R.id.home_open_private_tab || n == R.id.home_open_new_tab) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't open in new tab because URL is null");
                return false;
            }
            String string4 = StringUtils.decodeUserEnteredUrl((String)(homeContextMenuInfo.isInReadingList() ? ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url) : homeContextMenuInfo.url));
            EnumSet<HomePager.OnUrlOpenInBackgroundListener.Flags> enumSet = EnumSet.noneOf(HomePager.OnUrlOpenInBackgroundListener.Flags.class);
            if (menuItem.getItemId() == R.id.home_open_private_tab) {
                enumSet.add(HomePager.OnUrlOpenInBackgroundListener.Flags.PRIVATE);
            }
            this.mUrlOpenInBackgroundListener.onUrlOpenInBackground(string4, enumSet);
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.CONTEXT_MENU);
            return true;
        }
        if (n == R.id.home_edit_bookmark) {
            new EditBookmarkDialog((Context)fragmentActivity).show(homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_remove) {
            int n2 = homeContextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo ? homeContextMenuInfo.position : -1;
            new RemoveItemByUrlTask((Context)fragmentActivity, homeContextMenuInfo.url, homeContextMenuInfo.itemType, n2).execute();
            return true;
        }
        if (n == R.id.mark_read) {
            GeckoProfile.get((Context)fragmentActivity).getDB().getReadingListAccessor().markAsRead(fragmentActivity.getContentResolver(), homeContextMenuInfo.id);
        }
        if (n == R.id.mark_unread) {
            GeckoProfile.get((Context)fragmentActivity).getDB().getReadingListAccessor().markAsUnread(fragmentActivity.getContentResolver(), homeContextMenuInfo.id);
        }
        return false;
    }

    public void setUserVisibleHint(boolean bl) {
        if (bl == this.getUserVisibleHint()) {
            return;
        }
        super.setUserVisibleHint(bl);
        this.loadIfVisible();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    void setCanLoadHint(boolean bl) {
        if (this.mCanLoadHint == bl) {
            return;
        }
        this.mCanLoadHint = bl;
        this.loadIfVisible();
    }

    boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    protected abstract void load();

    protected boolean canLoad() {
        return this.mCanLoadHint && this.isVisible() && this.getUserVisibleHint();
    }

    protected void loadIfVisible() {
        if (!this.canLoad() || this.mIsLoaded) {
            return;
        }
        this.load();
        this.mIsLoaded = true;
    }

    protected static class RemoveItemByUrlTask
    extends UIAsyncTask.WithoutParams<Void> {
        private final Context mContext;
        private final String mUrl;
        private final HomeContextMenuInfo.RemoveItemType mType;
        private final int mPosition;
        private final BrowserDB mDB;

        public RemoveItemByUrlTask(Context context, String string2, HomeContextMenuInfo.RemoveItemType removeItemType, int n) {
            super(ThreadUtils.getBackgroundHandler());
            this.mContext = context;
            this.mUrl = string2;
            this.mType = removeItemType;
            this.mPosition = n;
            this.mDB = GeckoProfile.get(context).getDB();
        }

        public Void doInBackground() {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            if (this.mPosition > -1) {
                this.mDB.unpinSite(contentResolver, this.mPosition);
                if (this.mDB.hideSuggestedSite(this.mUrl)) {
                    contentResolver.notifyChange(BrowserContract.SuggestedSites.CONTENT_URI, null);
                }
            }
            switch (this.mType) {
                case BOOKMARKS: {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.CONTEXT_MENU, "bookmark");
                    this.mDB.removeBookmarksWithURL(contentResolver, this.mUrl);
                    break;
                }
                case HISTORY: {
                    this.mDB.removeHistoryEntry(contentResolver, this.mUrl);
                    break;
                }
                case READING_LIST: {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.CONTEXT_MENU, "reading_list");
                    this.mDB.getReadingListAccessor().removeReadingListItemWithURL(contentResolver, this.mUrl);
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:Removed", this.mUrl));
                    break;
                }
                default: {
                    Log.e((String)HomeFragment.LOGTAG, (String)("Can't remove item type " + this.mType.toString()));
                }
            }
            return null;
        }

        public void onPostExecute(Void void_) {
            SnackbarHelper.showSnackbar((Activity)this.mContext, this.mContext.getString(R.string.page_removed), -1);
        }
    }
}

