/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.PanelViewAdapter;
import org.mozilla.gecko.home.PanelViewItemHandler;

public class PanelListView
extends HomeListView
implements PanelLayout.DatasetBacked,
PanelLayout.PanelView {
    private static final String LOGTAG = "GeckoPanelListView";
    private final HomeConfig.ViewConfig viewConfig;
    private final PanelViewAdapter adapter;
    private final PanelViewItemHandler itemHandler;
    private PanelLayout.OnItemOpenListener itemOpenListener;

    public PanelListView(Context context, HomeConfig.ViewConfig viewConfig) {
        super(context);
        this.viewConfig = viewConfig;
        this.itemHandler = new PanelViewItemHandler();
        this.adapter = new PanelViewAdapter(context, viewConfig);
        this.setAdapter((ListAdapter)this.adapter);
        this.setOnItemClickListener(new PanelListItemClickListener());
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.itemHandler.setOnItemOpenListener(this.itemOpenListener);
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.itemHandler.setOnItemOpenListener(null);
    }

    @Override
    public void setDataset(Cursor cursor) {
        Log.d((String)LOGTAG, (String)("Setting dataset: " + this.viewConfig.getDatasetId()));
        this.adapter.swapCursor(cursor);
    }

    @Override
    public void setOnItemOpenListener(PanelLayout.OnItemOpenListener onItemOpenListener) {
        this.itemHandler.setOnItemOpenListener(onItemOpenListener);
        this.itemOpenListener = onItemOpenListener;
    }

    @Override
    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.adapter.setFilterManager(filterManager);
        this.itemHandler.setFilterManager(filterManager);
    }

    private class PanelListItemClickListener
    implements AdapterView.OnItemClickListener {
        private PanelListItemClickListener() {
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            PanelListView.this.itemHandler.openItemAtPosition(PanelListView.this.adapter.getCursor(), n);
        }
    }
}

