/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;
import java.util.Map;
import org.json.JSONException;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.mdns.NsdMulticastDNSManager;
import org.mozilla.gecko.util.EventCallback;

@TargetApi(value=16)
class RegistrationListener
implements NsdManager.RegistrationListener {
    private static final String LOGTAG = "GeckoMDNSManager";
    private final NsdManager nsdManager;
    private EventCallback mStartCallback = null;
    private EventCallback mStopCallback = null;

    RegistrationListener(NsdManager nsdManager) {
        this.nsdManager = nsdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(int n, String string2, String string3, Map<String, String> map, EventCallback eventCallback) {
        Log.d((String)LOGTAG, (String)("registerService: " + string2 + "." + string3 + ":" + n));
        NsdServiceInfo nsdServiceInfo = new NsdServiceInfo();
        nsdServiceInfo.setPort(n);
        nsdServiceInfo.setServiceName(string2);
        nsdServiceInfo.setServiceType(string3);
        this.setAttributes(nsdServiceInfo, map);
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            this.mStartCallback = eventCallback;
        }
        this.nsdManager.registerService(nsdServiceInfo, 1, (NsdManager.RegistrationListener)this);
    }

    @TargetApi(value=21)
    private void setAttributes(NsdServiceInfo nsdServiceInfo, Map<String, String> map) {
        if (map == null || !AppConstants.Versions.feature21Plus) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            nsdServiceInfo.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(EventCallback eventCallback) {
        Log.d((String)LOGTAG, (String)"unregisterService");
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            this.mStopCallback = eventCallback;
        }
        this.nsdManager.unregisterService((NsdManager.RegistrationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onServiceRegistered(NsdServiceInfo nsdServiceInfo) {
        EventCallback eventCallback;
        Log.d((String)LOGTAG, (String)("onServiceRegistered: " + nsdServiceInfo.getServiceName()));
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            eventCallback = this.mStartCallback;
        }
        if (eventCallback == null) {
            return;
        }
        try {
            eventCallback.sendSuccess((Object)NsdMulticastDNSManager.toJSON(nsdServiceInfo));
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onRegistrationFailed(NsdServiceInfo nsdServiceInfo, int n) {
        EventCallback eventCallback;
        Log.e((String)LOGTAG, (String)("onRegistrationFailed: " + nsdServiceInfo.getServiceName() + "(" + n + ")"));
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            eventCallback = this.mStartCallback;
        }
        eventCallback.sendError((Object)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onServiceUnregistered(NsdServiceInfo nsdServiceInfo) {
        EventCallback eventCallback;
        Log.d((String)LOGTAG, (String)("onServiceUnregistered: " + nsdServiceInfo.getServiceName()));
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            eventCallback = this.mStopCallback;
        }
        if (eventCallback == null) {
            return;
        }
        try {
            eventCallback.sendSuccess((Object)NsdMulticastDNSManager.toJSON(nsdServiceInfo));
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onUnregistrationFailed(NsdServiceInfo nsdServiceInfo, int n) {
        EventCallback eventCallback;
        Log.e((String)LOGTAG, (String)("onUnregistrationFailed: " + nsdServiceInfo.getServiceName() + "(" + n + ")"));
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            eventCallback = this.mStopCallback;
        }
        if (eventCallback == null) {
            return;
        }
        eventCallback.sendError((Object)n);
    }
}

