/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.widget.themed.ThemedImageButton;

public class MenuItemActionBar
extends ThemedImageButton
implements GeckoMenuItem.Layout {
    private static final String LOGTAG = "GeckoMenuItemActionBar";

    public MenuItemActionBar(Context context) {
        this(context, null);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemActionBarStyle);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.setIcon(geckoMenuItem.getIcon());
        this.setTitle(geckoMenuItem.getTitle());
        this.setEnabled(geckoMenuItem.isEnabled());
        this.setId(geckoMenuItem.getItemId());
    }

    void setIcon(Drawable drawable2) {
        if (drawable2 == null) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            this.setImageDrawable(drawable2);
        }
    }

    void setIcon(int n) {
        this.setIcon(n == 0 ? null : this.getResources().getDrawable(n));
    }

    void setTitle(CharSequence charSequence) {
        this.setContentDescription(charSequence);
    }

    @Override
    public void setShowIcon(boolean bl) {
    }
}

