/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.AppCompatCheckBox;
import android.text.Html;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.TimePicker;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.prompts.ColorPickerInput;
import org.mozilla.gecko.prompts.IconGridInput;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.TabInput;
import org.mozilla.gecko.widget.AllCapsTextView;
import org.mozilla.gecko.widget.DateTimePicker;

public class PromptInput {
    protected final String mLabel;
    protected final String mType;
    protected final String mId;
    protected final String mValue;
    protected final String mMinValue;
    protected final String mMaxValue;
    protected OnChangeListener mListener;
    protected View mView;
    public static final String LOGTAG = "GeckoPromptInput";

    public void setListener(OnChangeListener onChangeListener) {
        this.mListener = onChangeListener;
    }

    public PromptInput(JSONObject jSONObject) {
        this.mLabel = jSONObject.optString("label");
        this.mType = jSONObject.optString("type");
        String string2 = jSONObject.optString("id");
        this.mId = TextUtils.isEmpty((CharSequence)string2) ? this.mType : string2;
        this.mValue = jSONObject.optString("value");
        this.mMaxValue = jSONObject.optString("max");
        this.mMinValue = jSONObject.optString("min");
    }

    public static PromptInput getInput(JSONObject jSONObject) {
        String string2;
        switch (string2 = jSONObject.optString("type")) {
            case "textbox": {
                return new EditInput(jSONObject);
            }
            case "number": {
                return new NumberInput(jSONObject);
            }
            case "password": {
                return new PasswordInput(jSONObject);
            }
            case "checkbox": {
                return new CheckboxInput(jSONObject);
            }
            case "menulist": {
                return new MenulistInput(jSONObject);
            }
            case "label": {
                return new LabelInput(jSONObject);
            }
            case "icongrid": {
                return new IconGridInput(jSONObject);
            }
            case "color": {
                return new ColorPickerInput(jSONObject);
            }
            case "tabs": {
                return new TabInput(jSONObject);
            }
        }
        for (String string3 : DateTimeInput.INPUT_TYPES) {
            if (!string3.equals(string2)) continue;
            return new DateTimeInput(jSONObject);
        }
        return null;
    }

    public View getView(Context context) throws UnsupportedOperationException {
        return null;
    }

    public String getId() {
        return this.mId;
    }

    public Object getValue() {
        return null;
    }

    public boolean getScrollable() {
        return false;
    }

    public boolean canApplyInputStyle() {
        return true;
    }

    protected void notifyListeners(String string2) {
        if (this.mListener != null) {
            this.mListener.onChange(this);
        }
    }

    public static class LabelInput
    extends PromptInput {
        public static final String INPUT_TYPE = "label";

        public LabelInput(JSONObject jSONObject) {
            super(jSONObject);
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            TextView textView = new TextView(context);
            textView.setText((CharSequence)Html.fromHtml((String)this.mLabel));
            this.mView = textView;
            return this.mView;
        }
    }

    public static class MenulistInput
    extends PromptInput {
        public static final String INPUT_TYPE = "menulist";
        private static String[] mListitems;
        private static int mSelected;
        public Spinner spinner;
        public AllCapsTextView textView;

        public MenulistInput(JSONObject jSONObject) {
            super(jSONObject);
            mListitems = Prompt.getStringArray(jSONObject, "values");
            mSelected = jSONObject.optInt("selected");
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            ArrayAdapter arrayAdapter;
            this.spinner = AppConstants.Versions.preHC ? new Spinner(context) : new Spinner(context, 0);
            try {
                if (mListitems.length > 0) {
                    arrayAdapter = new ArrayAdapter(context, 17367048, (Object[])mListitems);
                    arrayAdapter.setDropDownViewResource(0x1090009);
                    this.spinner.setAdapter((SpinnerAdapter)arrayAdapter);
                    this.spinner.setSelection(mSelected);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLabel)) {
                arrayAdapter = new LinearLayout(context);
                arrayAdapter.setOrientation(1);
                this.textView = new AllCapsTextView(context, null);
                this.textView.setText(this.mLabel);
                arrayAdapter.addView((View)this.textView);
                arrayAdapter.addView((View)this.spinner);
                return arrayAdapter;
            }
            return this.spinner;
        }

        @Override
        public Object getValue() {
            return this.spinner.getSelectedItemPosition();
        }
    }

    public static class DateTimeInput
    extends PromptInput {
        public static final String[] INPUT_TYPES = new String[]{"date", "week", "time", "datetime-local", "datetime", "month"};

        public DateTimeInput(JSONObject jSONObject) {
            super(jSONObject);
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            if (this.mType.equals("date")) {
                try {
                    DateTimePicker dateTimePicker = new DateTimePicker(context, "yyyy-MM-dd", this.mValue, DateTimePicker.PickersState.DATE, this.mMinValue, this.mMaxValue);
                    dateTimePicker.toggleCalendar(true);
                    this.mView = dateTimePicker;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    DatePicker datePicker = new DatePicker(context);
                    try {
                        if (!TextUtils.isEmpty((CharSequence)this.mValue)) {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            gregorianCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(this.mValue));
                            datePicker.updateDate(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)PromptInput.LOGTAG, (String)("error parsing format string: " + exception));
                    }
                    this.mView = datePicker;
                }
            } else if (this.mType.equals("week")) {
                DateTimePicker dateTimePicker = new DateTimePicker(context, "yyyy-'W'ww", this.mValue, DateTimePicker.PickersState.WEEK, this.mMinValue, this.mMaxValue);
                this.mView = dateTimePicker;
            } else if (this.mType.equals("time")) {
                TimePicker timePicker = new TimePicker(context);
                timePicker.setIs24HourView(Boolean.valueOf(DateFormat.is24HourFormat((Context)context)));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (!TextUtils.isEmpty((CharSequence)this.mValue)) {
                    try {
                        gregorianCalendar.setTime(new SimpleDateFormat("HH:mm").parse(this.mValue));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                timePicker.setCurrentHour(Integer.valueOf(gregorianCalendar.get(11)));
                timePicker.setCurrentMinute(Integer.valueOf(gregorianCalendar.get(12)));
                this.mView = timePicker;
            } else if (this.mType.equals("datetime-local") || this.mType.equals("datetime")) {
                DateTimePicker dateTimePicker = new DateTimePicker(context, "yyyy-MM-dd HH:mm", this.mValue.replace("T", " ").replace("Z", ""), DateTimePicker.PickersState.DATETIME, this.mMinValue.replace("T", " ").replace("Z", ""), this.mMaxValue.replace("T", " ").replace("Z", ""));
                dateTimePicker.toggleCalendar(true);
                this.mView = dateTimePicker;
            } else if (this.mType.equals("month")) {
                DateTimePicker dateTimePicker = new DateTimePicker(context, "yyyy-MM", this.mValue, DateTimePicker.PickersState.MONTH, this.mMinValue, this.mMaxValue);
                this.mView = dateTimePicker;
            }
            return this.mView;
        }

        private static String formatDateString(String string2, Calendar calendar) {
            return new SimpleDateFormat(string2).format(calendar.getTime());
        }

        @Override
        public Object getValue() {
            if (AppConstants.Versions.preHC && this.mType.equals("date")) {
                DatePicker datePicker = (DatePicker)this.mView;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(datePicker.getYear(), datePicker.getMonth(), datePicker.getDayOfMonth());
                return DateTimeInput.formatDateString("yyyy-MM-dd", gregorianCalendar);
            }
            if (this.mType.equals("time")) {
                TimePicker timePicker = (TimePicker)this.mView;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0, timePicker.getCurrentHour(), timePicker.getCurrentMinute());
                return DateTimeInput.formatDateString("HH:mm", gregorianCalendar);
            }
            DateTimePicker dateTimePicker = (DateTimePicker)this.mView;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(dateTimePicker.getTimeInMillis());
            if (this.mType.equals("date")) {
                return DateTimeInput.formatDateString("yyyy-MM-dd", gregorianCalendar);
            }
            if (this.mType.equals("week")) {
                return DateTimeInput.formatDateString("yyyy-'W'ww", gregorianCalendar);
            }
            if (this.mType.equals("datetime-local")) {
                return DateTimeInput.formatDateString("yyyy-MM-dd'T'HH:mm", gregorianCalendar);
            }
            if (this.mType.equals("datetime")) {
                gregorianCalendar.set(15, 0);
                gregorianCalendar.setTimeInMillis(dateTimePicker.getTimeInMillis());
                return DateTimeInput.formatDateString("yyyy-MM-dd'T'HH:mm'Z'", gregorianCalendar);
            }
            if (this.mType.equals("month")) {
                return DateTimeInput.formatDateString("yyyy-MM", gregorianCalendar);
            }
            return super.getValue();
        }
    }

    public static class CheckboxInput
    extends PromptInput {
        public static final String INPUT_TYPE = "checkbox";
        private final boolean mChecked;

        public CheckboxInput(JSONObject jSONObject) {
            super(jSONObject);
            this.mChecked = jSONObject.optBoolean("checked");
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            AppCompatCheckBox appCompatCheckBox = new AppCompatCheckBox(context);
            appCompatCheckBox.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            appCompatCheckBox.setText((CharSequence)this.mLabel);
            appCompatCheckBox.setChecked(this.mChecked);
            this.mView = appCompatCheckBox;
            return this.mView;
        }

        @Override
        public Object getValue() {
            CheckBox checkBox = (CheckBox)this.mView;
            return checkBox.isChecked() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class PasswordInput
    extends EditInput {
        public static final String INPUT_TYPE = "password";

        public PasswordInput(JSONObject jSONObject) {
            super(jSONObject);
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            TextInputLayout textInputLayout = (TextInputLayout)super.getView(context);
            textInputLayout.getEditText().setInputType(524417);
            return textInputLayout;
        }
    }

    public static class NumberInput
    extends EditInput {
        public static final String INPUT_TYPE = "number";

        public NumberInput(JSONObject jSONObject) {
            super(jSONObject);
        }

        @Override
        public View getView(Context context) throws UnsupportedOperationException {
            TextInputLayout textInputLayout = (TextInputLayout)super.getView(context);
            EditText editText = textInputLayout.getEditText();
            editText.setRawInputType(3);
            editText.setInputType(4098);
            return editText;
        }
    }

    public static class EditInput
    extends PromptInput {
        protected final String mHint;
        protected final boolean mAutofocus;
        public static final String INPUT_TYPE = "textbox";

        public EditInput(JSONObject jSONObject) {
            super(jSONObject);
            this.mHint = jSONObject.optString("hint");
            this.mAutofocus = jSONObject.optBoolean("autofocus");
        }

        @Override
        public View getView(final Context context) throws UnsupportedOperationException {
            EditText editText = new EditText(context);
            editText.setInputType(1);
            editText.setText((CharSequence)this.mValue);
            if (!TextUtils.isEmpty((CharSequence)this.mHint)) {
                editText.setHint((CharSequence)this.mHint);
            }
            if (this.mAutofocus) {
                editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View view, boolean bl) {
                        if (bl) {
                            ((InputMethodManager)context.getSystemService("input_method")).showSoftInput(view, 0);
                        }
                    }
                });
                editText.requestFocus();
            }
            TextInputLayout textInputLayout = new TextInputLayout(context);
            textInputLayout.addView((View)editText);
            this.mView = textInputLayout;
            return this.mView;
        }

        @Override
        public Object getValue() {
            TextInputLayout textInputLayout = (TextInputLayout)this.mView;
            return textInputLayout.getEditText().getText();
        }
    }

    public static interface OnChangeListener {
        public void onChange(PromptInput var1);
    }
}

