/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueueService;

public class TabQueueDispatcher
extends Locales.LocaleAwareActivity {
    private static final String LOGTAG = "Gecko" + TabQueueDispatcher.class.getSimpleName();

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        GeckoAppShell.ensureCrashHandling();
        Intent intent = this.getIntent();
        int n = intent.getFlags() & 0xFF7FFFFF;
        intent.setFlags(n);
        ContextUtils.SafeIntent safeIntent = new ContextUtils.SafeIntent(intent);
        if (!TabQueueHelper.TAB_QUEUE_ENABLED) {
            this.loadNormally(safeIntent.getUnsafe());
            return;
        }
        boolean bl = safeIntent.getBooleanExtra("skip_tab_queue", false);
        if (bl) {
            this.loadNormally(safeIntent.getUnsafe());
            return;
        }
        String string2 = safeIntent.getDataString();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.abortDueToNoURL(string2);
            return;
        }
        boolean bl2 = TabQueueHelper.isTabQueueEnabled((Context)this);
        if (bl2) {
            this.showToast(safeIntent.getUnsafe());
        } else {
            this.loadNormally(safeIntent.getUnsafe());
        }
    }

    private void showToast(Intent intent) {
        intent.setClass(this.getApplicationContext(), TabQueueService.class);
        this.startService(intent);
        this.finish();
    }

    private void loadNormally(Intent intent) {
        intent.setClassName(this.getApplicationContext(), "org.mozilla.gecko.BrowserApp");
        this.startActivity(intent);
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, "");
        this.finish();
    }

    private void abortDueToNoURL(String string2) {
        Log.w((String)LOGTAG, (String)("Unable to process tab queue insertion. No URL found! - passed data string: " + string2));
        this.finish();
    }
}

