/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.lwt.LightweightTheme;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.tabs.TabsGridLayout;
import org.mozilla.gecko.tabs.TabsListLayout;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.widget.GeckoPopupMenu;
import org.mozilla.gecko.widget.IconTabWidget;
import org.mozilla.gecko.widget.themed.ThemedImageButton;

public class TabsPanel
extends LinearLayout
implements GeckoPopupMenu.OnMenuItemClickListener,
LightweightTheme.OnChangeListener,
IconTabWidget.OnTabChangedListener {
    private static final String LOGTAG = "Gecko" + TabsPanel.class.getSimpleName();
    private final Context mContext;
    private final GeckoApp mActivity;
    private final LightweightTheme mTheme;
    private RelativeLayout mHeader;
    private FrameLayout mTabsContainer;
    private PanelView mPanel;
    private PanelView mPanelNormal;
    private PanelView mPanelPrivate;
    private TabsLayoutChangeListener mLayoutChangeListener;
    private IconTabWidget mTabWidget;
    private static View mMenuButton;
    private static ImageButton mAddTab;
    private ImageButton mNavBackButton;
    private Panel mCurrentPanel;
    private boolean mVisible;
    private boolean mHeaderVisible;
    private final GeckoPopupMenu mPopupMenu;

    public static View createTabsLayout(Context context, AttributeSet attributeSet) {
        boolean bl;
        boolean bl2 = bl = context.getResources().getConfiguration().orientation == 2;
        if (HardwareUtils.isTablet() || bl) {
            return new TabsGridLayout(context, attributeSet);
        }
        return new TabsListLayout(context, attributeSet);
    }

    public TabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mActivity = (GeckoApp)context;
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.mCurrentPanel = Panel.NORMAL_TABS;
        this.mPopupMenu = new GeckoPopupMenu(context);
        this.mPopupMenu.inflate(R.menu.tabs_menu);
        this.mPopupMenu.setOnMenuItemClickListener(this);
        this.inflateLayout(context);
        this.initialize();
    }

    private void inflateLayout(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.tabs_panel_default, (ViewGroup)this);
    }

    private void initialize() {
        this.mHeader = (RelativeLayout)this.findViewById(R.id.tabs_panel_header);
        this.mTabsContainer = (FrameLayout)this.findViewById(R.id.tabs_container);
        this.mPanelNormal = (PanelView)this.findViewById(R.id.normal_tabs);
        this.mPanelNormal.setTabsPanel(this);
        this.mPanelPrivate = (PanelView)this.findViewById(R.id.private_tabs_panel);
        this.mPanelPrivate.setTabsPanel(this);
        mAddTab = (ImageButton)this.findViewById(R.id.add_tab);
        mAddTab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.addTab();
            }
        });
        this.mTabWidget = (IconTabWidget)this.findViewById(R.id.tab_widget);
        this.mTabWidget.addTab(R.drawable.tabs_normal, R.string.tabs_normal);
        ThemedImageButton themedImageButton = (ThemedImageButton)this.mTabWidget.addTab(R.drawable.tabs_private, R.string.tabs_private);
        themedImageButton.setPrivateMode(true);
        if (!Restrictions.isAllowed(this.mContext, Restrictable.PRIVATE_BROWSING)) {
            this.mTabWidget.setVisibility(8);
        }
        this.mTabWidget.setTabSelectionListener(this);
        mMenuButton = this.findViewById(R.id.menu);
        mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.showMenu();
            }
        });
        this.mNavBackButton = (ImageButton)this.findViewById(R.id.nav_back);
        this.mNavBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.mActivity.onBackPressed();
            }
        });
    }

    public void showMenu() {
        Menu menu2 = this.mPopupMenu.getMenu();
        menu2.findItem(R.id.new_tab).setVisible(this.mCurrentPanel != Panel.NORMAL_TABS);
        menu2.findItem(R.id.new_private_tab).setVisible(this.mCurrentPanel != Panel.PRIVATE_TABS && Restrictions.isAllowed(this.mContext, Restrictable.PRIVATE_BROWSING));
        menu2.findItem(R.id.close_all_tabs).setVisible(this.mCurrentPanel == Panel.NORMAL_TABS);
        menu2.findItem(R.id.close_private_tabs).setVisible(this.mCurrentPanel == Panel.PRIVATE_TABS);
        this.mPopupMenu.show();
    }

    private void addTab() {
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "new_tab");
        if (this.mCurrentPanel == Panel.NORMAL_TABS) {
            this.mActivity.addTab();
        } else {
            this.mActivity.addPrivateTab();
        }
        this.mActivity.autoHideTabs();
    }

    @Override
    public void onTabChanged(int n) {
        if (n == 0) {
            this.show(Panel.NORMAL_TABS);
        } else {
            this.show(Panel.PRIVATE_TABS);
        }
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.close_all_tabs) {
            if (this.mCurrentPanel == Panel.NORMAL_TABS) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, "close_all_tabs");
                mMenuButton.setEnabled(false);
                ((CloseAllPanelView)this.mPanelNormal).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close all tabs menu item should only be visible for normal tabs panel");
            }
            return true;
        }
        if (n == R.id.close_private_tabs) {
            if (this.mCurrentPanel == Panel.PRIVATE_TABS) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, "close_all_tabs");
                ((CloseAllPanelView)this.mPanelPrivate).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close private tabs menu item should only be visible for private tabs panel");
            }
            return true;
        }
        if (n == R.id.new_tab || n == R.id.new_private_tab) {
            this.hide();
        }
        return this.mActivity.onOptionsItemSelected(menuItem);
    }

    private static int getTabContainerHeight(FrameLayout frameLayout) {
        Resources resources = frameLayout.getContext().getResources();
        int n = resources.getDisplayMetrics().heightPixels;
        int n2 = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
        return n - n2;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTheme.addListener(this);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTheme.removeListener(this);
    }

    @Override
    public void onLightweightThemeChanged() {
        int n = ColorUtils.getColor((Context)this.getContext(), (int)R.color.text_and_tabs_tray_grey);
        LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n, true);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 0);
        this.setBackgroundDrawable(lightweightThemeDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundColor(ColorUtils.getColor((Context)this.getContext(), (int)R.color.text_and_tabs_tray_grey));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public void show(Panel panel) {
        this.prepareToShow(panel);
        int n = this.getVerticalPanelHeight();
        this.dispatchLayoutChange(this.getWidth(), n);
        this.mHeaderVisible = true;
    }

    public void prepareToShow(Panel panel) {
        if (!this.isShown()) {
            this.setVisibility(0);
        }
        if (this.mPanel != null) {
            this.mPanel.hide();
        }
        this.mVisible = true;
        this.mCurrentPanel = panel;
        int n = panel.ordinal();
        this.mTabWidget.setCurrentTab(n);
        switch (panel) {
            case NORMAL_TABS: {
                this.mPanel = this.mPanelNormal;
                break;
            }
            case PRIVATE_TABS: {
                this.mPanel = this.mPanelPrivate;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panel type " + (Object)((Object)panel));
            }
        }
        this.mPanel.show();
        mAddTab.setVisibility(0);
        mMenuButton.setEnabled(true);
        this.mPopupMenu.setAnchor(mMenuButton);
    }

    public int getVerticalPanelHeight() {
        int n = this.mContext.getResources().getDimensionPixelSize(R.dimen.browser_toolbar_height);
        int n2 = n + TabsPanel.getTabContainerHeight(this.mTabsContainer);
        return n2;
    }

    public void hide() {
        this.mHeaderVisible = false;
        if (this.mVisible) {
            this.mVisible = false;
            this.mPopupMenu.dismiss();
            this.dispatchLayoutChange(0, 0);
        }
    }

    public void refresh() {
        this.removeAllViews();
        this.inflateLayout(this.mContext);
        this.initialize();
        if (this.mVisible) {
            this.show(this.mCurrentPanel);
        }
    }

    public void autoHidePanel() {
        this.mActivity.autoHideTabs();
    }

    public boolean isShown() {
        return this.mVisible;
    }

    public void setHWLayerEnabled(boolean bl) {
        if (AppConstants.Versions.preHC) {
            return;
        }
        if (bl) {
            this.mHeader.setLayerType(2, null);
            this.mTabsContainer.setLayerType(2, null);
        } else {
            this.mHeader.setLayerType(0, null);
            this.mTabsContainer.setLayerType(0, null);
        }
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator) {
        if (AppConstants.Versions.preHC) {
            return;
        }
        if (!this.mHeaderVisible) {
            int n;
            Resources resources = this.getContext().getResources();
            int n2 = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
            int n3 = n = this.mVisible ? 0 : -n2;
            if (this.mVisible) {
                ViewHelper.setTranslationY((View)this.mHeader, -n2);
                ViewHelper.setTranslationY((View)this.mTabsContainer, -n2);
                ViewHelper.setAlpha((View)this.mTabsContainer, 0.0f);
            }
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.ALPHA, this.mVisible ? 1.0f : 0.0f);
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_Y, n);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_Y, n);
        }
        this.setHWLayerEnabled(true);
    }

    public void finishTabsAnimation() {
        if (AppConstants.Versions.preHC) {
            return;
        }
        this.setHWLayerEnabled(false);
        if (!this.mVisible && this.mPanel != null) {
            this.mPanel.hide();
            this.mPanel = null;
        }
    }

    public void setTabsLayoutChangeListener(TabsLayoutChangeListener tabsLayoutChangeListener) {
        this.mLayoutChangeListener = tabsLayoutChangeListener;
    }

    private void dispatchLayoutChange(int n, int n2) {
        if (this.mLayoutChangeListener != null) {
            this.mLayoutChangeListener.onTabsLayoutChange(n, n2);
        }
    }

    static class TabsPanelToolbar
    extends LinearLayout
    implements LightweightTheme.OnChangeListener {
        private final LightweightTheme mTheme;

        public TabsPanelToolbar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mTheme.addListener(this);
        }

        public void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mTheme.removeListener(this);
        }

        @Override
        public void onLightweightThemeChanged() {
            int n = ColorUtils.getColor((Context)this.getContext(), (int)R.color.text_and_tabs_tray_grey);
            LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n);
            if (lightweightThemeDrawable == null) {
                return;
            }
            lightweightThemeDrawable.setAlpha(34, 34);
            this.setBackgroundDrawable(lightweightThemeDrawable);
        }

        @Override
        public void onLightweightThemeReset() {
            this.setBackgroundColor(ColorUtils.getColor((Context)this.getContext(), (int)R.color.text_and_tabs_tray_grey));
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
            this.onLightweightThemeChanged();
        }
    }

    public static interface TabsLayoutChangeListener {
        public void onTabsLayoutChange(int var1, int var2);
    }

    public static interface TabsLayout
    extends CloseAllPanelView {
        public void setEmptyView(View var1);
    }

    public static interface CloseAllPanelView
    extends PanelView {
        public void closeAll();
    }

    public static interface PanelView {
        public void setTabsPanel(TabsPanel var1);

        public void show();

        public void hide();

        public boolean shouldExpand();
    }

    public static enum Panel {
        NORMAL_TABS,
        PRIVATE_TABS;

    }
}

