/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.trackingprotection;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.TransitionsTracker;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.util.HardwareUtils;

public class TrackingProtectionPrompt
extends Locales.LocaleAwareActivity {
    public static final String LOGTAG = "Gecko" + TrackingProtectionPrompt.class.getSimpleName();
    private boolean isAnimating;
    private View containerView;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.showPrompt();
    }

    private void showPrompt() {
        this.setContentView(R.layout.tracking_protection_prompt);
        this.findViewById(R.id.ok_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TrackingProtectionPrompt.this.onConfirmButtonPressed();
            }
        });
        this.findViewById(R.id.link_text).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TrackingProtectionPrompt.this.slideOut();
                Intent intent = new Intent((Context)TrackingProtectionPrompt.this, GeckoPreferences.class);
                GeckoPreferences.setResourceToOpen(intent, "preferences_privacy");
                TrackingProtectionPrompt.this.startActivity(intent);
                if (HardwareUtils.IS_KINDLE_DEVICE) {
                    TrackingProtectionPrompt.this.overridePendingTransition(0, 0);
                }
            }
        });
        this.containerView = this.findViewById(R.id.tracking_protection_inner_container);
        ViewHelper.setTranslationY((View)this.containerView, (float)500.0f);
        ViewHelper.setAlpha((View)this.containerView, (float)0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        TransitionsTracker.track((Animator)animatorSet);
        animatorSet.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private void onConfirmButtonPressed() {
        this.slideOut();
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                TrackingProtectionPrompt.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void onBackPressed() {
        this.slideOut();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        return true;
    }
}

