/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.nineoldandroids.view.ViewHelper;
import org.mozilla.gecko.widget.themed.ThemedImageView;

public abstract class CropImageView
extends ThemedImageView {
    public static final String LOGTAG = "Gecko" + CropImageView.class.getSimpleName();
    private int viewWidth;
    private int viewHeight;
    private int drawableWidth;
    private int drawableHeight;
    private boolean resize = true;
    private Matrix layoutCurrentMatrix = new Matrix();
    private Matrix layoutNextMatrix = new Matrix();

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CropImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    protected abstract float getAspectRatio();

    protected void init() {
        ViewHelper.setPivotX((View)this, (float)1.0f);
        ViewHelper.setPivotY((View)this, (float)1.0f);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.viewWidth = this.getMeasuredWidth();
        this.viewHeight = (int)((float)this.viewWidth * this.getAspectRatio());
        this.setMeasuredDimension(this.viewWidth, this.viewHeight);
        this.updateImageMatrix();
    }

    protected void updateImageMatrix() {
        if (!this.resize || this.getDrawable() == null) {
            return;
        }
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.getDrawable().setBounds(0, 0, this.viewWidth, this.viewHeight);
        float f = (float)this.viewWidth / (float)this.drawableWidth;
        float f2 = (float)this.viewHeight / (float)this.drawableHeight;
        float f3 = Math.max(f2, f);
        this.layoutNextMatrix.reset();
        this.layoutNextMatrix.setScale(f3, f3);
        this.setImageMatrix(this.layoutNextMatrix);
        Matrix matrix = this.layoutCurrentMatrix;
        this.layoutCurrentMatrix = this.layoutNextMatrix;
        this.layoutNextMatrix = matrix;
    }

    public void setImageBitmap(Bitmap bitmap, boolean bl) {
        super.setImageBitmap(bitmap);
        this.resize = bl;
        this.updateImageMatrix();
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        this.setImageMatrix(null);
        this.resize = false;
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        this.setImageDrawable(drawable2, false);
    }

    public void setImageDrawable(Drawable drawable2, boolean bl) {
        super.setImageDrawable(drawable2);
        if (drawable2 != null) {
            this.setImageMatrix(null);
            this.drawableWidth = drawable2.getIntrinsicWidth();
            this.drawableHeight = drawable2.getIntrinsicHeight();
        } else {
            this.drawableWidth = -1;
            this.drawableHeight = -1;
        }
        this.resize = bl;
        this.updateImageMatrix();
    }
}

