/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import org.mozilla.gecko.R;

public class RecyclerViewClickSupport {
    private final RecyclerView mRecyclerView;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (RecyclerViewClickSupport.this.mOnItemClickListener != null) {
                RecyclerView.ViewHolder viewHolder = RecyclerViewClickSupport.this.mRecyclerView.getChildViewHolder(view);
                RecyclerViewClickSupport.this.mOnItemClickListener.onItemClicked(RecyclerViewClickSupport.this.mRecyclerView, viewHolder.getAdapterPosition(), view);
            }
        }
    };
    private View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View view) {
            if (RecyclerViewClickSupport.this.mOnItemLongClickListener != null) {
                RecyclerView.ViewHolder viewHolder = RecyclerViewClickSupport.this.mRecyclerView.getChildViewHolder(view);
                return RecyclerViewClickSupport.this.mOnItemLongClickListener.onItemLongClicked(RecyclerViewClickSupport.this.mRecyclerView, viewHolder.getAdapterPosition(), view);
            }
            return false;
        }
    };
    private RecyclerView.OnChildAttachStateChangeListener mAttachListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (RecyclerViewClickSupport.this.mOnItemClickListener != null) {
                view.setOnClickListener(RecyclerViewClickSupport.this.mOnClickListener);
            }
            if (RecyclerViewClickSupport.this.mOnItemLongClickListener != null) {
                view.setOnLongClickListener(RecyclerViewClickSupport.this.mOnLongClickListener);
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
        }
    };

    private RecyclerViewClickSupport(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setTag(R.id.recycler_view_click_support, (Object)this);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mAttachListener);
    }

    public static RecyclerViewClickSupport addTo(RecyclerView recyclerView) {
        RecyclerViewClickSupport recyclerViewClickSupport = (RecyclerViewClickSupport)recyclerView.getTag(R.id.recycler_view_click_support);
        if (recyclerViewClickSupport == null) {
            recyclerViewClickSupport = new RecyclerViewClickSupport(recyclerView);
        }
        return recyclerViewClickSupport;
    }

    public static RecyclerViewClickSupport removeFrom(RecyclerView recyclerView) {
        RecyclerViewClickSupport recyclerViewClickSupport = (RecyclerViewClickSupport)recyclerView.getTag(R.id.recycler_view_click_support);
        if (recyclerViewClickSupport != null) {
            recyclerViewClickSupport.detach(recyclerView);
        }
        return recyclerViewClickSupport;
    }

    public RecyclerViewClickSupport setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return this;
    }

    public RecyclerViewClickSupport setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
        return this;
    }

    private void detach(RecyclerView recyclerView) {
        recyclerView.removeOnChildAttachStateChangeListener(this.mAttachListener);
        recyclerView.setTag(R.id.recycler_view_click_support, null);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClicked(RecyclerView var1, int var2, View var3);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(RecyclerView var1, int var2, View var3);
    }
}

