/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget.themed;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.lwt.LightweightTheme;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.util.DrawableUtil;

public class ThemedImageView
extends ImageView
implements LightweightTheme.OnChangeListener {
    private LightweightTheme mTheme;
    private static final int[] STATE_PRIVATE_MODE = new int[]{R.attr.state_private};
    private static final int[] STATE_LIGHT = new int[]{R.attr.state_light};
    private static final int[] STATE_DARK = new int[]{R.attr.state_dark};
    protected static final int[] PRIVATE_PRESSED_STATE_SET = new int[]{R.attr.state_private, 16842919};
    protected static final int[] PRIVATE_FOCUSED_STATE_SET = new int[]{R.attr.state_private, 16842908};
    protected static final int[] PRIVATE_STATE_SET = new int[]{R.attr.state_private};
    private boolean mIsPrivate;
    private boolean mIsLight;
    private boolean mIsDark;
    private boolean mAutoUpdateTheme;
    private ColorStateList mDrawableColors;

    public ThemedImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize(context, attributeSet, 0);
    }

    public ThemedImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize(context, attributeSet, n);
    }

    private void initialize(Context context, AttributeSet attributeSet, int n) {
        Context context2 = context.getApplicationContext();
        if (context2 instanceof GeckoApplication) {
            this.mTheme = ((GeckoApplication)context2).getLightweightTheme();
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LightweightTheme);
        this.mAutoUpdateTheme = this.mTheme != null && typedArray.getBoolean(R.styleable.LightweightTheme_autoUpdateTheme, true);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.ThemedView, n, 0);
        this.mDrawableColors = typedArray2.getColorStateList(R.styleable.ThemedView_drawableTintList);
        typedArray2.recycle();
        this.setTintedImageDrawable(this.getDrawable());
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAutoUpdateTheme) {
            this.mTheme.addListener(this);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAutoUpdateTheme) {
            this.mTheme.removeListener(this);
        }
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mIsPrivate) {
            ThemedImageView.mergeDrawableStates((int[])nArray, (int[])STATE_PRIVATE_MODE);
        } else if (this.mIsLight) {
            ThemedImageView.mergeDrawableStates((int[])nArray, (int[])STATE_LIGHT);
        } else if (this.mIsDark) {
            ThemedImageView.mergeDrawableStates((int[])nArray, (int[])STATE_DARK);
        }
        return nArray;
    }

    @Override
    public void onLightweightThemeChanged() {
        if (this.mAutoUpdateTheme && this.mTheme.isEnabled()) {
            this.setTheme(this.mTheme.isLightTheme());
        }
    }

    @Override
    public void onLightweightThemeReset() {
        if (this.mAutoUpdateTheme) {
            this.resetTheme();
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public boolean isPrivateMode() {
        return this.mIsPrivate;
    }

    public void setPrivateMode(boolean bl) {
        if (this.mIsPrivate != bl) {
            this.mIsPrivate = bl;
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void setTheme(boolean bl) {
        if (bl && this.mIsLight != bl || !bl && this.mIsDark == bl) {
            if (bl) {
                this.mIsLight = true;
                this.mIsDark = false;
            } else {
                this.mIsLight = false;
                this.mIsDark = true;
            }
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void resetTheme() {
        if (this.mIsLight || this.mIsDark) {
            this.mIsLight = false;
            this.mIsDark = false;
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void setAutoUpdateTheme(boolean bl) {
        if (this.mTheme == null) {
            return;
        }
        if (this.mAutoUpdateTheme != bl) {
            this.mAutoUpdateTheme = bl;
            if (this.mAutoUpdateTheme) {
                this.mTheme.addListener(this);
            } else {
                this.mTheme.removeListener(this);
            }
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.setTintedImageDrawable(drawable2);
    }

    private void setTintedImageDrawable(Drawable drawable2) {
        Object object = this.mDrawableColors == null ? drawable2 : (drawable2 == null ? null : DrawableUtil.tintDrawableWithStateList((Drawable)drawable2, (ColorStateList)this.mDrawableColors));
        super.setImageDrawable(object);
    }

    public ColorDrawable getColorDrawable(int n) {
        return new ColorDrawable(ColorUtils.getColor((Context)this.getContext(), (int)n));
    }

    protected LightweightTheme getTheme() {
        return this.mTheme;
    }
}

