/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import org.mozilla.gecko.annotation.WebRTCJNITarget;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@WebRTCJNITarget
class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack;
    private AudioTrackThread audioThread = null;

    WebRtcAudioTrack(Context context, long l) {
        WebRtcAudioTrack.Logd("ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioTrack = l;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private int InitPlayout(int n, int n2) {
        WebRtcAudioTrack.Logd("InitPlayout(sampleRate=" + n + ", channels=" + n2 + ")");
        int n3 = n2 * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * (n / 100));
        WebRtcAudioTrack.Logd("byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        int n4 = AudioTrack.getMinBufferSize((int)n, (int)4, (int)2);
        WebRtcAudioTrack.Logd("AudioTrack.getMinBufferSize: " + n4);
        WebRtcAudioTrack.assertTrue(this.audioTrack == null);
        WebRtcAudioTrack.assertTrue(this.byteBuffer.capacity() < n4);
        try {
            this.audioTrack = new AudioTrack(0, n, 4, 2, n4, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WebRtcAudioTrack.Logd(illegalArgumentException.getMessage());
            return -1;
        }
        WebRtcAudioTrack.assertTrue(this.audioTrack.getState() == 1);
        WebRtcAudioTrack.assertTrue(this.audioTrack.getPlayState() == 1);
        WebRtcAudioTrack.assertTrue(this.audioTrack.getStreamType() == 0);
        return 1000 * (n4 / n3) / n;
    }

    private boolean StartPlayout() {
        WebRtcAudioTrack.Logd("StartPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean StopPlayout() {
        WebRtcAudioTrack.Logd("StopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        return true;
    }

    private int GetStreamMaxVolume() {
        WebRtcAudioTrack.Logd("GetStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean SetStreamVolume(int n) {
        WebRtcAudioTrack.Logd("SetStreamVolume(" + n + ")");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (WebRtcAudioUtils.runningOnLollipopOrHigher() && this.audioManager.isVolumeFixed()) {
            WebRtcAudioTrack.Loge("The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n, 0);
        return true;
    }

    private int GetStreamVolume() {
        WebRtcAudioTrack.Logd("GetStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private static void Logd(String string) {
        Log.d((String)TAG, (String)string);
    }

    private static void Loge(String string) {
        Log.e((String)TAG, (String)string);
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            WebRtcAudioTrack.Logd("AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack.Loge("AudioTrack.play failed: " + illegalStateException.getMessage());
                return;
            }
            int n = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(n, WebRtcAudioTrack.this.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n <= WebRtcAudioTrack.this.byteBuffer.remaining());
                int n2 = 0;
                n2 = WebRtcAudioUtils.runningOnLollipopOrHigher() ? WebRtcAudioTrack.this.audioTrack.write(WebRtcAudioTrack.this.byteBuffer, n, 0) : WebRtcAudioTrack.this.audioTrack.write(WebRtcAudioTrack.this.byteBuffer.array(), WebRtcAudioTrack.this.byteBuffer.arrayOffset(), n);
                if (n2 != n) {
                    WebRtcAudioTrack.Loge("AudioTrack.write failed: " + n2);
                    if (n2 == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack.Loge("AudioTrack.stop failed: " + illegalStateException.getMessage());
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

